PRO gb_hydra_current, mom_data, cur_data

; PURPOSE:  Fill the fields cur_data.cp_delb
;                           cur_data.cp_bmag_avg
;                           cur_data.cp_delta_b_over_b 
;                           cur_data.cp_curl
;                              for use in cs_hydra_current.pro
common hydra_bfield_data, $
  bfield_type, $
  bfield_header, $
  bfield_lr_data, $
  bfield_mr_data, $
  bfield_hr_data, $
  bfield_ppar_data

rfill = -1.e+31

myname = 'gb_hydra_current'

cp_delb = fltarr(n_elements(mom_data.time)) + rfill
cp_bmag_avg = fltarr(n_elements(mom_data.time)) + rfill
cp_delta_b_over_b = fltarr(n_elements(mom_data.time)) + rfill
cp_curl = fltarr(n_elements(mom_data.time)) + rfill

; Look to see if a 'quick-fix' idl saveset has been created
; in order to bypass the below calculation

date = cur_data(0).date
ss_dir = getenv('HYD_PAPCO_SCRATCH_DATA')
if (ss_dir eq '') then begin
    message, 'HYD_PAPCO_SCRATCH_DATA environment variable not set', /cont
    message, 'Not able to access the save set even if it exists', /cont
    saveset = ''
endif else begin
    filename = ss_dir+date+'_Moments_J_PaPCo.idlsav'
    saveset = findfile(filename)
endelse

if (saveset(0) ne '') then begin
    creation_date = 0.
    level1_data_version = 0.
    ddcal_data_version = 0.
    cp_delb_24 = 0.
    cp_bmag_avg_24 = 0.
    cp_delta_b_over_b_24 = 0.
    cp_curl_24 = 0.
    t_24 = 0.                   ; This time is in seconds-since-midnight (ssm)
    restore, saveset(0), /verbose
    
    cp_delb = interpol(cp_delb_24, t_24, mom_data.time_ssm)
    cp_bmag_avg = interpol(cp_bmag_avg_24, t_24, mom_data.time_ssm)
    cp_delta_b_over_b = interpol(cp_delta_b_over_b_24, t_24, mom_data.time_ssm)
    cp_curl = interpol(cp_curl_24, t_24, mom_data.time_ssm)

    creation_date = 0.
    level1_data_version = 0.
    ddcal_data_version = 0.
    cp_delb_24 = 0.
    cp_bmag_avg_24 = 0.
    cp_delta_b_over_b_24 = 0.
    cp_curl_24 = 0.
    t_24 = 0.
    
endif else begin
    
    message, 'No save set exists...Talk to Pam if you want one to...',/cont
    message, 'Prepping bfield quantities for J diagnostics...',/cont
    
; Generate 8Hz magnetic field data for this time period (needed for delb)
    bfield_type = 1
    r_hydra_bfield, options=7
    nu8 = 8.
    
; Define the magnetic field to be used below
    bvalid = bfield_mr_data.bvalid*(bfield_mr_data.bflags EQ 0)
    rv = where(bvalid EQ 1 AND bfield_mr_data.time NE 0)
    t = bfield_mr_data(rv).time ;This time is in seconds since start_time (ssst)
    bx = bfield_mr_data(rv).bx_pay
    by = bfield_mr_data(rv).by_pay
    bz = bfield_mr_data(rv).bz_pay
    
    ntime = n_elements(mom_data.time)
    ileft = 0L
    iright = n_elements(bx)-1
    istart = 0L
    istop = 0L
    tindex_max = long(n_elements(bx)-1)
    novershoot = lonarr(ntime)
    novershoot(0:ntime-2) = long((mom_data(1:ntime-1).time-mom_data(0:ntime-2).time)*(nu8+1.) + 100)
    novershoot(ntime-1) = 10000
    
    message, 'Using 8Hz B to calculate parameters for current length scales...',/cont
    
    FOR itime=0L,n_elements(mom_data.time)-1 DO BEGIN
        
        rng = lindgen(iright-ileft+1) + ileft
        il = (where(t(rng) ge mom_data(itime).time))(0)
        ir = (where(t(rng) gt mom_data(itime).time+13.8))(0) ; mom_data.time is in ssst
        if (il eq -1 or ir eq -1 or il eq ir) then begin
            
            cp_delb(itime) = rfill
            cp_bmag_avg(itime) = rfill
            cp_delta_b_over_b(itime) = rfill
            cp_curl(itime) = rfill
            
        ENDIF ELSE BEGIN
            
            istart = rng(il)
            istop = rng(ir)
            ileft = istop
            iright = ileft + novershoot(itime) < tindex_max
            istop = istop-1     ; Want times INSIDE bracket
            
            nsamp = long(istop-istart+1)

            if (nsamp le 1) then begin

                cp_delb(itime) = rfill
                cp_bmag_avg(itime) = rfill
                cp_delta_b_over_b(itime) = rfill
                cp_curl(itime) = rfill

            endif else begin
                
                inside = lindgen(nsamp) + istart
                
;         print, 'TIME DIFF: ',t(istop)-t(istart),'  TIMES: ',mom_data(itime).time,t(istart),t(istop)
                
; current parameters (cp) variables
                bmag1=sqrt(bx(istart)^2+by(istart)^2+bz(istart)^2)*1.d-9*1.d+4 ;gauss
                bmag2=sqrt(bx(istop)^2+by(istop)^2+bz(istop)^2)*1.d-9*1.d+4 ;gauss
                cp_bmag_avg(itime) = (bmag1+bmag2)/2. ;gauss
                cp_delb(itime) = abs(bmag2-bmag1) ;gauss
                if (cp_bmag_avg(itime) ne 0.) then cp_delta_b_over_b(itime) = cp_delb(itime)/cp_bmag_avg(itime) else cp_delta_b_over_b(itime) = rfill
                
; What is the average field from all of the measurements in this
; time period, and the unit vector?
                bavg = [total(bx(inside))/float(nsamp), $
                        total(by(inside))/float(nsamp), $
                        total(bz(inside))/float(nsamp)]
                bmag = sqrt(total(bavg^2))
                bhat = bavg/bmag
                
; Find the components of the high res. measurments which are
; perpendicular to the average vector
                bperp = fltarr(3,nsamp)
                FOR ii=0,nsamp-1 DO BEGIN
                    imeas = inside(ii)
                    dot = bx(imeas)*bhat(0) + by(imeas)*bhat(1) + bz(imeas)*bhat(2)
                    bperp(0,ii) = bx(imeas) - dot*bhat(0)
                    bperp(1,ii) = by(imeas) - dot*bhat(1)
                    bperp(2,ii) = bz(imeas) - dot*bhat(2)
                ENDFOR 
                bperpmag = sqrt(total(bperp^2,1))
                
; Find dsign = sign( (bperp(i) X bperp(i+1)) dot bhat )
                dsign = intarr(nsamp-1)
                FOR ii=0,nsamp-2 DO BEGIN
                    D = crossp(bperp(*,ii),bperp(*,ii+1))
                    dot = total(D*bhat)
                    IF (dot LT 0) THEN dsign(ii) = -1 ELSE dsign(ii) = 1
                ENDFOR
                
; Find curl = < dsign * bperpmag >
                curl = total( dsign(0:nsamp-2)*bperpmag(0:nsamp-2) )/float(nsamp-1)
                cp_curl(itime) = curl*1.d-9*1.d+4 ;gauss

            endelse
            
        ENDELSE
        
        
    ENDFOR

endelse
    
cur_data.cp_delb = cp_delb
cur_data.cp_bmag_avg = cp_bmag_avg
cur_data.cp_delta_b_over_b = cp_delta_b_over_b
cur_data.cp_curl = cp_curl

message, 'DONE', /cont

return
END ;=====================================================================

PRO cs_hydra_current_pre_19991118, date, mom_data, cur_data
   
   myname = 'cs_hydra_current'
   
; Fill the 'cp' variables
   gb_hydra_current, mom_data, cur_data
   
   rfill = -1.e+31
   
; Define the measurement threshhold for velocity
   te = 1./3.*(mom_data.ktparl_ele*1.6d-12/1.4d-16 + $
               2.*mom_data.ktperp_ele*1.6d-12/1.4d-16) ; K
   norm_tot = 25.*sqrt(te/2.d+5) ; km/s
   norm_parl = 25.*sqrt(te/2.d+5) ; km/s
   norm_perp = sqrt(2.)*norm_parl ; km/s
   
; Define utot_pay to be the difference between uion and uele (in preparation
; for J) (2/2/99 actually, utot is NOT used for any of the current
; density calculations anymore!  This was the wrong way to do it because you
; were assuming that the ion and ele densities are equal.)
; and apply a filter based on detection level.
; Filter out those measurements with ANY COMPONENT too small to be
; detected - i.e. if 1 component is found too small to be
; detected, zero only that component.  Do this only for payload,
; rotations to other coordinate systems might produce small components
; that are perfectly valid (per JDS discussion, 5/19/98)
   utot_pay = mom_data.u_pay_ion - mom_data.u_pay_ele
   ue_pay = mom_data.u_pay_ele
   ui_pay = mom_data.u_pay_ion
   
   filter_mag = 1.
   nezero = where(norm_tot ne 0.)
   FOR ii=0,2 DO BEGIN
       bad = where(abs(reform(utot_pay(ii,nezero)))/norm_tot(nezero) LT filter_mag)
       IF (bad(0) NE -1) THEN BEGIN
           utot_pay(ii,nezero(bad)) = 0.0
           ue_pay(ii,nezero(bad)) = 0.0
           ui_pay(ii,nezero(bad)) = 0.0
       ENDIF
   ENDFOR
   utot_pay(3,*) = sqrt(total(utot_pay(0:2,*)^2,1,/double))
   
; Transform to GSM
   hydra_payload_to_gsm,date,mom_data.time_ssm,utot_pay,utot_gsm,istat,rate=1
   hydra_payload_to_gsm,date,mom_data.time_ssm,ue_pay,ue_gsm,istat,rate=1
   hydra_payload_to_gsm,date,mom_data.time_ssm,ui_pay,ui_gsm,istat,rate=1
   
; Transform to GSE
   hydra_payload_to_gse,date,mom_data.time_ssm,utot_pay,utot_gse,istat,rate=1
   hydra_payload_to_gse,date,mom_data.time_ssm,ue_pay,ue_gse,istat,rate=1
   hydra_payload_to_gse,date,mom_data.time_ssm,ui_pay,ui_gse,istat,rate=1
   
   b_pay = mom_data.b_pay
   b_pay_sig = mom_data.b_pay_sig
   b_gsm = mom_data.b_gsm
   b_angle_cone = mom_data.b_angle_cone
   
; Sanity check
;   print, '*************MAGNETIC FIELD MAGNITUDE**********'
;   print, b_pay(3,*)-b_gsm(3,*)
;   print, '*************UTOT MAGNITUDE**********'
;   print, utot_pay(3,*)-utot_gsm(3,*) ; Could be different because of S/C velocity
;   print, utot_pay(3,*)-utot_gse(3,*) ; Could be different because of S/C velocity
;   print, utot_gsm(3,*)-utot_gse(3,*) ; 
;   stop
   
; Need a data filter so that 1) we don't divide by bmag=0. 
                                ; (This was causing some
                                ; infinities which made the plot
                                ; routine croak...3/26/99)
   
   bgd = where(b_pay(3,*) ne 0.) ; and utot_pay(3,*) ne 0.)
   
   utot_parl = fltarr(n_elements(utot_pay(0,*))) + rfill
   utot_parl(bgd) = 1./(b_pay(3,bgd))*(utot_pay(0,bgd)*b_pay(0,bgd) + utot_pay(1,bgd)*b_pay(1,bgd) + utot_pay(2,bgd)*b_pay(2,bgd)) ;km/s
   
   ue_parl = fltarr(n_elements(utot_pay(0,*))) + rfill
   ue_parl(bgd) = 1./(b_pay(3,bgd))*(ue_pay(0,bgd)*b_pay(0,bgd) + ue_pay(1,bgd)*b_pay(1,bgd) + ue_pay(2,bgd)*b_pay(2,bgd)) ;km/s
   
   ui_parl = fltarr(n_elements(utot_pay(0,*))) + rfill
   ui_parl(bgd) = 1./(b_pay(3,bgd))*(ui_pay(0,bgd)*b_pay(0,bgd) + ui_pay(1,bgd)*b_pay(1,bgd) + ui_pay(2,bgd)*b_pay(2,bgd)) ;km/s
   
   utot_perp_pay =  fltarr(4,n_elements(mom_data.time)) + rfill
   utot_perp_gsm =  fltarr(4,n_elements(mom_data.time)) + rfill
   ue_perp_pay = fltarr(4,n_elements(mom_data.time)) + rfill
   ue_perp_gsm = fltarr(4,n_elements(mom_data.time)) + rfill
   ui_perp_pay = fltarr(4,n_elements(mom_data.time)) + rfill
   ui_perp_gsm = fltarr(4,n_elements(mom_data.time)) + rfill
   
;=========PAYLOAD=================
   for ic=0,2 do begin          ; By component because of the 1D mag division
       utot_perp_pay(ic,bgd)=utot_pay(ic,bgd)-utot_parl(bgd)*b_pay(ic,bgd)/b_pay(3,bgd) ;kms
       ue_perp_pay(ic,bgd) =  ue_pay(ic,bgd) - ue_parl(bgd)*b_pay(ic,bgd)/b_pay(3,bgd) ;km/s
       ui_perp_pay(ic,bgd) =  ui_pay(ic,bgd) - ui_parl(bgd)*b_pay(ic,bgd)/b_pay(3,bgd) ;km/s
   endfor
   utot_perp_pay(3,bgd) =  sqrt(total(utot_perp_pay(0:2,bgd)^2, 1, /double)) ;km/s
   ue_perp_pay(3,bgd) =  sqrt(total(ue_perp_pay(0:2,bgd)^2, 1, /double)) ;km/s
   ui_perp_pay(3,bgd) =  sqrt(total(ui_perp_pay(0:2,bgd)^2 , 1, /double)) ;km/s
   
;=========GSM======================
   for ic=0,2 do begin          ; By component because of the 1D mag division
       utot_perp_gsm(ic,bgd)=utot_gsm(ic,bgd)-utot_parl(bgd)*b_gsm(ic,bgd)/b_gsm(3,bgd) ;kms
       ue_perp_gsm(ic,bgd) =  ue_gsm(ic,bgd) - ue_parl(bgd)*b_gsm(ic,bgd)/b_gsm(3,bgd) ;km/s
       ui_perp_gsm(ic,bgd) =  ui_gsm(ic,bgd) - ui_parl(bgd)*b_gsm(ic,bgd)/b_gsm(3,bgd) ;km/s
   endfor
   utot_perp_gsm(3,bgd) =  sqrt(total(utot_perp_gsm(0:2,bgd)^2, 1, /double)) ;km/s
   ue_perp_gsm(3,bgd) =  sqrt(total(ue_perp_gsm(0:2,bgd)^2, 1, /double)) ;km/s
   ui_perp_gsm(3,bgd) =  sqrt(total(ui_perp_gsm(0:2,bgd)^2, 1, /double)) ;km/s
   
; Current density (charge*ele_density*utot_parl)
;                 (charge*ele_density*utot_perp)
   charge = 1.6d-19*3.d+9       ; e.s.u.
   conversion = 1.d+5           ; km/s to cm/s
   cgs2mapms = 1.6d-19/charge*100.^2*1.d+6 ; e.s.u/s/cm^2 to microAmps/meter^2
   
; j_parl
;;2/2/99   cur_data.j_parl = charge*mom_data.density_ele*reform(utot_parl)*conversion ; gaussian
   cur_data(bgd).j_parl =conversion*charge*(mom_data(bgd).density_ion* $
                                            reform(ui_parl(bgd)) - $
                                            mom_data(bgd).density_ele* $
                                            reform(ue_parl(bgd)))*cgs2mapms ; micro Amps/meter^2

   
   openw, unit, 'cs_hydra_current_data.txt', /get_lun
   for ii = 0, n_elements(bgd)-1 do begin
       printf, unit, mom_data(bgd(ii)).time_ssm, $
         ue_pay(0,bgd(ii)), ue_pay(1,bgd(ii)), ue_pay(2,bgd(ii)), $
         ui_pay(0,bgd(ii)), ui_pay(1,bgd(ii)), ui_pay(2,bgd(ii)), $
         b_pay(0,bgd(ii)),b_pay(1,bgd(ii)),b_pay(2,bgd(ii)),b_pay(3,bgd(ii)), $
         mom_data(bgd(ii)).density_ion, mom_data(bgd(ii)).density_ele, $
         conversion*charge*mom_data(bgd(ii)).density_ion* $
         ui_parl(bgd(ii))*cgs2mapms, $
         conversion*charge*(-1.)*mom_data(bgd(ii)).density_ele* $
         ue_parl(bgd(ii))*cgs2mapms, $
         cur_data(bgd(ii)).j_parl
   endfor
   close, unit
   free_lun, unit
   
   cur_data(bgd).utot_parl = reform(utot_parl(bgd))/norm_parl(bgd) ; normalized
   
   FOR icomp=0,2 DO BEGIN       ; By component because of the 1D density array
       
; j_perp_pay
;;2/2/99       cur_data(*).j_perp_pay(icomp) =
;;charge*mom_data(*).density_ele*utot_perp_pay(icomp,*)*conversion ;
;;gaussian
       cur_data(bgd).j_perp_pay(icomp) = conversion*charge*(mom_data(bgd).density_ion*ui_perp_pay(icomp,bgd) - mom_data(bgd).density_ele*ue_perp_pay(icomp,bgd))*cgs2mapms ; micro Amps/meter^2
       
       cur_data(bgd).utot_perp_pay(icomp) = reform(utot_perp_pay(icomp,bgd))/norm_perp(bgd) ; norm
       
; j_perp_gsm
;;2/2/99       cur_data(*).j_perp_gsm(icomp) =
;;charge*mom_data(*).density_ele*utot_perp_gsm(icomp,*)*conversion ;
;;gaussian
       cur_data(bgd).j_perp_gsm(icomp) = conversion*charge*(mom_data(bgd).density_ion*ui_perp_gsm(icomp,bgd) - mom_data(bgd).density_ele*ue_perp_gsm(icomp,bgd))*cgs2mapms ; micro Amps/meter^2
       
       cur_data(bgd).utot_perp_gsm(icomp) = reform(utot_perp_gsm(icomp,bgd))/norm_perp(bgd) ; norm
       
; j_gse
;2/2/99       cur_data(*).j_gse(icomp) = charge*mom_data(*).density_ele*utot_gse(icomp,*)*conversion ; gaussian
       cur_data(bgd).j_gse(icomp) = conversion*charge*(mom_data(bgd).density_ion*ui_gse(icomp,bgd) - mom_data(bgd).density_ele*ue_gse(icomp,bgd))*cgs2mapms ; micro Amps/meter^2
; j_gsm
;;2/2/99       cur_data(*).j_gsm(icomp) = charge*mom_data(*).density_ele*utot_gsm(icomp,*)*conversion ; gaussian
       cur_data(bgd).j_gsm(icomp) = conversion*charge*(mom_data(bgd).density_ion*ui_gsm(icomp,bgd) - mom_data(bgd).density_ele*ue_gse(icomp,bgd))*cgs2mapms ; micro Amps/meter^2
       
   ENDFOR
   cur_data(bgd).j_perp_pay(3) = sqrt(total(cur_data(bgd).j_perp_pay(0:2)^2,1,/double))
   cur_data(bgd).utot_perp_pay(3) = sqrt(total(cur_data(bgd).utot_perp_pay(0:2)^2,1,/double))
   cur_data(bgd).j_perp_gsm(3) = sqrt(total(cur_data(bgd).j_perp_gsm(0:2)^2,1,/double))
   cur_data(bgd).utot_perp_gsm(3) = sqrt(total(cur_data(bgd).utot_perp_gsm(0:2)^2,1,/double))
   cur_data(bgd).j_gse(3) = sqrt(total(cur_data(bgd).j_gse(0:2)^2,1,/double))
   cur_data(bgd).j_gsm(3) = sqrt(total(cur_data(bgd).j_gsm(0:2)^2,1,/double))
   
; Length scale of current
   charge = 1.6d-19*3.d+9       ; e.s.u.
   clight = 3.d+10              ; cm/s
   mion = 1.67d-24              ; g
   mele = 9.1d-28               ; g
   kt_ion = mom_data.mean_energy_ion*1.6d-12 ; erg
   kt_ele = mom_data.mean_energy_ele*1.6d-12 ; erg
   den_ion = mom_data.density_ion ; cm-3
   den_ele = mom_data.density_ele ; cm-3
   
   FOR itime=0,n_elements(mom_data.time)-1 DO BEGIN
;;2/2/99      j_perp_mag = cur_data(itime).j_perp_pay(3)
       j_perp_mag = cur_data(itime).j_perp_pay(3)/cgs2mapms ; cgs
       vth_ion = sqrt(2*kt_ion(itime)/mion) ; cm/s
       vth_ele = sqrt(2*kt_ele(itime)/mele) ; cm/s
       inert_ion = clight/(4.*!pi*den_ion(itime)*charge^2/mion)^(.5)
       inert_ele = clight/(4.*!pi*den_ele(itime)*charge^2/mele)^(.5)
       IF (cur_data(itime).j_perp_pay(3) NE rfill and cur_data(itime).j_perp_pay(3) ne 0. AND cur_data(itime).cp_bmag_avg NE rfill) THEN BEGIN
           rgyro_ion = mion*clight/(charge*cur_data(itime).cp_bmag_avg)* $
             vth_ion            ; cm
           rgyro_ele = mele*clight/(charge*cur_data(itime).cp_bmag_avg)* $
             vth_ele            ; cm
           cur_data(itime).cls = cur_data(itime).cp_delb*clight/ $
             (4.*!pi*j_perp_mag)/1.d+5 ; km, out
           cls = cur_data(itime).cls*1.d+5 ; cm
           cur_data(itime).cls_rgyro_ion = cls/rgyro_ion
           cur_data(itime).cls_rgyro_ele = cls/rgyro_ele
           cur_data(itime).cls_inert_ion = cls/inert_ion
           cur_data(itime).cls_inert_ele = cls/inert_ele
           cur_data(itime).rgyro_ion = rgyro_ion/1.d+5 ;km, out
           cur_data(itime).rgyro_ele = rgyro_ele/1.d+5 ;km, out
           cur_data(itime).inert_ion = inert_ion/1.d+5 ;km, out
           cur_data(itime).inert_ele = inert_ele/1.d+5 ;km, out
       ENDIF ELSE IF ((cur_data(itime).j_perp_pay(3) EQ rfill or cur_data(itime).j_perp_pay(3) eq 0.) AND $
                      cur_data(itime).cp_bmag_avg NE rfill) THEN BEGIN 
           cur_data(itime).cls = rfill
           cur_data(itime).cls_rgyro_ion = rfill
           cur_data(itime).cls_rgyro_ele = rfill
           cur_data(itime).cls_inert_ion = rfill
           cur_data(itime).cls_inert_ele = rfill
           rgyro_ion = mion*clight/(charge*cur_data(itime).cp_bmag_avg)* $
             vth_ion            ; cm
           rgyro_ele = mele*clight/(charge*cur_data(itime).cp_bmag_avg)* $
             vth_ele            ; cm
           cur_data(itime).rgyro_ion = rgyro_ion/1.d+5 ;km, out
           cur_data(itime).rgyro_ele = rgyro_ele/1.d+5 ;km, out
           cur_data(itime).inert_ion = inert_ion/1.d+5 ;km, out
           cur_data(itime).inert_ele = inert_ele/1.d+5 ;km, out
       ENDIF ELSE BEGIN 
           cur_data(itime).cls = rfill
           cur_data(itime).cls_rgyro_ion = rfill
           cur_data(itime).cls_rgyro_ele = rfill
           cur_data(itime).cls_inert_ion = rfill
           cur_data(itime).cls_inert_ele = rfill
           cur_data(itime).rgyro_ion = rfill
           cur_data(itime).rgyro_ele = rfill
           cur_data(itime).inert_ion = inert_ion/1.d+5 ;km, out
           cur_data(itime).inert_ele = inert_ele/1.d+5 ;km, out
       ENDELSE
       
; Parallel current length scales (cls_parl)
       
;;2/2/99       j_parl = cur_data(itime).j_parl
       j_parl = cur_data(itime).j_parl/cgs2mapms
       
       IF ((cur_data(itime).j_parl ne rfill) AND $
           (cur_data(itime).j_parl ne 0.) and $
           (cur_data(itime).cp_curl NE rfill) AND $
           (j_parl*cur_data(itime).cp_curl gt 0)) THEN BEGIN
           
           cur_data(itime).cls_parl = clight*cur_data(itime).cp_curl/ $
             (4.*!pi*j_parl)/1.d+5 ;km, out
           
           IF (cur_data(itime).inert_ion NE rfill) THEN $
             cur_data(itime).cls_parl_inert_ion = cur_data(itime).cls_parl / $
             cur_data(itime).inert_ion
           
           IF (cur_data(itime).inert_ele NE rfill) THEN $
             cur_data(itime).cls_parl_inert_ele = cur_data(itime).cls_parl / $
             cur_data(itime).inert_ele
           
           IF (cur_data(itime).rgyro_ion NE rfill) THEN $
             cur_data(itime).cls_parl_rgyro_ion = cur_data(itime).cls_parl / $
             cur_data(itime).rgyro_ion
           
           IF (cur_data(itime).rgyro_ele NE rfill) THEN $
             cur_data(itime).cls_parl_rgyro_ele = cur_data(itime).cls_parl / $
             cur_data(itime).rgyro_ele
           
       ENDIF ELSE BEGIN
           cur_data(itime).cls_parl = rfill
           cur_data(itime).cls_parl_rgyro_ion = rfill
           cur_data(itime).cls_parl_rgyro_ele = rfill
           cur_data(itime).cls_parl_inert_ion = rfill
           cur_data(itime).cls_parl_inert_ele = rfill
       ENDELSE 
       
       
   ENDFOR
   
; Total pressure
   nf = 1.d-8                   ; ergs/cm3 to nPa, divisor
   parl_ele_pressure = mom_data.density_ele*mom_data.ktparl_ele*1.6d-12/nf ;nPa
   perp_ele_pressure = mom_data.density_ele*mom_data.ktperp_ele*1.6d-12/nf ;nPa
   parl_ion_pressure = mom_data.density_ion*mom_data.ktparl_ion*1.6d-12/nf ;nPa
   perp_ion_pressure = mom_data.density_ion*mom_data.ktperp_ion*1.6d-12/nf ;nPa
   magnetic_pressure = reform((b_pay(3,*)*1.d-9*1.d+4)^2/(8*!pi))/nf ;nPa
   
   cur_data.total_parl_particle_pressure=parl_ele_pressure + parl_ion_pressure
   cur_data.total_perp_particle_pressure=perp_ele_pressure + perp_ion_pressure
   cur_data.total_particle_pressure = 1./3.* $
     (2.*cur_data.total_perp_particle_pressure + $
      cur_data.total_parl_particle_pressure)
   cur_data.total_magnetic_pressure = magnetic_pressure
   
; total_pressure is just perp pressure + magnetic pressure ! (no parl!)
   cur_data.total_pressure = cur_data.total_perp_particle_pressure + $
     cur_data.total_magnetic_pressure
   
   cur_data.total_anisotropy = cur_data.total_parl_particle_pressure/$
     cur_data.total_perp_particle_pressure
   
; Total energy flux parallel to B, and normalized by B
   cur_data.total_eflux_parl = mom_data.eflux_parl_ion + mom_data.eflux_parl_ele ; ergs/cm^2/s

   gd = where(b_pay(3,*) ne 0.)
   cur_data(gd).total_eflux_parl_over_b = cur_data(gd).total_eflux_parl/reform(b_pay(3,gd)) ; ergs/cm^2/s/nT
   
   message, 'DONE', /cont
;*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_
   
   return
END



