pro hyd_err_panel, msg, panel
;   display ledgible message in a box
  plot, [0,1], [0,1], /nodata, xstyle=5, ystyle=5
  oplot, [0,1,1,0,0], [0,0,1,1,0], /noclip, color=1
  msg1= ''
  for i=0,n_elements(msg)-1 do begin
      msg1= msg1+'!c'+msg(i)
  endfor

  w=999
  charsize_fac=2.0
  while w gt 0.6 do begin
      xyouts, 0.03, 1, msg1, charsize=-1*!p.charsize*charsize_fac, color=1, width=w
      charsize_fac= charsize_fac/1.1
      print, w
  endwhile
  xyouts, 0.03, 1, msg1, charsize=!p.charsize*charsize_fac, color=1
  
  if panel(0) eq 0 then begin
      goodticks, xtickv, xminor
      xticks=n_elements(xtickv)-1
      common time, xut1, xut2
      axis, xrange=[0,xut2-xut1], xaxis=0, $
        xticks=xticks, xtickv=xtickv, xminor=xminor, $
        xtickformat= 'hydra_timeticks'
  endif
end

