pro hydra_events, file=file, overplot=overplot, panel=panel
common time, xut1,xut2          ;common time limits in T90
common papco_color_names

if n_elements( file ) eq 0 then $
  file= '/opt/hydra/tmp_data/other_data_sets/19960529_walen_events.txt'

if n_elements( overplot ) eq 0 then overplot=1

time_str = convert_secondsToTime(xut1, /T90)

if (strlen(time_str) eq 19) then begin
    year = fix(strmid(time_str,6,4))
endif else begin
    year = fix(strmid(time_str,6,2))
    IF (year GT 90) THEN year = year+1900 ELSE year = year+2000
endelse

date_str = string(year,'(i4)')+strmid(time_str,3,2)+strmid(time_str,0,2)

pam=0
if pam then begin
; Read in data using hyd_access-----------------------------
    
    hyd_access_get_timetags, timetags, 'wln_walen_slope', gen_time( date=date_str, time='00:00' ), gen_time( date=date_str, time='24:00' )
    
    if (n_elements(timetags) eq 0) then begin
        message, 'No Walen Events File For This Day', /cont
        return
    endif
    
    hyd_access, timetags, 'time_bin_start_ssm', start_time
    hyd_access, timetags, 'time_bin_width_seconds', dt
    hyd_access, timetags, 'wln_walen_slope', alpha
    hyd_access, timetags, 'wln_bavg', b_avg
    hyd_access, timetags, 'wln_bnorm', bnorm
    hyd_access, timetags, 'wln_ele_fit_status', rdflag

; Filter out the NON-Rotational Discontinuities
    gd = where(rdflag eq 1)
    start_time = start_time(gd)
    dt = dt(gd)
    alpha = alpha(gd)
    b_avg = b_avg(gd)
    bnorm = bnorm(gd)
    rdflag = rdflag(gd)
    
;======================================================

    ntime = n_elements(start_time)
    end_time = start_time + dt
    
    title = 'Walen'
    annotation = strarr(4)
    annotation(0) = 'blue indicates alpha negative and Bn/B large.'
    annotation(1) = 'cyan indicates alpha negative and Bn/B small.'
    annotation(2) = 'magenta indicates alpha positive and Bn/B large.'
    annotation(3) = 'red indicates alpha positive and Bn/B small.'
    
; Define the color string array
    colorstr = strarr(ntime)
    b = where(alpha le 0. and abs(bnorm/b_avg) gt .5)
    c = where(alpha le 0. and abs(bnorm/b_avg) le .5)
    m = where(alpha gt 0. and abs(bnorm/b_avg) gt .5)
    r = where(alpha gt 0. and abs(bnorm/b_avg) le .5)
    if (b(0) ne -1) then colorstr(b) = 'blue'
    if (c(0) ne -1) then colorstr(c) = 'cyan'
    if (m(0) ne -1) then colorstr(m) = 'magenta'
    if (r(0) ne -1) then colorstr(r) = 'red'
    
; Create a string array that duplicates the original
; events file that was read, so that the machinery below
; will work with minimal changes

    efile_string = strarr(1 + n_elements(annotation) + ntime)
    efile_string(0) = 'title '+title
    for ii=0,n_elements(annotation)-1 do begin
        efile_string(ii+1) = '; annotation: '+annotation(ii)
    endfor
    for ii=0,ntime-1 do begin
        efile_string(ii+1+n_elements(annotation)) = $
          '. '+colorstr(ii)+' fill '+date_str+' '+ $
          string(start_time(ii),'(f10.3)')+' '+ $
          string(end_time(ii),'(f10.3)')
    endfor
endif else begin
    message, 'Reading events file '+file, /cont
    openr, unit, /get_lun, file
    s=''
    readf, unit, s
    efile_string= s 
    while not eof(unit) do begin
        readf, unit, s
        efile_string= [ efile_string, s ]
        r= where( strtrim(efile_string,2) ne '' )
        if r(0) ne -1 then efile_string= efile_string(r)
    endwhile
    close, unit
    free_lun, unit
endelse


; BELOW IS THE ORIGINAL MACHINERY=======================

s=''
text= strarr( 1 )
colors= intarr( 1 )
fill= intarr( 1 )
time_start= dblarr( 1 )
time_end= dblarr( 1 )

;  ; is comment character -- needs to be followed by space.
;  . in first column means '', no text.
;  "annotation" indicates an annotation to print behind the event bars.
annotate_line=1

for istring = 0, n_elements(efile_string)-1 do begin
    s = efile_string(istring)
    
    ss= str_sep( s, ' ' )
    r= where(ss ne '')
    if r(0) ne -1 then ss= ss(r) ; remove extra spaces
    if ss(0) eq '.' then ss(0)=''
    if strpos( strlowcase(ss(0)), 'title' ) ne -1 then begin
        title= ss(1)
    endif else if strpos( strlowcase(ss(0)), 'annotation' ) ne -1 then begin
        if not overplot then begin
            hydra_get_device_space, x0, y0, xpixels, ypixels
            aline=''
            for i=1,n_elements(ss)-1 do aline= aline + ss(i) + ' '
            xyouts, x0 + !d.x_ch_size, $
              y0 + ypixels - annotate_line * !d.y_ch_size, $
              aline, /device, color=1
            annotate_line= annotate_line + 1
        endif
    endif else begin
        if ss(0) ne ';' then begin
            text= [text,ss(0)]
            colorstr= ss(1)
            color=0             ; define the variable
            r= execute( 'color='+colorstr )
            if r eq 1 then colors= [colors,color] else begin
                message, 'unrecognized color: '+colorstr, /cont
                message, 'using 1.', /cont
                colors= [ colors,1 ]
            endelse
            fill= [ fill,ss(2) eq 'fill' ]
            timestr= strmid( ss(3),4,2 ) + '/' + $
              strmid( ss(3),6,2 ) + '/' + strmid(ss(3),0,4)+' 00:00:00 '
            r= convert_timeToSeconds( timestr, /t90 )
            time_start= [ time_start, double( r.value )+double( ss(4) ) ]
            time_end= [ time_end, double( r.value )+double( ss(5) ) ]
        endif
    endelse
    
endfor

if n_elements( title ) ne 0 then begin
    if not keyword_set( overplot ) then begin           
        right_side_label, panel, title
    endif           
endif
;   note first element is bogus

;----------------NEW MOMENTS FALL AGU 1997-----------------------
;   neg_start= [3.80658, 7.08024, 8.51774, 8.87808, 10.0702, $
;               13.5854, 14.5591, 21.5971, 22.1414]*double(3600.)  $
;     + double(202176000)        ; 5/29/96

;   neg_stop= [3.81041, 7.08408, 8.52158, 8.88191, 10.0741, $
;              13.5892, 14.5629, 21.6009, 22.1452]*double(3600.) $
;     + double(202176000)        ; 5/29/96

;   pos_start= [3.45391, 3.88708, 8.12291, 11.9217, 13.3707]*double(3600.) $
;     + double(202176000)        ; 5/29/96
   
;   pos_stop= [3.45774, 3.89091, 8.12674, 11.9256, 13.3746 ]*double(3600.) $
;     + double(202176000)        ; 5/29/96

   cyan_start= $
     [4.52341, 4.53874, 4.54641, 4.55791, 4.69208, 4.75724, $
      5.13674, 5.22874, 6.37491, 6.73908, $
      6.75441, 6.80041, 6.95758, 6.96141, $
      7.02274, 7.05724, 7.08408 ] * double(3600.) + double(202176000) + 6.9
   
   cyan_stop= $
     [4.52724, 4.54641, 4.55791, 4.56174, 4.71508, 4.76491, $
      5.14058, 5.23641, 6.38258, 6.75441, $
      6.78508, 6.80424, 6.96141, 6.96908, $
      7.03808, 7.06491, 7.09174 ] * double(3600.) + double(202176000) + 6.9

   yellow_start= $
     [4.91441, 5.23641, 5.64274, 6.80424, 6.99591, 7.03808 ] * $
     double(3600.) + double(202176000) + 6.9
   
   yellow_stop= $
     [4.98724, 5.56608, 5.83058, 6.85024, 7.01111, 7.05724 ] * $
     double(3600.) + double(202176000) + 6.9

;-----------------OLD MOMENTS SPRING AGU 1997--------------------
;   neg_start= [ 15332.1, 15690.9, 17070.9, 17885.1, 21279.9, $
;                21721.5, 73471.5, 76907.7, 77059.5, 79212.3 ]  $
;     + double(202176000)        ; 5/29/96
;
;   neg_stop= [ 15345.9, 15704.7, 17084.7, 17898.9, 21293.7, $
;             21735.3, 73485.3, 76921.5, 77073.3, 79226.1 ] $
;     + double(202176000)        ; 5/29/96
;
;   pos_start= [ 11192.1, 12171.9, 12820.5, 25875.3, 26758.5, 31905.9 ] $
;     + double(202176000)        ; 5/29/96
;   
;   pos_stop= [ 11205.9, 12185.7, 12834.3, 25889.1, 26772.3, 31919.7 ] $
;     + double(202176000)        ; 5/29/96
;   
;   cyan_start= $
;     [  2.99774, 3.29674, 3.49608, 3.89091, 3.96758, 4.09024, 4.19758, 4.20524, $
;        4.22441, 4.23208, 4.32024, 4.32408, 4.34708, 4.38541, 4.53874, 4.54258, $
;        4.55408, 4.60774, 5.16741, 5.18274, 5.80374, 5.85741, 6.27141, 6.31358, $
;        6.32508, 6.37491, 6.54741, 6.58958, 6.63941, 6.66624, 6.68158, 6.69691, $
;        6.71991, 6.72374, 6.73908, 6.75824, 6.80041, 6.82724, 6.90008, 7.01891, $
;        7.05724] * double(3600.) + double(202176000)

;   cyan_stop= $
;     [ 3.20474, 3.30441, 3.52674, 3.91391, 3.99824, 4.14391, 4.20524, 4.20908, $
;       4.23208, 4.23974, 4.32408, 4.33174, 4.35474, 4.38924, 4.54258, 4.55024, $
;       4.56941, 4.63074, 5.18274, 5.19041, 5.82674, 5.88424, 6.27524, 6.32124, $
;       6.35574, 6.38258, 6.56658, 6.59724, 6.66241, 6.67008, 6.69691, 6.70458, $
;       6.72374, 6.73908, 6.75824, 6.77358, 6.82724, 6.87708, 6.92691, 7.03041, $
;       7.06491] * double(3600.) + double(202176000)

;   yellow_start= $
;     [ 2.99774, 3.26608, 3.29674, 3.49608, 3.55358, 3.59574, 3.61108, 3.75291, $
;       3.76824, 3.82191, 3.83341, 3.89091, 3.92541, 3.96758, 4.05191, 4.06724, $
;       4.09024, 4.14391, 4.19758, 4.20524, 4.22441, 4.23208, 4.32024, 4.32408, $
;       4.34708, 4.38541, 4.52341, 4.53874, 4.54258, 4.55408, 4.60774, 4.69208, $
;       4.72658, 4.73424, 4.74191, 4.76108, 4.83008, 4.96808, 5.00641, 5.10224, $
;       5.13291, 5.16741, 5.18274, 5.22491, 5.23641, 5.80374, 5.85741, 6.27141, $
;       6.31358, 6.32508, 6.37491, 6.54741, 6.57041, 6.58958, 6.63941, 6.66624, $
;       6.68158, 6.69691, 6.71991, 6.72374, 6.73908, 6.75824, 6.80041, 6.82724, $
;       6.87708, 6.88474, 6.89624, 6.90008, 6.95758, 6.96141, 7.01891, 7.05724, $
;       7.31791, 7.36008 ] * double(3600.) + 202176000

;   yellow_stop= $
;     [ 3.20474, 3.28141, 3.30441, 3.52674, 3.55741, 3.61108, 3.61491, 3.76824,$
;       3.78358, 3.83341, 3.89091, 3.91391, 3.92924, 3.99824, 4.06724, 4.07491,$
;       4.14391, 4.15158, 4.20524, 4.20908, 4.23208, 4.23974, 4.32408, 4.33174,$ 
;       4.35474, 4.38924, 4.52724, 4.54258, 4.55024, 4.56941, 4.63074, 4.72658,$ 
;       4.73424, 4.74191, 4.75341, 4.83008, 4.84541, 4.97574, 5.04858, 5.13291,$ 
;       5.14824, 5.18274, 5.19041, 5.23641, 5.24791, 5.82674, 5.88424, 6.27524,$ 
;       6.32124, 6.35574, 6.38258, 6.56658, 6.58191, 6.59724, 6.66241, 6.67008,$ 
;       6.69691, 6.70458, 6.72374, 6.73908, 6.75824, 6.77358, 6.82724, 6.87708,$ 
;       6.88474, 6.89624, 6.90008, 6.92691, 6.96141, 6.96524, 7.03041, 7.06491,$ 
;       7.36008, 7.38691] * double(3600.) + 202176000

;   charsize= ( !p.position(3)-!p.position(1) ) *2.0   
   charsize= 1.2 
   n= charsize * 7
   
   if !y.type eq 0 then begin
       y1=!y.crange(0)
       y2=!y.crange(1)
       dy=y2-y1
       y1=y1+1*dy/100
       y2=y2-1*dy/100
       l1=y2-n*dy/100
       l2=y2-2*n*dy/100
       l3=y1+(2*n-6)*dy/100
       l4=y1+(n-6)*dy/100       
   endif else begin
       y1=10^!y.crange(0)
       y2=10^!y.crange(1)
       dy=y2/y1
       y2= dy^(99./100)*y1
       y1= dy^(1./100)*y1
       l1= dy^((100-n)/100)*y1
       l2= dy^((100-2*n)/100)*y1
       l3= dy^((2*n-6)/100)*y1
       l4= dy^((n-6)/100)*y1
   endelse
   
   hydra_get_device_space, x0, y0, xpixels, ypixels
   dpixel= float(xut2-xut1)/xpixels

   dxut= xut2-xut1
   
   GOTO, rd_boxes

; cyan
   event_color= cyan
   shade_in= cyan_start > xut1
   shade_out= cyan_stop < xut2

   dshade= shade_out-shade_in
   rpoly=where( dshade gt dpixel, npoly )
   rline=where( dshade gt 0 and dshade lt dpixel, nline )

   for ii=0,npoly-1 do begin       
       x1= shade_in(rpoly(ii))
       x2= shade_out(rpoly(ii))
       polyfill, ([x1,x2,x2,x1,x1]-xut1)>0<dxut, [y1,y1,y2,y2,y1], color=event_color
;       oplot, [x1,x2,x2,x1,x1]-xut1, [y1,y1,y2,y2,y1], color=event_color
       xyouts, (x1+x2)/2-xut1, l4, $
         '!6I!x', charsize=charsize, color=1, align=0.5
   endfor

   for ii=0,nline-1 do begin
       x1= shade_in(rline(ii))
       x2= shade_out(rline(ii))
       oplot, [x1,x1]-xut1, [y1,y2], color=event_color
       oplot, [x2,x2]-xut1, [y1,y2], color=event_color
       xyouts, (x1+x2)/2-xut1, l4, $
         '!6I!x', charsize=charsize, color=1, align=0.5
   ENDFOR

; yellow
   event_color= yellow
   shade_in= yellow_start > xut1
   shade_out= yellow_stop < xut2

   dshade= shade_out-shade_in
   rpoly=where( dshade gt dpixel, npoly )
   rline=where( dshade gt 0 and dshade lt dpixel, nline )
;   npoly=0 & nline=0

   for ii=0,npoly-1 do begin       
       x1= shade_in(rpoly(ii))
       x2= shade_out(rpoly(ii))
       polyfill, ([x1,x2,x2,x1,x1]-xut1)>0<dxut, [y1,y1,y2,y2,y1], color=event_color
;       oplot, [x1,x2,x2,x1,x1]-xut1, [y1,y1,y2,y2,y1], color=event_color
       xyouts, (x1+x2)/2-xut1, l3, $
         '!6E!x', charsize=charsize, color=1, align=0.5
   endfor

   for ii=0,nline-1 do begin
       x1= shade_in(rline(ii))
       x2= shade_out(rline(ii))
       oplot, [x1,x1]-xut1, [y1,y2], color=event_color
       oplot, [x2,x2]-xut1, [y1,y2], color=event_color
       xyouts, (x1+x2)/2-xut1, l3, $
         '!6E!x', charsize=charsize, color=1, align=0.5
   ENDFOR


   rd_boxes:

; colors read in from file.
   for i= 1,n_elements( time_start )-1 do begin
       event_color= colors(i)

       if (time_start(i)-xut1) * (xut2-time_start(i)) gt 0 or $
         (time_end(i)-xut1) * (xut2-time_end(i)) gt 0 then begin
           shade_in= time_start(i) > xut1
           shade_out= time_end(i) < xut2
           
           dshade= shade_out-shade_in
           poly= dshade gt dpixel
           
           if poly then begin
               x1= shade_in
               x2= shade_out
               oplot, [x1,x2,x2,x1,x1]-xut1, [y1,y1,y2,y2,y1], color=event_color
               if fill(i) then begin
                   polyfill, [x1,x2,x2,x1,x1]-xut1, [y1,y1,y2,y2,y1], $
                     color=event_color
               endif
               mid= (x1+x2)/2
               if ( mid gt xut1 and mid lt xut2 ) then $ 
                 xyouts, mid-xut1, l2, $
                 '!6'+text(i)+'!x', charsize=charsize, color=1, align=0.5
           endif else begin
               x1= shade_in
               x2= shade_out
               oplot, [x1,x1]-xut1, [y1,y2], color=event_color
               oplot, [x2,x2]-xut1, [y1,y2], color=event_color
               mid= (x1+x2)/2
               if ( mid gt xut1 and mid lt xut2 ) then $ 
                 xyouts, mid-xut1, l2, $
                 '!6'+text(i)+'!x', charsize=charsize, color=1, align=0.5
           endelse
       endif
   endfor

r_flag:

return

end
