;$Id: fitf_control.pro,v 1.2 2002/09/04 15:39:12 jbf Exp $
PRO fitf_set_control, state, species_buttons, xstyle_buttons, ystyle_buttons, $
  emin, emax, zmin, zmax, abin, asel, asel_base, ebin, nfrag, seg_idx, $
  seg_base, fitmin, fitmax, errors_buttons, diag_buttons, correct_buttons, $
  potential_buttons, ofilename, ofile_buttons

;The purpose of this function is to initialize the cw_ids substructure
;of the state vector.  It is intended to be called in fitf_control
;after the control widget is created.

state.cw_ids.species_buttons =   species_buttons
state.cw_ids.xstyle_buttons =    xstyle_buttons 
state.cw_ids.ystyle_buttons =    ystyle_buttons 
state.cw_ids.emin =              emin
state.cw_ids.emax =              emax
state.cw_ids.zmin =              zmin
state.cw_ids.zmax =              zmax
state.cw_ids.abin =              abin
state.cw_ids.asel =              asel
state.cw_ids.asel_base =         asel_base
state.cw_ids.ebin =              ebin
state.cw_ids.nfrag =             nfrag
state.cw_ids.seg_idx =           seg_idx
state.cw_ids.seg_base =          seg_base
state.cw_ids.fitmin =            fitmin
state.cw_ids.fitmax =            fitmax
state.cw_ids.errors_buttons =    errors_buttons
state.cw_ids.diag_buttons =      diag_buttons
state.cw_ids.correct_buttons =   correct_buttons
state.cw_ids.potential_buttons = potential_buttons
state.cw_ids.ofilename =         ofilename
state.cw_ids.ofile_buttons =     ofile_buttons

END
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO fitf_control_event, event
;+
; NAME:
;       fitf_control_event
;
; PURPOSE:
;       
;       This procedure handles events from the fitf_control widget.
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;
;       fitf_control_event, event
;
; INPUTS:
;
;       event:  The event structure xmanager created for the user
;               click event.
;
; SIDE EFFECTS:
;       Possible side effects:
;
;          The slice state structure may be modified if the particular
;          event requires it.
;
; RESTRICTIONS:
;
;       This function is intended to be called by widget events read
;       by the xmanager.
;
; PROCEDURE:
;
;       The hydra_fitf state vector (structure) is read from the
;       uvalue of the first child in the widget.  Then the calling
;       event is serviced by searching for that events uvalue in a
;       large case statement which contains the code to handle that
;       event.  The state vector (possibly modified) is written back
;       to the child widget's uvalue for future use.
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;       Tue Mar 16 22:17:19 1999, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		The function module_helpfile nolonger exists so I
;		created fitf_which_help.pro to take its place and find the
;		location of the appropriate helpfile.
;
;       Tue Apr 7 00:03:32 1998, Eric Dors <eed@cis>
;
;               Fixed reference to ofile_bnames.  This variable was
;               moved to the state.cw_ids structure.
;
;       Thu Apr 2 17:00:37 1998, Eric Dors <eed@wind>
;
;               In 'button-help' fixed argument to xdisplay file to
;               add the proper path to the helpfilename.
;
;-

child = widget_info(event.handler, /child)
widget_control, child, get_uvalue = fitf_handle;, /no_copy
fitf_child = widget_info(fitf_handle, /child)
widget_control, fitf_child, get_uvalue = state;, /no_copy

widget_control, event.id, get_uvalue = control_string

CASE control_string OF 
    'species': BEGIN
        state.select = event.value
        fitf_set_widget, state.control_id, state
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'correct': BEGIN
        state.mode(state.select).correct = event.value
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'potential': BEGIN
        state.mode(state.select).potential = event.value
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'errors': BEGIN
        state.mode(state.select).errors = event.value
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'diag': BEGIN
        state.mode(state.select).diag = event.value
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'xstyle': BEGIN
        state.mode(state.select).xlog = event.value
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'ystyle': BEGIN
        state.mode(state.select).ylog = event.value
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'zmin': BEGIN
        state.mode(state.select).zrange(0) = $
          (state.mode(state.select).zlow > event.value)
        state.mode(state.select).zrange(0) = $
          (state.mode(state.select).zrange(1) < state.mode(state.select).zrange(0))
        widget_control, event.id, set_value=state.mode(state.select).zrange(0)
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'zmax': BEGIN
        state.mode(state.select).zrange(1) = $
          (state.mode(state.select).zrange(0) > event.value)
        state.mode(state.select).zrange(1) = $
          (state.mode(state.select).zhigh < state.mode(state.select).zrange(1))

        widget_control, event.id, set_value=state.mode(state.select).zrange(1)
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'emin': BEGIN
        state.mode(state.select).erange(0) = $
          (state.mode(state.select).elow > event.value)
        state.mode(state.select).erange(0) = $
          (state.mode(state.select).erange(1) < state.mode(state.select).erange(0))
        widget_control, event.id, set_value=state.mode(state.select).erange(0)
        IF ((event.value LT state.mode(state.select).elow) OR $
            (event.value GT state.mode(state.select).ehigh)) THEN BEGIN
            ret = widget_message('Attempt to set limit out of range!', $
                                 title = 'Warning Message', $
                                 dialog_parent = state.control_id)
        ENDIF
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'emax': BEGIN
        state.mode(state.select).erange(1) = $
          (state.mode(state.select).erange(0) > event.value)
        state.mode(state.select).erange(1) = $
          (state.mode(state.select).ehigh < state.mode(state.select).erange(1))

        widget_control, event.id, set_value=state.mode(state.select).erange(1)
        IF ((event.value LT state.mode(state.select).elow) OR $
            (event.value GT state.mode(state.select).ehigh)) THEN BEGIN
            ret = widget_message('Attempt to set limit out of range!', $
                                 title = 'Warning Message', $
                                 dialog_parent = state.control_id)
        ENDIF
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'fitmin': BEGIN
        state.mode(state.select).fitrange(0) = $
          (state.mode(state.select).elow > event.value)
        state.mode(state.select).fitrange(0) = $
          (state.mode(state.select).fitrange(1) < state.mode(state.select).fitrange(0))
        widget_control, event.id, set_value=state.mode(state.select).fitrange(0)
        IF ((event.value LT state.mode(state.select).elow) OR $
            (event.value GT state.mode(state.select).ehigh)) THEN BEGIN
            ret = widget_message('Attempt to set limit out of range!', $
                                 title = 'Warning Message', $
                                 dialog_parent = state.control_id)
        ENDIF
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'fitmax': BEGIN
        state.mode(state.select).fitrange(1) = $
          (state.mode(state.select).fitrange(0) > event.value)
        state.mode(state.select).fitrange(1) = $
          (state.mode(state.select).ehigh < state.mode(state.select).fitrange(1))
        widget_control, event.id, set_value=state.mode(state.select).fitrange(1)
        IF ((event.value LT state.mode(state.select).elow) OR $
            (event.value GT state.mode(state.select).ehigh)) THEN BEGIN
            ret = widget_message('Attempt to set limit out of range!', $
                                 title = 'Warning Message', $
                                 dialog_parent = state.control_id)
        ENDIF
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'abin': BEGIN
        widget_control, event.id, set_value = state.mode(state.select).dalph

        state.mode(state.select).dalph = $
          (state.mode(state.select).alow > event.value)
        state.mode(state.select).dalph = $
          (state.mode(state.select).ahigh < state.mode(state.select).dalph)

        widget_control, event.id, set_value = state.mode(state.select).dalph

        IF ((event.value LT state.mode(state.select).alow) OR $
            (event.value GT state.mode(state.select).ahigh)) THEN BEGIN
            ret = widget_message('Attempt to set bin size out of range!', $
                                 title = 'Warning Message', $
                                 dialog_parent = state.control_id)
        ENDIF

        nabins = long(state.mode(state.select).ahigh/$
                      state.mode(state.select).dalph)
        IF (nabins GT 1) THEN BEGIN
            widget_control, state.cw_ids.asel, set_slider_max = nabins
            widget_control, state.cw_ids.asel_base, map = 1
        ENDIF ELSE BEGIN
            widget_control, state.cw_ids.asel_base, map = 0
        ENDELSE
        IF (nabins LT state.mode(state.select).asel) THEN BEGIN
            state.mode(state.select).asel = event.value
        ENDIF 
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'asel': BEGIN
        state.mode(state.select).asel = event.value
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'ebin': BEGIN
        state.mode(state.select).den = $
          (state.mode(state.select).denlow > event.value)
        state.mode(state.select).den = $
          (state.mode(state.select).denhigh < state.mode(state.select).den)

        widget_control, event.id, set_value = state.mode(state.select).den

        IF ((event.value LT state.mode(state.select).denlow) OR $
            (event.value GT state.mode(state.select).denhigh)) THEN BEGIN
            ret = widget_message('Attempt to set bin size out of range!', $
                                 title = 'Warning Message', $
                                 dialog_parent = state.control_id)
        ENDIF
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'close': BEGIN
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
        widget_control, event.top, /destroy
        return
    END
    'nfrag': BEGIN
        state.mode(state.select).hres = event.value
        IF (event.value GT 1) THEN BEGIN
            widget_control, state.cw_ids.seg_idx, set_slider_max = event.value
            widget_control, state.cw_ids.seg_base, map = 1
        ENDIF ELSE BEGIN
            widget_control, state.cw_ids.seg_base, map = 0
        ENDELSE
        ;;don't forget that user thinks seg_idx uses ordinal numbers,
        ;;while we store it as an array index
        IF (event.value LT (state.mode(state.select).seg_idx+1)) THEN BEGIN
            state.mode(state.select).seg_idx = event.value-1
        ENDIF 
        widget_control, state.cw_ids.seg_idx, $
          set_value=state.mode(state.select).seg_idx+1
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'seg_idx': BEGIN
        ;;don't forget that user thinks seg_idx uses ordinal numbers,
        ;;while we store it as an array index
        state.mode(state.select).seg_idx = event.value-1
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'ofile_buttons': BEGIN
        IF (state.mode(state.select).filename NE '') THEN BEGIN
            close, state.mode(state.select).fileunit
            free_lun, state.mode(state.select).fileunit
            state.mode(state.select).fileunit = -1
            state.mode(state.select).filename = ''
        ENDIF ELSE BEGIN
            result = pickfile(group = state.control_id, /write, get_path = path, $
                             filter = '*.fitdata', /fix_filter)
            IF (result NE '') THEN BEGIN
                IF (strpos(result, '/') EQ -1) THEN BEGIN
                    filename = path+result 
                ENDIF ELSE BEGIN
                    filename = result
                ENDELSE
                IF (strpos(result, '.fitdata') EQ -1) THEN BEGIN
                    filename = filename+'.fitdata'
                    ret = widget_message('Filename must have '+$
                                         '".fitdata" extention, '+$
                                         'extension apended. ', $
                                         dialog_parent = state.control_id)
                ENDIF 
                openw, /get_lun, unit, filename, error = error, /append
                IF (error NE 0) THEN BEGIN
                    print, 'Error opening file.', !err_string
                    ret = widget_message(/error, 'Error opening file: '+$
                                         !err_string, $
                                         dialog_parent = state.control_id)
                ENDIF ELSE BEGIN
                    state.mode(state.select).filename = filename
                    state.mode(state.select).fileunit = unit
                ENDELSE
            ENDIF ELSE BEGIN
                print, 'Error in file name.'
                ret = widget_message(/error, 'Error in file name.', $
                                     dialog_parent = state.control_id)
            ENDELSE
        ENDELSE
        len = strlen(state.mode(state.select).filename)
        widget_control, state.cw_ids.ofilename, $
          set_value= state.mode(state.select).filename
        widget_control, state.cw_ids.ofilename, set_text_select = [0, len]
        widget_control, state.cw_ids.ofilename, set_text_select = [len, len]
        IF (state.mode(state.select).filename EQ '') THEN BEGIN
            widget_control, state.cw_ids.ofile_buttons, $
              set_value= state.cw_ids.ofile_bnames(0)
        ENDIF ELSE BEGIN
            widget_control, state.cw_ids.ofile_buttons, $
              set_value= state.cw_ids.ofile_bnames(1)
        ENDELSE
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    'help': BEGIN
        xdisplayfile, fitf_which_help('fitf_control.help'), $
          title='PAPCO Online-Help', group=state.base_id
        widget_control, fitf_child, set_uvalue = state ;, /no_copy
    END
    ELSE: BEGIN
        ret=widget_message(/error, dialog_parent = state.control_id, $
                           'ERROR: undefined event in fitf_control_event')
        print, 'ERROR: undefined event in fitf_control_event'
    END
ENDCASE

END


;===========================================================================
PRO fitf_set_widget, base, state, noupdate = noupdate
;+
; NAME:
;       fitf_set_widget
;
; PURPOSE:
;       
;       This procedure updates the fitf_hydra control widget to reflect
;       the current state vector.
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;
;       fitf_set_widget, base, state, noupdate = noupdate
;
; INPUTS:
;       base:  The base id of the hydra_fitf control widget.
;
;       state:  The state vector of the widget from which plotting
;               parameters are to be taken.
;
; KEYWORD PARAMETERS:
;       noupdate: A swwitch which requests that the the widget is left
;                 out of screen update mode after the state is updated
;                 in memory.
;
; SIDE EFFECTS:
;       
;       The widgets in the hydra_fitf control widget are updated to
;       reflect the state vector.
;
; RESTRICTIONS:
;       
;       The state vector should be define specified in init_fitf.  The
;       current state vector is stored in the user value of the first
;       child widget in the hydra_fitf window.
;
; EXAMPLE:
;
;        IDL> child = widget_info(hydra_fitf.top, /child)
;        IDL> widget_control, child, get_uvalue = state
;        IDL> fitf_set_widget, main_base, state
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;-

widget_control, base, update=0

widget_control, state.cw_ids.species_buttons, set_value=state.select
widget_control, state.cw_ids.correct_buttons, set_value=state.mode(state.select).correct
widget_control, state.cw_ids.potential_buttons, $
  set_value=state.mode(state.select).potential
widget_control, state.cw_ids.errors_buttons, $
  set_value=state.mode(state.select).errors
widget_control, state.cw_ids.diag_buttons, $
  set_value=state.mode(state.select).diag
widget_control, state.cw_ids.xstyle_buttons, $
  set_value=state.mode(state.select).xlog
widget_control, state.cw_ids.ystyle_buttons, $
  set_value=state.mode(state.select).ylog
widget_control, state.cw_ids.emin, $
  set_value=state.mode(state.select).erange(0)
widget_control, state.cw_ids.emax, $
  set_value=state.mode(state.select).erange(1)
widget_control, state.cw_ids.fitmin, $
  set_value=state.mode(state.select).fitrange(0)
widget_control, state.cw_ids.fitmax, $
  set_value=state.mode(state.select).fitrange(1)
widget_control, state.cw_ids.zmin, $
  set_value=state.mode(state.select).zrange(0)
widget_control, state.cw_ids.zmax, $
  set_value=state.mode(state.select).zrange(1)
widget_control, state.cw_ids.abin, set_value= state.mode(state.select).dalph
nabins=fix(state.mode(state.select).ahigh/state.mode(state.select).dalph)
IF (nabins GT 1) THEN BEGIN
    widget_control, state.cw_ids.asel, set_slider_max=nabins
    widget_control, state.cw_ids.asel, set_value=state.mode(state.select).asel
ENDIF ELSE BEGIN
    widget_control, state.cw_ids.asel, map=0
ENDELSE

widget_control, state.cw_ids.ebin, set_value= state.mode(state.select).den
widget_control, state.cw_ids.nfrag, set_value= state.mode(state.select).hres
IF (state.mode(state.select).hres GT 1) THEN BEGIN
    widget_control, state.cw_ids.seg_idx, $
      set_slider_max=state.mode(state.select).hres
    widget_control, state.cw_ids.seg_idx, $
      set_value=state.mode(state.select).seg_idx+1
ENDIF ELSE BEGIN
    widget_control, state.cw_ids.seg_idx, map=0
ENDELSE
IF (state.mode(state.select).filename EQ '') THEN BEGIN
    widget_control, state.cw_ids.ofile_buttons, $
      set_value= state.cw_ids.ofile_bnames(0)
ENDIF ELSE BEGIN
    widget_control, state.cw_ids.ofile_buttons, $
      set_value= state.cw_ids.ofile_bnames(1)
ENDELSE
len=strlen(state.mode(state.select).filename)
widget_control, state.cw_ids.ofilename, $
  set_value= state.mode(state.select).filename
widget_control, state.cw_ids.ofilename, set_text_select=[0, len]
widget_control, state.cw_ids.ofilename, set_text_select=[len, len]
IF (NOT keyword_set(noupdate))THEN BEGIN
    widget_control, base, update=1
ENDIF

end
;===========================================================================

PRO fitf_control, handler, window = window, group = group
;+
; NAME:
;       fitf_control
;
; PURPOSE:
;       
;       This procedure creates the hydra_fitf control widget.
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;       
;       fitf_control, handler, window = window, group = group
;
; INPUTS:
;       handler:  The base id of the hydra_fitf window this control
;                 window is associated with.
;
; KEYWORD PARAMETERS:
;       window:   The papco window number that the hydra_fitf slice
;                 window is associated with (if papco is running).
;
;       group:  The base id of the group leader of this widget.  If
;               the group leader is destroyed so will this widget.
;
; RESTRICTIONS:
;
;       This widget should be called from hydra_fitf_event only.
;       (though the control event).  
;
;       See the help button inside this widget for more help on the
;       meaning of each sub-widget, and how it effects the hydra_fitf
;       state. 
;
; SIDE EFFECTS:
;
;       A control window is placed next to the hydra_fitf window.
;       Setting the values in tis window changes the plotting
;       parameters of hydra_fitf, through the state vector.
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;-

child = widget_info(handler, /child)
widget_control, child, get_uvalue = state;, /no_copy

IF xregistered('fitf_control') THEN return
IF N_ELEMENTS(group) EQ 0 THEN group=0

main_base = widget_base(group_leader = group, $
                        title = 'hydra_fitf control panel '+$
                        string(window, format = '(i2.2)'), /column)

state.control_id = main_base

control_base = widget_base(main_base, /row)

control_base1 = widget_base(control_base, /column)
control_base2 = widget_base(control_base, /column)

species_base = widget_base(control_base2, /frame, column = 3)
species_label = widget_label(species_base, value = 'Species')
species_buttons = cw_bgroup(species_base, /exclusive, uvalue = 'species', $
                            state.species)

xstyle_label = widget_label(species_base, value = 'X Style')
xstyle_buttons = cw_bgroup(species_base, ['Linear', 'Log'], $
                           /exclusive, uvalue = 'xstyle')

ystyle_label = widget_label(species_base, value = 'Y Style')
ystyle_buttons = cw_bgroup(species_base, ['Linear', 'Log'], $
                           /exclusive, uvalue = 'ystyle')

correct_base = widget_base(control_base2, /frame, column = 2, $
                           /base_align_center)
correct_label = widget_label(correct_base, value = 'Count Correction')
correct_buttons = cw_bgroup(correct_base, /exclusive, uvalue = 'correct', $
                            ['Off', 'On'])

potential_label = widget_label(correct_base, value = 'S/C Pot. Subtract')
potential_buttons = cw_bgroup(correct_base, ['Off', 'On'], $
                           /exclusive, uvalue = 'potential')

ebase = widget_base(control_base2, /frame, /column, /base_align_center)
erange_label = widget_label(ebase, value = 'Energy range (eV)' )
emin = cw_field(ebase, uvalue = 'emin', title = 'Minimum', /float, $
                /return_events)
emax = cw_field(ebase, uvalue = 'emax', title = 'Maximum', /float, $
                /return_events)

zbase = widget_base(control_base2, /frame, /column, /base_align_center)
zrange_label = widget_label(zbase, value = 'Dist. Funct. range (cgs)')
zmin = cw_field(zbase, uvalue = 'zmin', title = 'Minimum', /float, $
                /return_events)
zmax = cw_field(zbase, uvalue = 'zmax', title = 'Maximum', /float, $
                /return_events)

fitbase = widget_base(control_base2, /frame, /column, /base_align_center)
fitrange_label = widget_label(fitbase, value = 'Fit Energy range (eV)' )
fitmin = cw_field(fitbase, uvalue = 'fitmin', title = 'Minimum', /float, $
                /return_events)
fitmax = cw_field(fitbase, uvalue = 'fitmax', title = 'Maximum', /float, $
                /return_events)

angle_base = widget_base(control_base1, /column, /frame, /base_align_center, $
                         uvalue = 'angle_base')

abin = cw_field(angle_base, /floating, /return_events, uvalue = 'abin', $
                title='Pitch angle bin size (deg)', /column)

asel_base = widget_base(angle_base, /row, uvalue = 'asel_base', $
                        /align_center)
asel = widget_slider(asel_base, uvalue = 'asel', min = 1, max = 2, $
                     title = 'Pitch angle bin')

energy_base = widget_base(control_base1, uvalue = 'energy_base', /frame, $
                          /column, /base_align_center)
ebin = cw_field(energy_base, /floating, /return_events, uvalue = 'ebin', $
                         title='Energy bin size (dE/E)', /column)

block_center_base = widget_base(control_base1, /frame, /column, $
                                /base_align_center)
block_base = widget_base(block_center_base, uvalue = 'block_base', /column, $
                         /align_center)

nfrag = widget_slider(block_base, uvalue = 'nfrag', min = 1, max = 6, $
                       title = 'Number of sub-blocks')

seg_base = widget_base(block_base, uvalue = 'seg_base', /row, /align_center)
seg_idx = widget_slider(seg_base, uvalue = 'seg_idx', $
                        title = 'Sub-block index', min = 1, max = 2 )

swwitch_base = widget_base(control_base1, column = 2, /frame, $
                          uvalue = 'swwitch_base', /base_align_center)

errors_base = widget_base(swwitch_base, /column, /base_align_center)
errors_label = widget_label(errors_base, value = 'Fit Sigmas')
errors_buttons=cw_bgroup(errors_base, state.cw_ids.errlabel, $
                         /column, /exclusive, uvalue = 'errors')

diag_base = widget_base(swwitch_base, /column, /base_align_center)
diag_label = widget_label(diag_base, value = 'Diagnostics')
diag_buttons = cw_bgroup(diag_base, state.cw_ids.diaglabel, $
                         /column, /exclusive, uvalue = 'diag')

ofile_base = widget_base(control_base1, /column, /frame, /base_align_center)
diag_label = widget_label(ofile_base, value = 'Output filename')
ofilename = widget_text(ofile_base, uvalue='ofilename', xsize = 30)
;don't bother setting the value of the file button, that will be taken
;care of in fitf_set_widget
ofile_buttons=widget_button(ofile_base, uvalue='ofile_buttons')

control_base3 = widget_base(main_base, column = 2)
;make buttons the same size as they are in hydra_fitf
nbuttons = 7
button_size = long(state.draw_x/nbuttons)-4

close_button = widget_button(control_base3, value = 'Close', uvalue = 'close', $
                             xsize = button_size )
help_button = widget_button(control_base3, value = 'Help', uvalue = 'help', $
                            xsize = button_size)

fitf_set_control, state, species_buttons, xstyle_buttons, ystyle_buttons, $
  emin, emax, zmin, zmax, abin, asel, asel_base, ebin, nfrag, seg_idx, $
  seg_base, fitmin, fitmax, errors_buttons, diag_buttons, correct_buttons, $
  potential_buttons, ofilename, ofile_buttons

fitf_set_widget, main_base, state, /noupdate

;guess at the window border thickness
thick = 8
geom = widget_info(state.base_id, /geometry)
xoff = geom.scr_xsize+2*geom.margin+geom.xoffset+thick
geomcont = widget_info(main_base, /geometry)
device, get_screen_size = ssize
;if the position statement will put most of the new widget off the
;edge of the screen place it on the left of the draw widget
IF ((geom.xoffset+geom.scr_xsize+geomcont.scr_xsize+thick) GT ssize(0))THEN BEGIN
    xoff=geom.xoffset-geomcont.scr_xsize-2*geom.margin-2*geomcont.margin-3*thick
ENDIF
;I am not sure how to get the height of the title bar so assume about
;25 pixels
;one method is to realize the widget before this point, but that
;causes flashing
yoff = geom.yoffset-geom.margin-25

widget_control, main_base, xoffset = xoff, yoffset = yoff
widget_control, main_base, update = 1
widget_control, main_base, /realize

widget_control, control_base, set_uvalue = handler
widget_control, child, set_uvalue = state;, /no_copy

xmanager, 'fitf_control', main_base

END
