;	$Id: hydra_fitf.pro,v 1.2 2002/09/04 15:39:13 jbf Exp $	
PRO fitf_kill, id
;+
; NAME:
;       fitf_kill
;
; PURPOSE: 
;
;       This procedure cleans up after the hydra_fitf widget when it is
;       killed.  This is accomplished by removing the element of the
;       regarr list correspoinding to the killed widget.
;
;       *This procedure should only be called by xmanager.pro!
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;       
;       fitf_kill, id
;
; INPUTS:
;       
;       id:  The widget id of the widget being killed.
;
; COMMON BLOCKS:
;
;       myregister: This common block exists to make the the variable
;                   myreg global.  The purpose of this variable is to
;                   register hydra_fitf widgets.  Specifically, myreg
;                   is an array of structures which contain the widget
;                   id of a hydra_fitf base widget and the widget id
;                   of the draw window which owns that slice window.
;                   This array facilitate multiple slice widgets being
;                   open at the same time.  With out this registry one
;                   would not be able to know which slice widget a
;                   given draw window click event should be sent to.  
;
; SIDE EFFECTS:
;       
;       The element of the regarr associated with the killed window is
;       erased.
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;-
COMMON  myregister, regarr
nelem = n_elements(regarr)
index = (where(regarr(*).fitfbase EQ id))(0)
IF (nelem EQ 1) THEN BEGIN
    regarr = -1
ENDIF ELSE IF (index EQ 0) THEN BEGIN
    regarr = regarr(1:*) 
ENDIF ELSE IF (index EQ nelem-1) THEN BEGIN
    regarr = regarr(0:nelem-2) 
ENDIF ELSE BEGIN
    regarr = [regarr(0:index-1), regarr(index+1:*)]
ENDELSE

END
;----------------------------------------------------------------------
FUNCTION add_to_regarr, regarr
;+
; NAME:
;       add_to_regarr
;
; PURPOSE:
;       
;       This function adds a new element to the regarr list when a new
;       slice widget is opened.
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;
;       result=add_to_regarr(regarr)
;
; INPUTS:
;
;       regarr: regarr is an array of structures which contain the
;               widget id of a hydra_fitf base widget and the widget
;               id of the draw window which owns that slice window.
;               This array facilitate multiple slice widgets being
;               open at the same time.  With out this registry one
;               would not be able to know which slice widget a given
;               draw window click event should be sent to.
;
; OUTPUTS:
;
;       regarr: The updated widget rigistration list is returned.
;
;       result: The index to the new entry in regarr.
;
; EXAMPLE:
;
;               index = add_to_regarr(regarr)
;
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;-

regvec = {regvect, window:-1L, fitfbase:-1L}

nelem = n_elements(regarr)
sz = size(regarr)
IF (nelem EQ 0) THEN BEGIN
    regarr = [regvec]
    index = 0
ENDIF ELSE IF ((nelem EQ 1) AND (sz(0) EQ 0)) THEN BEGIN
    regarr = [regvec]
    index = 0
ENDIF ELSE BEGIN
    regarr = [regarr, regvec]
    index = nelem
ENDELSE

return, index

END
;----------------------------------------------------------------------
PRO hydra_fitf_redraw, state, child
;+
; NAME:
;       hydra_fitf_redraw
;
; PURPOSE:
;       The purpose of this procedure is to redraw the output in the
;       draw widget of hydra_fitf.pro.
;
; CATEGORY:
;       hydra_fitf
;
; CALLING SEQUENCE:
;       hydra_fitf_redraw, state, child
;
; INPUTS:
;       state:  The state vector of the widget.
;       child:  The widget where the state vector is stored.
;
; SIDE EFFECTS:
;       The hydra_fitf draw widget is updated.
;
; PROCEDURE:
;       fitf_plot is called to update the draw widget after
;       appropriately setting the motion parameters to 0 in the state
;       vector.  After the slice draw widget is refreshed, the
;       hydra_strike is called to move the strike in the panel plot.
;
; EXAMPLE:
;       
;       hydra_fitf_redraw, state, child
;
; Written by:   Eric E. Dors, 16 March 1999.
;
; MODIFICATION HISTORY:
;
;-

IF (state.mode(state.select).seg_idx GE state.mode(state.select).hres-1) THEN seg_idx = 0
state.mode(state.select).next = 0
state.mode(state.select).prev = 0
wset, state.winidx
widget_control, child, set_uvalue = state ;, /no_copy
retval=fitf_plot(state, datatime = datatime)
widget_control, child, get_uvalue = state ;, /no_copy
state.mode(state.select).seg_idx = seg_idx
if (state.papco ne 0) then begin ; move papco cursor
    striketime = strmid(state.args.path, 4, 2)+'/'+$
      strmid(state.args.path, 6, 2)+'/'+$
      strmid(state.args.path, 0, 4)+' '+strmid(datatime(0), 0, 8)
    hydra_strike, striketime
endif                           ; move papco cursor    
widget_control, child, set_uvalue = state ;, /no_copy
END
;----------------------------------------------------------------------
PRO hydra_fitf_event, event
;+
; NAME:
;       hydra_fitf_event
;
; PURPOSE:
;       
;       This procedure handles events for the hydra_fitf slice widget.
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;       
;       hydra_fitf_event, event
;
; INPUTS:
;       
;       event:  The event structure xmanager created for the user
;               click event.
;
; SIDE EFFECTS:
;
;       Possible side effects:
;
;          1. The slice state structure may be modified if the
;          particular event requires it.
;
;          2. A new plot may be written to the screen or the printer.
;
; RESTRICTIONS:
;
;       This procedure is intended to be called by widget events read
;       by the xmanager.
;
; PROCEDURE:
;       
;       The hydra_fitf state vector (structure) is read from the
;       uvalue of the first child in the widget.  Then the calling
;       event is serviced by searching for that events uvalue in a
;       large case statement which contains the code to handle that
;       event.  The state vector (possibly modified) is written back
;       to the child widget's uvalue for future use.
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;       Tue Mar 16 23:53:19 1999, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		The code from the 'button_draw' case was moved to
;		subroutine hydra_fitf_redraw to facilitate calling it
;		from both 'button_draw' and 'base_id'.
;
;       Tue Mar 16 22:28:56 1999, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		The function module_helpfile no longer exists so I
;		created the function fitf_which_help.pro to take its
;		place. 
;
;       Sun Feb 21 15:12:25 1999, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		Update the use of state.args.path for its new use of
;		four digit years instead of the old two digit year.
;
;       Thu Apr 2 16:58:54 1998, Eric Dors <eed@wind>
;
;               In 'button-help' fixed argument to xdisplay file to
;               add the proper path to the helpfilename.
;
;-

child = widget_info(event.handler, /child)
widget_control, child, get_uvalue = state;, /no_copy

widget_control, event.id, get_uvalue = button_string

seg_idx = state.mode(state.select).seg_idx

CASE button_string OF
    'button_draw': $
      BEGIN
        hydra_fitf_redraw, state, child
    END
    'button_close': $
      BEGIN
        IF (state.mode(state.select).filename NE '') THEN BEGIN
            close, state.mode(state.select).fileunit
            free_lun, state.mode(state.select).fileunit
            state.mode(state.select).fileunit = -1
            state.mode(state.select).filename = ''
        ENDIF
        IF xregistered('fitf_control') THEN BEGIN
            widget_control, state.control_id, /destroy
        ENDIF
        widget_control, event.top, /destroy
        return
        widget_control, child, set_uvalue = state ;, /no_copy
    END
    'button_next': $
      BEGIN
        IF (state.mode(state.select).seg_idx LT $
            state.mode(state.select).hres-1) THEN BEGIN
            
            state.mode(state.select).seg_idx = $
              state.mode(state.select).seg_idx+1
            state.mode(state.select).next = 0
            state.mode(state.select).prev = 0
            wset, state.winidx
            widget_control, child, set_uvalue = state ;, /no_copy
            retval=fitf_plot(state, datatime = datatime)
            widget_control, child, get_uvalue = state ;, /no_copy
        ENDIF ELSE BEGIN
            state.mode(state.select).seg_idx = 0
            state.mode(state.select).next = 1
            state.mode(state.select).prev = 0
            wset, state.winidx
            widget_control, child, set_uvalue = state ;, /no_copy
            retval=fitf_plot(state, datatime = datatime)
            widget_control, child, get_uvalue = state ;, /no_copy
            if (state.papco ne 0) then begin ; move papco cursor
                striketime = strmid(state.args.path, 4, 2)+'/'+$
                  strmid(state.args.path, 6, 2)+'/'+$
                  strmid(state.args.path, 0, 4)+' '+strmid(datatime(0), 0, 8)
                hydra_strike, striketime
            endif               ; move papco cursor    
        ENDELSE 
        IF xregistered('fitf_control') THEN BEGIN
            fitf_set_widget, state.control_id, state
        ENDIF
        widget_control, child, set_uvalue = state ;, /no_copy
    END
    'button_prev': $
      BEGIN
        IF (state.mode(state.select).seg_idx NE 0) THEN BEGIN
            state.mode(state.select).seg_idx = $
              state.mode(state.select).seg_idx-1
            state.mode(state.select).next = 0
            state.mode(state.select).prev = 0
            wset, state.winidx
            widget_control, child, set_uvalue = state ;, /no_copy
            retval=fitf_plot(state, datatime = datatime)
            widget_control, child, get_uvalue = state ;, /no_copy
        ENDIF ELSE BEGIN
            state.mode(state.select).seg_idx = state.mode(state.select).hres-1
            state.mode(state.select).prev = 1
            state.mode(state.select).next = 0
            wset, state.winidx
            widget_control, child, set_uvalue = state ;, /no_copy
            retval=fitf_plot(state, datatime = datatime)
            widget_control, child, get_uvalue = state ;, /no_copy
            if (state.papco ne 0) then begin ; move papco cursor
                striketime = strmid(state.args.path, 4, 2)+'/'+$
                  strmid(state.args.path, 6, 2)+'/'+$
                  strmid(state.args.path, 0, 4)+' '+strmid(datatime(0), 0, 8)
                hydra_strike, striketime
            endif               ; move papco cursor    
        ENDELSE
        IF xregistered('fitf_control') THEN BEGIN
            fitf_set_widget, state.control_id, state
        ENDIF
        widget_control, child, set_uvalue = state ;, /no_copy
    END
    'button_help': BEGIN
        xdisplayfile, fitf_which_help('hydra_fitf.help'), $
          title='PAPCO Online-Help', group=state.base_id
        widget_control, child, set_uvalue = state ;, /no_copy
    END
    'button_control': BEGIN
        widget_control, child, set_uvalue = state ;, /no_copy
        fitf_control, event.handler, group = state.base_id, $
          window = state.window
    END
    'button_print': BEGIN
        IF (print_window(parent_id = state.base_id) EQ 1) THEN BEGIN
            state.mode(state.select).prev = 0
            state.mode(state.select).next = 0
            widget_control, child, set_uvalue = state ;, /no_copy
            retval=fitf_plot(state)
            widget_control, child, get_uvalue = state ;, /no_copy
            print_finish, parent_id = state.base_id
        ENDIF
        widget_control, child, set_uvalue = state ;, /no_copy
    END
    'base_id': BEGIN 
        ;;there is a bug in idl v4 that prevents this functionality
        ;;from working exactly right, if the user tries to make the
        ;;window too small twice in a row the second is successfull
        ;;because the resize commands to widget_control are ignored if
        ;;the resize is to the current window size, this problem is
        ;;fixed in v5. 
        bbase = widget_info(state.button_base, /geometry)
        sbase = widget_info(state.base_id, /geometry)
        newdraw_x = state.draw_x-(sbase.scr_xsize-event.x)
        newdraw_y = state.draw_y-(sbase.scr_ysize-event.y)

        IF (newdraw_x GE state.min_xsz) THEN BEGIN
            state.draw_x = newdraw_x 
        ENDIF ELSE BEGIN
            state.draw_x = state.min_xsz
        ENDELSE

        IF (newdraw_y GE state.min_ysz) THEN BEGIN
            state.draw_y = newdraw_y 
        ENDIF ELSE BEGIN
            state.draw_y = state.min_ysz
        ENDELSE

        widget_control, state.base_id, $
          xsize = state.draw_x+2*bbase.margin, $
          ysize = state.draw_y+bbase.scr_ysize+4*bbase.margin+bbase.ypad

        widget_control, state.slice_draw, xsize = state.draw_x, $
          ysize = state.draw_y
      
        hydra_fitf_redraw, state, child

        widget_control, child, set_uvalue = state ;, /no_copy
    END
    ELSE: BEGIN
        ret=widget_message(/error, dialog_parent = state.control_id, $
                           'ERROR: undefined event in fitf_control_event')
        print, 'ERROR: undefined event in fitf_control_event'
    END
ENDCASE

END

;===========================================================================

PRO hydra_fitf, path, t0, papco=papco, group = group, window = window
;+
; NAME:
;       hydra_fitf
;
; PURPOSE:
;       
;       This procedure creates a widget which can read level 1
;       distribution function data, display it, print it, and fit a
;       Maxwellian or kappa function to it.  Click on the help button
;       for a detailed descripton.
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;
;       hydra_fitf, path, t0, papco=papco, group = group, window = window
;
; INPUTS:
;       path:  The date to display data for in the form 'yymmdd'.
;
;       t0:    The time to display data for in the form 'hh:mm:ss'.
;
; KEYWORD PARAMETERS:
;       papco:   A swwitch to tell the widget that papco is the caller.
;
;       group:   A variable containing the group id of the caller.
;                Thus, if the calling widget is destroyed, this widget
;                and all its children will be destroyed too.
;               
;       window:  The number of the papco draw window which called this
;                program. 
;
; COMMON BLOCKS:
;       myregister: This common block exists to make the the variable
;                   myreg global.  The purpose of this variable is to
;                   register hydra_fitf widgets.  Specifically, myreg
;                   is an array of structures which contain the widget
;                   id of a hydra_fitf base widget and the widget id
;                   of the draw window which owns that slice window.
;                   This array facilitate multiple slice widgets being
;                   open at the same time.  With out this registry one
;                   would not be able to know which slice widget a
;                   given draw window click event should be sent to.  
;
; SIDE EFFECTS:
;       A new widget window may be created.  
;       An element may be added to regarr in the myregister common block.
;
; PROCEDURE:
;       
;       The hydra_fitf registration list is searched to see if the
;       caller already has a slice widget open.  If not, a new element
;       in the hydra_fitf_slice registration list is created and a new
;       widget window is opened.  Then the plot window is updated with
;       a plot of the time requested by path and t0.
;
; EXAMPLE:
;       
;       See user_hydra_fitf_hydra_spec.pro for the papco calling
;       sequence.
; 
;       From IDL, with out papco running:
;
;       IDL> @papco_startup
;       IDL> hydra_fitf, '19960529', '21:00:00'
;
;       This opens a window with a plot of the data from 05/19/1996 at
;       21:00 hours.  There are many options which can be set
;       regarding plotting style and processing.  See the help widget
;       help button for help on these options.
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;       Sun Feb 21 15:17:03 1999, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		Update use of state.args.path for new four character
;		year string instead of old two character year string.
;
;       Mon Mar 16 10:46:27 1998, Eric Dors <eed@cis>
;
;               Some how the initialization of state.slice_draw to
;               slice_draw was erased during the editing fo this code
;               for the version 1.00 release.  The initialization has
;               been fixed in the section labeled "store base
;               variables needed in event manager".
;
;-

COMMON  myregister, regarr

IF (n_elements(window) NE 0) THEN BEGIN
    regname = 'hydra_fitf_'+string(window, format = '(i2.2)')
ENDIF ELSE BEGIN
    regname = 'hydra_fitf'
ENDELSE

IF NOT xregistered(regname) THEN BEGIN
    index = add_to_regarr(regarr)
    init_fitf, path, t0, state, group = group, papco = papco, window = window
ENDIF ELSE BEGIN
    index = where(regarr(*).window EQ window)
    child = widget_info(regarr(index).fitfbase, /child)
    widget_control, child, get_uvalue = state;, /no_copy
    state.args.path = path
    state.args.t0 = t0

    widget_control, state.slice_draw, get_value = dummy
    state.winidx = dummy
    state.mode(state.select).next = 0
    state.mode(state.select).prev = 0
    wset, state.winidx
    widget_control, child, set_uvalue = state;, /no_copy
    retval=fitf_plot(state, datatime = datatime)
    widget_control, child, get_uvalue = state;, /no_copy
    if (state.papco ne 0) then begin ; move papco cursor
        striketime = strmid(state.args.path, 4, 2)+'/'+$
          strmid(state.args.path, 6, 2)+'/'+$
          strmid(state.args.path, 0, 4)+' '+strmid(datatime(0), 0, 8)
        hydra_strike, striketime
    endif                       ; move papco cursor    
    widget_control, child, set_uvalue = state;, /no_copy
    return
ENDELSE 

nbuttons = 7
button_size = long(state.draw_x/nbuttons)-4
base_id = widget_base(column = 1, title = regname + ' version '+$
                         state.info.ver_string, $
                         group_leader = state.parent_id, /tlb_size_events, $
                         uvalue = 'base_id', /base_align_center)

draw_base = widget_base(base_id, column = 1)
button_base = widget_base(base_id, row = 1, /frame)

slice_draw = widget_draw(draw_base, xsize = state.draw_x, $
                         ysize = state.draw_y, uvalue = 'slice_draw')

button_draw = widget_button(button_base, xsize = button_size, $
                            value = 'Draw', $
                            uvalue = 'button_draw')
button_control = widget_button(button_base, xsize = button_size, $
                               value = 'Control', $
                               uvalue = 'button_control')
button_prev = widget_button(button_base, xsize = button_size, $
                            value = 'Prev', $
                            uvalue = 'button_prev')
button_next = widget_button(button_base, xsize = button_size, $
                            value = 'Next', $
                            uvalue = 'button_next')
button_next = widget_button(button_base, xsize = button_size, $
                            value = 'Print', $
                            uvalue = 'button_print')
button_help = widget_button(button_base, xsize = button_size, $
                            value = 'Help', $
                            uvalue = 'button_help')
button_close = widget_button(button_base, xsize = button_size, $
                             value = 'Close', $
                             uvalue = 'button_close')

widget_control, base_id, /realize 
widget_control, slice_draw, get_value = dummy
state.winidx = dummy

bbase = widget_info(button_base, /geometry)
state.min_xsz=bbase.scr_xsize   ;set the smallest allowalbe draw box to be
state.min_ysz=bbase.scr_xsize/2 ;a rectangle of size
                                ;button barwidth X (buttonbar width)/2  

IF(state.mode(state.select).seg_idx GT $
   state.mode(state.select).hres-1)THEN BEGIN
    state.mode(state.select).seg_idx = 0
ENDIF

;store base variables needed in event manager
state.base_id = base_id
state.button_base = button_base
state.slice_draw = slice_draw
state.window = window

regarr(index).window = window
regarr(index).fitfbase = base_id

wset, state.winidx
widget_control, draw_base, set_uvalue = state;, /no_copy
retval=fitf_plot(state, datatime = datatime)
IF (state.papco ne 0) then begin ; move papco cursor
        striketime = strmid(state.args.path, 4, 2)+'/'+$
          strmid(state.args.path, 6, 2)+'/'+$
          strmid(state.args.path, 0, 4)+' '+strmid(datatime(0), 0, 8)
        hydra_strike, striketime
endif                           ; move papco cursor    

xmanager, regname, base_id, event_handler = 'hydra_fitf_event', $
  cleanup = 'fitf_kill'
END
