;$Id: polygamma.pro,v 1.1.1.1 2002/04/10 15:24:56 jbf Exp $
FUNCTION polygamma, x, dx = dx
;+
; NAME:
;       polygamma
;
; PURPOSE:
;       
;       This function calcuates the polygamma function (the
;       derivative of the natural log of the gamma function).
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;       
;       result = polygamma(x,dx=dx)
;
; INPUTS:
;       x:  The location to calculate the polygamma function at.
;
; KEYWORD PARAMETERS:
;       dx: The grid size to differentiate lngamma on.  If dx is not
;       explicitly specified then dx defaults to x/10. 
;
; OUTPUTS:
;       
;       result: the value of d(lngamma(x))/dx|x=x
;
; PROCEDURE:
;       
;       Use the IDL deriv function to calculate the derivative of
;       lngamma.  Return the result.
;
; EXAMPLE:
;
;       result = polygamma(x,dx=dx)
;
; Written by:   Eric E. Dors, 1998.  Modified from John Dorrelli
;
; MODIFICATION HISTORY:
;
;-

IF x LT 0 AND x-long(x) EQ 0 THEN BEGIN
    print, 'cannot evaluate polygamma....'
    stop
ENDIF

IF NOT keyword_set(dx) THEN dx = x/10.

x1 = x-2.*dx
x2 = x-dx
x3 = x
x4 = x+dx
x5 = x+2.*dx

xgrid = [x1, x2, x3, x4, x5]

f = lngamma(xgrid)

df = deriv(xgrid, f)
dlngamma = df(2)

return, dlngamma

END
