;$Id: user_hydra_fitf_hydra_spec.pro,v 1.1.1.1 2002/04/10 15:24:55 jbf Exp $
PRO user_hydra_fitf_hydra_spec, panel, seconds, yvalue, $
                                readdata = readdata
;+
; NAME:
;       user_hydra_fitf_hydra_spec
;
; PURPOSE:
;       This function serves as the interface between the hydra_spec
;       panel plot and the hydra_fitf slice widget.
;
; CATEGORY:
;       hydra_fitf
;
; CALLING SEQUENCE:
;       
;       user_hydra_fitf_hydra_spec, panel, seconds, yvalue
;
; INPUTS:
;       panel:   
;
;       seconds: 
;
;       yvalue:  
;
; KEYWORD PARAMETERS:
;
;       READDATA: Keyword added for PAPCO compliance.
;
; COMMON BLOCKS:
;       time:   xut1, xut2
;       plot_composer:
;
; SIDE EFFECTS:
;       
;       A new window is placed on the screen containing a slice plot
;       from the location of the mouse event.
;
; RESTRICTIONS:
;       
;       This slicer is only meant for use with hydra_spec.pro
;
; PROCEDURE:
;       
;       The correct time, date, and parent widget id are calculated
;       and hydra_fitf.pro is called to create the slice widget.
;
; EXAMPLE:
;
;       user_hydra_fitf_hydra_spec, panel, seconds, yvalue
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;       Sun Feb 21 14:03:00 1999, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		Changed year parsing code to return four character
;		year instead of two character year.
;
;       Wed Sep 9 08:42:30 1998, Eric E. Dors <edors@universe.lanl.gov>
;
;               The result of convert_T90_to_date is often wildly
;               wrong because the input argument (1st argument) was
;               being sent as a float instead of a long value.
;               "seconds" is now converted to long before adding it to
;               xut1.
;
;-
   COMMON time, xut1, xut2
   common plot_composer, widgetData

   convert_T90_to_date, xut1+long(seconds), year, doy, hour, minute, second, $
     month, cmonth, day_om

   date_str= string( year, format='(i4.4)' ) + $
     string( month, format='(i2.2)' ) + $
     string( day_om, format='(i2.2)' )
   
   time_str= hydra_hms( seconds+xut1 )
   
   drawID= widgetData.old_draw_id( widgetdata.no_draw_window ) 
   
   hydra_strike, /init, panelNR=panel

   hydra_fitf, date_str, time_str, group=drawID, /papco, $
     window = widgetData.no_draw_window
END 
