PRO fv_convect, z_ele_to_old, z_ion_to_old, mom, $
                z_ele_to_new, z_ion_to_new, test

@model_include

z_ele_to_new = z_ele_to_old
z_ion_to_new = z_ion_to_old

umag = sqrt(mom.v(0)^2+mom.v(1)^2+mom.v(2)^2)

IF umag NE 0 THEN BEGIN
    uhat = mom.v/umag
ENDIF ELSE BEGIN
    uhat = [0, 0, 0]
ENDELSE

bmag = sqrt(mom.b_avg(0)^2+mom.b_avg(1)^2+mom.b_avg(2)^2)

IF bmag NE 0 THEN BEGIN
    bhat_mom = mom.b_avg/bmag
ENDIF ELSE BEGIN
    bhat_mom = [0, 0, 0]
ENDELSE

uparl = total(mom.v*bhat_mom)*bhat_mom
uperp = mom.v-uparl

uparl_mag = sqrt(total(uparl^2))
uperp_mag = sqrt(total(uperp^2))

IF uparl_mag NE 0 THEN BEGIN
    uparl_hat = uparl/uparl_mag
ENDIF ELSE BEGIN
    uparl_hat = 0
ENDELSE

IF uperp_mag NE 0 THEN BEGIN
    uperp_hat = uperp/uperp_mag
ENDIF ELSE BEGIN
    uperp_hat = 0
ENDELSE
;uperp = [0, 0, 0]
; compute 3-D velocity vector measurements

m_ele = 9.11d-28
m_ion = 1.67d-24

vmag_ele = sqrt(2.*z_ele_to_old.energy_ele*1.6d-19*1d7/m_ele)
vmag_ion = sqrt(2.*z_ion_to_old.energy_ion*1.6d-19*1d7/m_ion)

theta_ele = z_ele_to_old.theta_ele
theta_ion = z_ion_to_old.theta_ion
phi_ele = z_ele_to_old.phi_ele
phi_ion = z_ion_to_old.phi_ion

v_ele_1 = vmag_ele*sin(theta_ele)*cos(phi_ele)
v_ele_2 = vmag_ele*sin(theta_ele)*sin(phi_ele)
v_ele_3 = vmag_ele*cos(theta_ele)

v_ion_1 = vmag_ion*sin(theta_ion)*cos(phi_ion)
v_ion_2 = vmag_ion*sin(theta_ion)*sin(phi_ion)
v_ion_3 = vmag_ion*cos(theta_ion)

ndet = 12
nele = z_ele_to_old.n_ele
nion = z_ion_to_old.n_ion

uc_ele_1 = replicate(uperp(0), nele, ndet)
uc_ele_2 = replicate(uperp(1), nele, ndet)
uc_ele_3 = replicate(uperp(2), nele, ndet)

uc_ion_1 = replicate(uperp(0), nion, ndet)
uc_ion_2 = replicate(uperp(1), nion, ndet)
uc_ion_3 = replicate(uperp(2), nion, ndet)

v_ele_1p = v_ele_1 - uc_ele_1
v_ele_2p = v_ele_2 - uc_ele_2
v_ele_3p = v_ele_3 - uc_ele_3

v_ion_1p = v_ion_1 - uc_ion_1
v_ion_2p = v_ion_2 - uc_ion_2
v_ion_3p = v_ion_3 - uc_ion_3

vmag_ele_p = sqrt(v_ele_1p^2+v_ele_2p^2+v_ele_3p^2)
vmag_ion_p = sqrt(v_ion_1p^2+v_ion_2p^2+v_ion_3p^2)

vhat_ele_1p = v_ele_1p/vmag_ele_p
vhat_ele_2p = v_ele_2p/vmag_ele_p
vhat_ele_3p = v_ele_3p/vmag_ele_p

vhat_ion_1p = v_ion_1p/vmag_ion_p
vhat_ion_2p = v_ion_2p/vmag_ion_p
vhat_ion_3p = v_ion_3p/vmag_ion_p

thetab_ele = z_ele_to_old.thetab_ele
phib_ele = z_ele_to_old.phib_ele
thetab_ion = z_ion_to_old.thetab_ion
phib_ion = z_ion_to_old.phib_ion

bhat_ele_1 = sin(thetab_ele)*cos(phib_ele)
bhat_ele_2 = sin(thetab_ele)*sin(phib_ele)
bhat_ele_3 = cos(thetab_ele)

bhat_ion_1 = sin(thetab_ion)*cos(phib_ion)
bhat_ion_2 = sin(thetab_ion)*sin(phib_ion)
bhat_ion_3 = cos(thetab_ion)

IF test THEN BEGIN
    bhat_ele_1 = replicate(bhat(0), nele, ndet)
    bhat_ele_2 = replicate(bhat(1), nele, ndet)
    bhat_ele_3 = replicate(bhat(2), nele, ndet)
    
    bhat_ion_1 = replicate(bhat(0), nion, ndet)
    bhat_ion_2 = replicate(bhat(1), nion, ndet)
    bhat_ion_3 = replicate(bhat(2), nion, ndet)
ENDIF

vhele_dot_bh = vhat_ele_1p*bhat_ele_1+vhat_ele_2p*bhat_ele_2+$
  vhat_ele_3p*bhat_ele_3
vhion_dot_bh = vhat_ion_1p*bhat_ion_1+vhat_ion_2p*bhat_ion_2+$
  vhat_ion_3p*bhat_ion_3

; now I have a new set of 3-D velocity vectors and their directions
; wrt the magnetic field

;vparl_ele = vmag_ele_p*vhele_dot_bh
;vperp_ele = vmag_ele_p*sqrt(1.-vhele_dot_bh^2)
;vparl_ion = vmag_ion_p*vhion_dot_bh
;vperp_ion = vmag_ion_p*sqrt(1.-vhion_dot_bh^2)

z_ele_to_new.energy_ele = 0.5*m_ele*vmag_ele_p^2/1d7/1.6d-19
z_ion_to_new.energy_ion = 0.5*m_ion*vmag_ion_p^2/1d7/1.6d-19
;z_ele_to_new.alpha_ele = atan(vperp_ele, vparl_ele)
;z_ion_to_new.alpha_ion = atan(vperp_ion, vparl_ion)
z_ele_to_new.alpha_ele = acos(vhele_dot_bh)
z_ion_to_new.alpha_ion = acos(vhion_dot_bh)

print, 'FV_CONVECT:  ', uperp, mom.v

END



