PRO hydra_fv, path, t0, papcoData=papcoData_in, fv_input = fv_input, $
              fv_output = fv_output

COMMON draw_info, slice_base, slice_draw
COMMON papco_drawpolarslice, slicewidgetdata
COMMON control_info, control_id, winidx, state, $
  species_store, control_ele, control_ion
common papco_ext_common, papcoData

if n_elements( papcoData_in ) gt 0 then begin
    papcoData= papcoData_in
endif else begin
    papcoData= { panelNr:-1 }
endelse

if n_elements( slicewidgetdata ) gt 0 then begin
    widget_control, slicewidgetdata.base, /destroy
    IF xregistered('papco_drawpolarslice') THEN $
      widget_control, slicewidgetdata.base, /destroy
endif

IF NOT(keyword_set(fv_input)) THEN $
  init_fv, path, t0, fv_input

state = fv_input

ver = fv_input.info.ver
ver_string = fv_input.info.ver_string

IF xregistered('hydra_fv') THEN BEGIN
    widget_control, slice_draw, get_value = winidx
    seg_idx = fv_input.control.seg_idx
    IF seg_idx GT fv_input.control.hres-1 THEN seg_idx = 0
    fv_plot, fv_input, winidx, seg_idx, fv_output, /output
    state.control.seg_idx = seg_idx
    if papcoData.panelNr ne -1 then begin ; move papco cursor
        ttime= fv_output.start_time + 0.5 * fv_output.del_t
        xnorm= ( ttime - papcoData.xrange(0) ) / $
          ( papcoData.xrange(1)-papcoData.xrange(0) ) * $
          ( papcoData.xnormal(1)-papcoData.xnormal(0) ) + $
          papcoData.xnormal(0)
        papco_Cursor_ShowSelection, papcoData.panelNr, 0, 0, $
          xnorm, 0
    endif                       ; move papco cursor    
    return
ENDIF

sbxsize = 500
sbysize = 500
nbuttons = 7
button_size = long(sbxsize/nbuttons)-4
slice_base = widget_base(/column, title = 'hydra_fv_v'+ver_string)
slice_draw = widget_draw(slice_base, xsize = sbxsize, $
                         ysize = sbysize*0.9)
button_base = widget_base(slice_base, /row, /frame, $
                          xsize = 490, ysize = 40)
button_draw = widget_button(button_base, xsize = button_size, $
                            value = 'Draw', $
                            uvalue = 'button_draw')
button_control = widget_button(button_base, xsize = button_size, $
                               value = 'Control', $
                               uvalue = 'button_control')
button_prev = widget_button(button_base, xsize = button_size, $
                            value = 'Prev', $
                            uvalue = 'button_prev')
button_next = widget_button(button_base, xsize = button_size, $
                            value = 'Next', $
                            uvalue = 'button_next')
button_next = widget_button(button_base, xsize = button_size, $
                            value = 'Print', $
                            uvalue = 'button_print')
button_help = widget_button(button_base, xsize = button_size, $
                            value = 'Help', $
                            uvalue = 'button_help')
button_close = widget_button(button_base, xsize = button_size, $
                             value = 'Close', $
                             uvalue = 'button_close')

widget_control, slice_base, /realize 
widget_control, slice_draw, get_value = winidx
seg_idx = fv_input.control.seg_idx
IF seg_idx GT fv_input.control.hres-1 THEN seg_idx = 0
fv_plot, fv_input, winidx, seg_idx, fv_output, /output
state.control.seg_idx = seg_idx
if papcoData.panelNr ne -1 then begin ; move papco cursor
    ttime= fv_output.start_time + 0.5 * fv_output.del_t
    xnorm= ( ttime - papcoData.xrange(0) ) / $
      ( papcoData.xrange(1)-papcoData.xrange(0) ) * $
      ( papcoData.xnormal(1)-papcoData.xnormal(0) ) + $
      papcoData.xnormal(0)
    papco_Cursor_ShowSelection, papcoData.panelNr, 0, 0, $
      xnorm, 0
endif                           ; move papco cursor    

xmanager, 'hydra_fv', slice_base

END


