PRO hydra_payload_to_gse, date, time, vec_pay, vec_gse, istat, rate=rate

; Converts vec_pay to vec_gse, correcting for the S/C velocity if
; rate=1.  vec_pay must be in km/s

   COMMON get_error, get_err_no, get_err_msg

   istat =  1

   vec_gse = fltarr(4,n_elements(time))

   myname = 'hydra_payload_to_gse: '

   print, myname+'Rotating to GSE...'

;   print, myname+'Not currently correcting for the S/C velocity...'

   common hydra_payload_to_gse_common, $
     date0, att_time, gse_ra, gse_dec, orb_time, gse_vel

   if n_elements( date0 ) eq 0 then read=1 else $
     if date0 ne date then read=1 else $
     read=0
    
   if read then begin
;   Get the ephemeris cdfid
       f= hydra_findfile( date, /ddcal )
       if (f NE '') then begin
           print, myname+'Opening '+f+'...'
           cdfid = cdf_open(f)
       endif else BEGIN
           print, myname+'Findfile error...'
           istat = 0
           return               ;hydra_findfile sets the error message
       ENDELSE
       
; First get the gse spin-vector info
       att_res = 600.           ; Attitude variables resolution in seconds
       orb_res = 60.            ; Orbit variables resolution in seconds
       
       rec_start = 0
       rec_count_att = 144
       rec_count_orb = 1440
       
       hyd_cdf_varget, cdfid, 'GSM_EPHEM_TIME_AT', att_time, rec_start=rec_start, $
         rec_count=rec_count_att
       hyd_cdf_varget, cdfid, 'GSE_R_ASCENSION_AT', gse_ra, rec_start=rec_start, $
         rec_count=rec_count_att
       hyd_cdf_varget, cdfid, 'GSE_DECLINATION_AT', gse_dec, rec_start=rec_start, $
         rec_count=rec_count_att
       
;****** MUST GET THE S/C VELOCITY IN HERE AS SOON AS BOB LOADS IT!
       hyd_cdf_varget, cdfid, 'ORBIT_TIME_OR', orb_time, rec_start=rec_start, $
         rec_count=rec_count_orb
       hyd_cdf_varget, cdfid, 'GSE_VEL_OR', gse_vel, rec_start=rec_start, $
         rec_count=rec_count_orb ;gsm_vel is in km/s
;******
       cdf_close, cdfid

       att_time = reform(att_time)
       gse_ra = reform(gse_ra)
       gse_dec = reform(gse_dec)

       date0= date
   endif


; Create the matrices needed on this crude time-scale (minimize the
; number of trig functions)

   pay2gse = dblarr(3,3,n_elements(att_time))

   RAC = double(gse_ra)
   DEC = double(gse_dec)
;
   EPX = COS(DEC) * COS(RAC)
   EPY = COS(DEC) * SIN(RAC)
   EPZ = SIN(DEC)
;
;-- COMPUTE SINE VALUES AND COSINE VALUES OF ANGLES A AND D
;
   COSA = SQRT(EPY*EPY + EPZ*EPZ)
   SINA = EPX
   COSD = EPZ/COSA
   SIND = EPY/COSA
;
;-- CONSTRUCT THE TRANSFORMATION MATRIX
;
   pay2gse(0,0,*) = COSA
   pay2gse(0,1,*) = 0.
   pay2gse(0,2,*) = SINA
   pay2gse(1,0,*) = -SINA * SIND
   pay2gse(1,1,*) = COSD
   pay2gse(1,2,*) = COSA * SIND
   pay2gse(2,0,*) = -SINA * COSD
   pay2gse(2,1,*) = -SIND
   pay2gse(2,2,*) =  COSA * COSD
   
; Which transformation matrix should I use??
      
   jj= long( hyd_findex( att_time, time ) + 0.5 )
   
   vec_gse(0,*) = $
     vec_pay(0,*)*pay2gse(0,0,jj)+$
     vec_pay(1,*)*pay2gse(0,1,jj)+$
     vec_pay(2,*)*pay2gse(0,2,jj)
   vec_gse(1,*) = $
     vec_pay(0,*)*pay2gse(1,0,jj)+$
     vec_pay(1,*)*pay2gse(1,1,jj)+$
     vec_pay(2,*)*pay2gse(1,2,jj)
   vec_gse(2,*) = $
     vec_pay(0,*)*pay2gse(2,0,jj)+$
     vec_pay(1,*)*pay2gse(2,1,jj)+$
     vec_pay(2,*)*pay2gse(2,2,jj)
   vec_gse(3,*) = sqrt(total(vec_gse(0:2,*)^2,1))

   IF keyword_set(rate) THEN BEGIN ;Correct for the S/C velocity
; Which spacecraft velocity should I use??
       jj= long( hyd_findex( orb_time, time ) + 0.5 )
       vec_gse(0,*) = vec_gse(0,*) + gse_vel(0,jj)
       vec_gse(1,*) = vec_gse(1,*) + gse_vel(1,jj)
       vec_gse(2,*) = vec_gse(2,*) + gse_vel(2,jj)
       vec_gse(3,*) = sqrt(total(vec_gse(0:2,*)^2,1))
   endif

END
   



