pro hydra_xbin_plot, xin, xout, y, max_value=maxvalue, oplot=oplot, _extra=e
; plots lines, rather than psyms, showing where along the x axis that
; y was observed.  xin is the starting times for values y, xout is
; the ending time.  Type float is assumed. data 

if (not keyword_set(maxvalue)) then maxvalue=1e37

nx= n_elements(xin)
newx= fltarr( 3*nx )
newy= fltarr( 3*nx )
r= lindgen( nx ) * 3

newx(r)= xin
newx(r+1)= xout
newx(r+2)= xout

newy(r)= y
newy(r+1)= y
newy(r+2)= maxvalue*10

if (not keyword_set(oplot)) then begin
    plot, newx, newy, max_value=maxvalue, _extra=e, thick=2.0
endif else begin
    oplot, newx, newy, max_value=maxvalue, _extra=e, thick=2.0
endelse

return
end
