pro hydra_xyouts, x,y,string_in, charsize=charsize, _extra=e, limit=limit
;    clips text at length limit, in normal coords.
;
;  Assumtions:
;    assumes /normal keyword is set
;    does not handle !c 
;
;  Side Effects:
;    plots string off the page at (-1,-1) normal coorinates,
;      in !p.background

if n_elements( charsize ) eq 0 then charsize=1.0
if n_elements( limit ) eq 0 then limit=1.0

ymin= !p.position(1)
ymax= !p.position(3)

string=string_in

ymaxlen= y-ymin                 ; normal coord

; measure width per character, nominal, normal crd
w= float(!d.x_ch_size) * charsize / !d.x_size

buff= 1.00                      ; percent to leave as buffer

n= fix( limit * buff / w  )

string= strmid( string, 0, n )

xyouts, x, y, string, charsize=charsize, _extra=e    

end
