;***************************************************************************
;* 
;* PROCEDURE:     
;*      p_hydra_events, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;* 
;* DESCRIPTION:  
;*	This procedure plots data of type hydra_other for inclusion in PAPCO.  
;*      Data must have been read and placed into common blocks before this
;*      routine is called. Behaviour is controlled by the vector panel
;*	which controlls positioning of the plot (see papco_conventions.text
;*      in $PAPCO). In general, the following plot conventions are used:
;*      	- if the panel is at the bottom plot time axis plus any
;*              - additional axis (ie ephemeris) needed.
;*              - if panel is at the top also plot a title
;*              - a descriptor for panels is plotted to the right of each
;*                panel, rotated by 90 deg if there is a colorbar.
;*              - panels all have common time
;*              - y-scaling (or z-scaling for color plots) is either
;*              - automatic or manualy set using common yscale     
;*
;* INPUTS:       
;*	panel	three element integer vector. Controlls positioning of the plot
;*              (see papco_conventions.text in $PAPCO)
;*      type    optional parameter for options. Normally is a four element
;*              integer vector. This is normally equivalent to the field
;*              typeVector of the PAPCO structure PAPCO_PLOTINFO which is set
;*              by the paneleditor. Additional fields that can be used if
;*              needed are PAPCO_PLOTINFO.swwitch (three element vector) and 
;*              PAPCO_PLOTINFO.channel (integer). If your plot routine needs
;*              more input fileds than these you have to extend the definition
;*              of the structure PAPCO_PLOTINFO
;*              (procedure PAPCO_getPlotInfoStruct in $PAPCO/papco.pro). Try to
;*              avoid this!
;*              
;* OUTPUTS: 
;*   	none
;*
;* KEYWORDS:
;*      OVERPLOT  if you support this you can alter the appearance of your
;*              plot id it is an overplot to an exisiting panel. Standard is
;*              to plot data, no axis, using the y-scaling of the first plot
;*              and to shift the labeling on the left down one line. Useful
;*              to plot model data together with real data, ie mag. field.
;*              see p_crres_mag for an example.
;*      PLOTS_ATTHISPOSITION  used to control the lft side labeling for more
;*              than one overplot at the same position.
;*      _EXTRA  the plot structure containing some keyword for calls to
;*              plot. Used to customize color and linestyle.   
;* 
;* CALLING SEQUENCE:
;*       p_hydra_events, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;*
;* MODIFICATION HISTORY:       
;*     template written December 1995, Reiner Friedel, at Goddard
;*     customized for U of Iowa HYDRA Fall 1996, Jeremy Faden, U of Iowa
;*
;***************************************************************************

pro p_hydra_events, panel, type, file=file, $
           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
           _EXTRA=extra_par, subtable=subtable



; The following common blocks are needed:

   common time, xut1,xut2 ;common time limits in T90
   common mjdt, mjdt1, mjdt2

   common coordinateSystems, plotted_x, plotted_y  
                                        ;info on coords used by mouse

   common hydra_other_data, other_header, other_data
   common hydra_events_common, ticktype, pos

   common papco_color_names

   panelset,panel			;sets the panel position viewport

   oldy=!y
   oldx=!x

   goodticks, xtickv, xminor
   xticks=n_elements(xtickv)-1

; set duplex font if big_gif is device  ; duplex roman
   if !d.name eq 'Z' then font='!5' else font=getenv('hydra_font')

; the plot calls normally use the arrays t90 for the time axis and yray (ymat 
; for color plots) for the y or z axis.
   dxut= xut2-xut1
   
   extra_plotPar_common={yrange:[0, 1], xrange:[0,dxut], $
                         noerase:1, ticklen:-0.03, xticklen:-0.03, $ 
                         xtickv:xtickv, xminor:xminor, xticks:xticks, $
                         yticklen:0.010, $
                         ythick:1.3, xthick:1.3, max_value:1e30 }
   
; check if the passed in structure extra_par was set. If not, set color to
; default black; which for the color table used by PAPCO is 1.
   
   if n_elements(extra_par) EQ 0 then $
    extra_par={color:1}
   
; add keyword structure set here with the one passed in
   
   extra_plotPar=create_struct( extra_plotPar_common, extra_par)
      
   axis_plotPar= create_struct( extra_plotPar_common, {color:1} )

   if panel(0) eq 0 then begin
       xtickformat= 'hydra_timeticks'
   endif else begin
       xtickformat= 'noticks'
   endelse
   
   if not keyword_set(overplot) then begin
       plot, [0,1], /nodata, xstyle=1, ystyle=1, xtickformat=xtickformat, $
         _extra= axis_plotPar, yticks=1, ytickname=[' ',' ']
       if panel(0) eq 0 then $
         x_side_label,panel,font+'time (UT)!CDate',XTICKLEN=0.03
   endif else begin
       plot, [0,1], /nodata, xstyle=5, ystyle=5, xtickformat=xtickformat, $
         _extra= axis_plotPar
   endelse
   
   hydra_events, file=file, overplot=overplot, panel=panel

;  replot axes
   if not keyword_set(overplot) then begin
       plot, [0,1], /nodata, xstyle=1, ystyle=1, xtickformat=xtickformat, $
         _extra= axis_plotPar, yticks=1, ytickname=[' ',' ']
       if panel(0) eq 0 then $
         x_side_label,panel,font+'time (UT)!CDate',XTICKLEN=0.03
   endif else begin
       plot, [0,1], /nodata, xstyle=5, ystyle=5, xtickformat=xtickformat, $
         _extra= axis_plotPar
   endelse
   

; store the coordinate information into common block
   plotted_x = !x
   plotted_y = !y
   
   !x=oldx
   !y=oldy
   
end 





