pro r_hydra_bfield, options= options

   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_bfield_data, $
    bfield_type, $
    bfield_header, $
    bfield_lr_data, $
    bfield_mr_data, $
    bfield_hr_data, $
    bfield_ppar_data
   
   my_name='r_hydra_bfield'
   module_name='HYDRA-bfield'

   if n_elements( options ) eq 0 then options=0 ; define it
   
   if n_elements( bfield_header ) eq 0 then begin
       bfh1={  $
              start_time:long(0), $
              end_time:long(0), $
              data_version:float(0), $
              units:'', $
              options:long(0), $
              reload_flag:fix(0) $             
            }
       bfield_header = replicate(bfh1,4)
   ENDIF
   bfield_header(bfield_type).start_time=xut1
   bfield_header(bfield_type).end_time=xut2
   bfield_header(bfield_type).reload_flag=1
   
   forward_function convert_date_to_t90
   
   get_err_no=1
   get_err_msg= my_name +': unidentified error occured'
   
; read data files for time period
   num_files_read = 0
   time=xut1
   while time-1 lt xut2 do begin
       day_start= time / 86400 * 86400
       start_time= time - day_start
;          end_time is xut2 or midnight, whichever is sooner...
       end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] ) 
       end_time= end_time - day_start 
       convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om ; y2k
       if year lt 100 then year=year+1900
       date_str=string(year,month,day_om,format="(i4.4,i2.2,i2.2)")

       if start_time ne end_time then begin
           r_hydra_bfield_oneday, date_str, start_time, end_time, $
             data_values, options= options 
           
           if get_err_no eq 0 then BEGIN
              num_files_read = num_files_read + 1
              data_values(*).time= $
               data_values(*).time + ( day_start - xut1 )
              IF (num_files_read EQ 1) THEN BEGIN
                 data_buf = [data_values]
              ENDIF ELSE BEGIN
                 data_buf = [data_buf,data_values]
              ENDELSE
           endif       

       ENDIF

       time=day_start+86400          ; prepare to read next day
   endwhile
   
   if (n_elements(data_buf) gt 0) then BEGIN
      IF (bfield_type EQ 0) THEN BEGIN
         bfield_lr_data = data_buf
      ENDIF ELSE IF (bfield_type EQ 1) THEN BEGIN 
         bfield_mr_data = data_buf
     ENDIF ELSE if (bfield_type eq 2) then begin
          bfield_hr_data = data_buf
      endif else BEGIN
          bfield_ppar_data = data_buf
      ENDELSE
      get_err_no=0              ; all's well
  endif else begin
      get_err_no=2
      print,get_err_msg
      return
   endelse
   
   print,'Read '+module_name+': done'
   
   return
end


pro r_hydra_bfield_oneday, date_str, start_time, end_time, $
                           data_values, options=options

   common  get_error, get_err_no, get_err_msg
   common hydra_bfield_data, $
    bfield_type, $
    bfield_header, $
    bfield_lr_data, $
    bfield_mr_data, $
    bfield_hr_data, $
    bfield_ppar_data
   
   myname= 'r_hydra_bfield_oneday'

   print, myname+': options = ',options

   nocorrect= ( options and 1 ) eq 0 
   nofilter= ( options and 2 ) eq 0
   noclampbmag= ( options and 4 ) eq 0
   lag_correct= ( options and 16 ) eq 16

   IF (bfield_type EQ 0) THEN BEGIN
      
      f= hydra_findfile( date_str, /survey )
      if (f ne '') then begin
         print, myname+': opening '+f+'...'
         CDF= cdf_open(f)
         n= strlen(f)
         bfield_header(bfield_type).data_version= float( strmid( f, n-8, 4 ))
      endif else begin
         return                 ;hydra_findfile sets the error message
      endelse

      cdf_control, cdf, variable='TIME', get_var_info=r
      hyd_cdf_varget, cdf, 'TIME', time, rec_count=r.maxrec+1
      rec_start_bgsm = ( where( time ge start_time ) )(0)
      if rec_start_bgsm(0) eq -1 then begin
         get_err_msg= myname+': No data found after start_time '
         print, get_err_msg
         get_err_num = 1
         return
      ENDIF
      rec_stop_bgsm = ( where( time GE end_time) )(0)
      IF rec_stop_bgsm(0) EQ -1 THEN rec_stop_bgsm = r.maxrec
      
      rec_count_bgsm = rec_stop_bgsm - rec_start_bgsm  + 1
      
      ffill =  -1.e+31
; Read in the 'bgsm' data
      hyd_cdf_varget, cdf, 'TIME', t_gsm, $
       rec_start=rec_start_bgsm, rec_count=rec_count_bgsm
      hyd_cdf_varget, cdf, 'B_GSM', b_gsm, $
       rec_start=rec_start_bgsm, rec_count=rec_count_bgsm
      bfield_header(bfield_type).units='nT'
      hyd_cdf_varget, cdf, 'MODE', mode, $
        rec_start=rec_start_bgsm, rec_count=rec_count_bgsm
      good = where(mode NE 0 AND b_gsm(0,*) NE ffill AND b_gsm(1,*) $
                   NE ffill AND b_gsm(2,*) NE ffill)
      IF (good(0) NE -1) THEN BEGIN 
         time = t_gsm(good)
         bmag =  sqrt(b_gsm(0,good)^2 + b_gsm(1,good)^2 + b_gsm(2,good)^2)
         bx = b_gsm(0,good)
         by = b_gsm(1,good)
         bz = b_gsm(2,good)
         mag_pressure = (bmag*1.e-9*1.e+4)^2/(8*!pi)
      ENDIF ELSE BEGIN
         get_err_msg= myname+': No data found between start and end times '
         get_err_no= 1
         print, get_err_msg           
         return
      ENDELSE
      
      cdf_close, cdf

;*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_
; Now read in the payload B from the level1 file (it's not in the
; survey file)
      f= hydra_findfile( date_str, /level1 )
      if (f ne '') then begin
          print, myname+': opening '+f+'...'
          CDF= cdf_open(f)
          n= strlen(f)
          bfield_header(bfield_type).data_version= float( strmid( f, n-8, 4 ))
          l1found=1
      endif else begin
          l1found=0
          get_err_no=0          ; It's okay, we'll manage
          goto, l1notfound
      endelse

      cdf_control, cdf, variable='BLOCK_TIME', get_var_info=r
      hyd_cdf_varget, cdf, 'BLOCK_TIME', epoch, rec_count=r.maxrec+1
      time_pay = epoch MOD 86400000. / 1000.
      rec_start = ( where( time_pay ge start_time ) )(0)
      if rec_start(0) eq -1 then begin
         get_err_msg= myname+': No data found after start_time '
         print, get_err_msg
         get_err_no = 1
         return
      ENDIF
      
      rec_count = r.maxrec+1 - rec_start 

      hyd_cdf_varget, cdf, 'BLOCK_TIME', epoch, $
       rec_start=rec_start, rec_count=rec_count
      t_pay = epoch MOD 86400000. / 1000.
      hyd_cdf_varget, cdf, 'B_AVG', b_pay, $
       rec_start=rec_start, rec_count=rec_count

      cdf_close, cdf

; Synchronize the survey times and the level1 times
      ii = -1
      indp = lonarr(n_elements(time))
      indb = lonarr(n_elements(time))
      FOR itime=0,n_elements(time)-1 DO BEGIN
         index = where(long(t_pay) GE long(time(itime)))
         IF (index(0) NE -1) THEN BEGIN
            ii = ii+1
            indp(ii) = index(0)
            indb(ii) = itime
         ENDIF
      ENDFOR
      indp = indp(0:ii)
      indb = indb(0:ii)

;*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_

      l1notfound:
      if l1found eq 0 then begin
          indp= lindgen( n_elements( time ))
          indb= lindgen( n_elements( time ))
      endif
      
      data_values1= { hydra_bfield_data1, $
                      time:float(0), $
                      bmag:float(0), $
                      bx:float(0), $
                      by:float(0), $
                      bz:float(0), $
                      bx_pay:float(0), $
                      by_pay:float(0), $
                      bz_pay:float(0), $
                      mag_pressure:float(0), $
                      bvalid:byte(0), $
                      bflags:byte(0) $
                    }
      
      data_values = replicate( data_values1, n_elements(indb) )
      
      rr = lindgen(n_elements(indb))
      data_values(rr).time = reform(time(indb))  
      data_values(rr).bmag =  reform(bmag(indb))
      data_values(rr).bx =  reform(bx(indb))
      data_values(rr).by =  reform(by(indb))
      data_values(rr).bz =  reform(bz(indb))
      data_values(rr).mag_pressure = reform(mag_pressure(indb))
      data_values(rr).bvalid = 1
      data_values(rr).bflags = 0
      if ( l1found ) then begin
          data_values(rr).bx_pay = reform(b_pay(0,indp))
          data_values(rr).by_pay = reform(b_pay(1,indp))
          data_values(rr).bz_pay = reform(b_pay(2,indp))
      endif else begin
          data_values(rr).bx_pay = 1e31
          data_values(rr).by_pay = 1e31
          data_values(rr).bz_pay = 1e31
      endelse
      

   ENDIF ELSE IF (bfield_type EQ 1) THEN BEGIN ; Middle (8 Hz) resolution
      
      f= hydra_findfile( date_str, /level1 )
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdf_l1 = cdf_open(f)
      endif else begin
         return                 ;hydra_findfile sets the error message
      ENDELSE

      f= hydra_findfile( date_str, /ddcal )
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdfcal = cdf_open(f)
         n= strlen(f)
         bfield_header(bfield_type).data_version= float( strmid( f, n-8, 4 ))
      endif else begin
         return                 ;hydra_findfile sets the error message
      ENDELSE

;  check if high-resolution bfield vectors are available.
      cdf_control, cdf_l1, var='B_HIGH_RAW', get_var_info=r 
      IF n_elements( r ) GT 0 THEN BEGIN 
         IF r.maxrec GT -1 THEN BEGIN 
            print, 'High res. Bfield data is available in the level1 file'
         ENDIF ELSE BEGIN
            get_err_msg = myname+': High res. Bfield data not in level1 file'
            get_err_no = 1
            return
         ENDELSE
      ENDIF ELSE BEGIN
         get_err_msg = myname+': High res. Bfield data not in level1 file'
         get_err_no = 1
         return
      ENDELSE
;  -- end check if high-resolution bfield vectors are available

; Construct the 8 Hz bfield (in fixed payload) from mfe raw data
      gen_bfield, cdf_l1, cdfcal=cdfcal, start_time=start_time, $
        end_time=end_time, $
        /xyz, bx=bx_pay, by=by_pay, bz=bz_pay, time=t, $
        bvalid=bvalid, bflags=bflags, $
        fixed_payload=1, /mfetim, $
        nocorrect=nocorrect, nofilter=nofilter, noclampbmag=noclampbmag, $
        lag_correct=lag_correct
      cdf_close, cdf_l1
      cdf_close, cdfcal

      if nocorrect then begin
          bfield_header(bfield_type).units='counts'
      endif else begin
          bfield_header(bfield_type).units='nT'
      endelse

      bmag = fltarr(n_elements(bx_pay))
      mag_pressure = fltarr(n_elements(bx_pay))
      rnv = where(bvalid EQ 0)
      rv = where(bvalid eq 1)
      if rv(0) ne -1 then begin
          bmag(rv) = sqrt(bx_pay(rv)^2 + by_pay(rv)^2 + bz_pay(rv)^2)
          mag_pressure(rv) = (bmag(rv)*1.e-9*1.e+4)^2/(8*!pi)
      endif
      if rnv(0) ne -1 then BEGIN
         bmag(rnv)= 1e31
         bx_pay(rnv)= 1e31
         by_pay(rnv)= 1e31
         bz_pay(rnv)= 1e31
         mag_pressure(rnv) = 1e31
      ENDIF

; Rotate b_pay into the GSM coordinate frame
      if rv(0) eq -1 then rv=0  ; kludge
      bpaysend = fltarr(4,n_elements(rv))
      bpaysend(0,*) = bx_pay(rv)
      bpaysend(1,*) = by_pay(rv)
      bpaysend(2,*) = bz_pay(rv)
      bpaysend(3,*) = bmag(rv)
      hydra_payload_to_gsm, date_str, t(rv), bpaysend, bgsmback, istat, $
       rate=0
      b_gsm = fltarr(4,n_elements(bx_pay))
      b_gsm(*,rv) = bgsmback(*,*)
      if rnv(0) ne -1 then b_gsm(*,rnv) = 1e31

      data_values2= { hydra_bfield_data2, $
                      time:float(0), $
                      bmag:float(0), $
                      bx:float(0), $
                      by:float(0), $
                      bz:float(0), $
                      bx_pay:float(0), $
                      by_pay:float(0), $
                      bz_pay:float(0), $
                      mag_pressure:float(0), $
                      bvalid:byte(0), $
                      bflags:byte(0) $                     
                    }
      
      data_values = replicate( data_values2, n_elements(t) )
      
      rr = lindgen(n_elements(t))
      data_values(rr).time = reform(t)  
      data_values(rr).bmag =  reform(bmag)
      data_values(rr).bx =  reform(b_gsm(0,*))
      data_values(rr).by =  reform(b_gsm(1,*))
      data_values(rr).bz =  reform(b_gsm(2,*))
      data_values(rr).bx_pay =  reform(bx_pay)
      data_values(rr).by_pay =  reform(by_pay)
      data_values(rr).bz_pay =  reform(bz_pay)
      data_values(rr).mag_pressure = reform(mag_pressure)
      data_values(rr).bvalid = reform(bvalid(*))
      data_values(rr).bflags = reform(bflags(*))

      
  ENDIF ELSE if (bfield_type eq 2) then BEGIN ; High (hydra) resolution (27 Hz)

      
     f= hydra_findfile( date_str, /level1 )
     if (f NE '') then begin
        print, myname+': opening '+f+'...'
        cdf_l1 = cdf_open(f)
     endif else begin
        return                  ;hydra_findfile sets the error message
     ENDELSE
     
     f= hydra_findfile( date_str, /ddcal )
     if (f NE '') then begin
        print, myname+': opening '+f+'...'
        cdfcal = cdf_open(f)
        n= strlen(f)
        bfield_header(bfield_type).data_version= float( strmid( f, n-8, 4 ))
     endif else begin
        return                  ;hydra_findfile sets the error message
     ENDELSE

;  check if high-resolution bfield vectors are available.
      cdf_control, cdf_l1, var='B_HIGH_RAW', get_var_info=r 
      IF n_elements( r ) GT 0 THEN BEGIN 
         IF r.maxrec GT -1 THEN BEGIN 
            print, 'High res. Bfield data is available in the level1 file'
         ENDIF ELSE BEGIN
            get_err_msg = myname+': High res. Bfield data not in level1 file'
            get_err_no = 1
            return
         ENDELSE
      ENDIF ELSE BEGIN
         get_err_msg = myname+': High res. Bfield data not in level1 file'
         get_err_no = 1
         return
      ENDELSE
;  -- end check if high-resolution bfield vectors are available

      end_time = end_time < ( start_time + 3600. )

; Construct the 27 Hz bfield (in fixed payload) from mfe raw data
      gen_bfield, cdf_l1, cdfcal=cdfcal, start_time=start_time, $
        end_time=end_time, $
        /xyz, bx=bx_pay, by=by_pay, bz=bz_pay, time=t, $
        bvalid=bvalid, bflags=bflags, $
        fixed_payload=1, /hydtim, $
        nocorrect=nocorrect, nofilter=nofilter, noclampbmag=noclampbmag, $
        lag_correct=lag_correct
      
      cdf_close, cdf_l1
      cdf_close, cdfcal

      if nocorrect then begin
          bfield_header(bfield_type).units='counts'
      endif else begin
          bfield_header(bfield_type).units='nT'
      endelse

      bmag = fltarr(n_elements(bx_pay))
      mag_pressure = fltarr(n_elements(bx_pay))
      rnv = where(bvalid EQ 0)
      rv = where(bvalid eq 1)
      if rv(0) eq -1 then rv=0  ; kludge
      bmag(rv) = sqrt(bx_pay(rv)^2 + by_pay(rv)^2 + bz_pay(rv)^2)
      mag_pressure(rv) = (bmag(rv)*1.e-9*1.e+4)^2/(8*!pi)
      if rnv(0) ne -1 then BEGIN
         bmag(rnv)= 1e31
         bx_pay(rnv)= 1e31
         by_pay(rnv)= 1e31
         bz_pay(rnv)= 1e31
         mag_pressure(rnv) = 1e31
      ENDIF

; Rotate b_pay into the GSM coordinate frame
      if rv(0) eq -1 then rv=0
      bpaysend = fltarr(4,n_elements(rv))
      bpaysend(0,*) = bx_pay(rv)
      bpaysend(1,*) = by_pay(rv)
      bpaysend(2,*) = bz_pay(rv)
      bpaysend(3,*) = bmag(rv)
      hydra_payload_to_gsm, date_str, t(rv), bpaysend, bgsmback, istat, $
       rate=0
      b_gsm = fltarr(4,n_elements(bx_pay))
      b_gsm(*,rv) = bgsmback(*,*)
      if rnv(0) ne -1 then b_gsm(*,rnv) = 1e31

      data_values2= { hydra_bfield_data2, $
                      time:float(0), $
                      bmag:float(0), $
                      bx:float(0), $
                      by:float(0), $
                      bz:float(0), $
                      bx_pay:float(0), $
                      by_pay:float(0), $
                      bz_pay:float(0), $
                      mag_pressure:float(0), $
                      bvalid:byte(0), $
                      bflags:byte(0) $
                    }
      
      data_values = replicate( data_values2, n_elements(t) )
      
      rr = lindgen(n_elements(t))
      data_values(rr).time = reform(t)  
      data_values(rr).bmag =  reform(bmag)
      data_values(rr).bx =  reform(b_gsm(0,*))
      data_values(rr).by =  reform(b_gsm(1,*))
      data_values(rr).bz =  reform(b_gsm(2,*))
      data_values(rr).bx_pay =  reform(bx_pay)
      data_values(rr).by_pay =  reform(by_pay)
      data_values(rr).bz_pay =  reform(bz_pay)
      data_values(rr).mag_pressure = reform(mag_pressure)
      data_values(rr).bvalid= reform( bvalid(*) )
      data_values(rr).bflags= reform( bflags(*) )

  endif else begin              ; 54 Hz data
   
      f= hydra_findfile( date_str, /level1 )
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdf_l1 = cdf_open(f)
      endif else begin
         return                 ;hydra_findfile sets the error message
      ENDELSE

      f= hydra_findfile( date_str, /ddcal )
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdfcal = cdf_open(f)
         n= strlen(f)
         bfield_header(bfield_type).data_version= float( strmid( f, n-8, 4 ))
      endif else begin
         return                 ;hydra_findfile sets the error message
      ENDELSE

;  check if high-resolution bfield vectors are available.
      cdf_control, cdf_l1, var='B_HIGH_RAW', get_var_info=r 
      IF n_elements( r ) GT 0 THEN BEGIN 
         IF r.maxrec GT -1 THEN BEGIN 
            print, 'High res. Bfield data is available in the level1 file'
         ENDIF ELSE BEGIN
            get_err_msg = myname+': High res. Bfield data not in level1 file'
            get_err_no = 1
            return
         ENDELSE
     ENDIF ELSE BEGIN
         get_err_msg = myname+': High res. Bfield data not in level1 file'
         get_err_no = 1
         return
      ENDELSE
;  -- end check if high-resolution bfield vectors are available

      end_time = end_time < ( start_time + 3600. )

      gen_bfield, cdf_l1, cdfcal=cdfcal, start_time=start_time, $
        end_time=end_time, $
        /xyz, bx=bx_pay, by=by_pay, bz=bz_pay, time=t, $
        bvalid=bvalid, bflags=bflags, $
        fixed_payload=1, /Hz50, $
        nocorrect=nocorrect, nofilter=nofilter, noclampbmag=noclampbmag, $
        lag_correct= lag_correct
      cdf_close, cdf_l1
      cdf_close, cdfcal

      if nocorrect then begin
          bfield_header(bfield_type).units='counts'
      endif else begin
          bfield_header(bfield_type).units='nT'
      endelse

      bmag = fltarr(n_elements(bx_pay))
      mag_pressure = fltarr(n_elements(bx_pay))
      rnv = where(bvalid EQ 0)
      rv = where(bvalid eq 1)
      if rv(0) eq -1 then rv=0
      bmag(rv) = sqrt(bx_pay(rv)^2 + by_pay(rv)^2 + bz_pay(rv)^2)
      mag_pressure(rv) = (bmag(rv)*1.e-9*1.e+4)^2/(8*!pi)
      if rnv(0) ne -1 then BEGIN
         bmag(rnv)= 1e31
         bx_pay(rnv)= 1e31
         by_pay(rnv)= 1e31
         bz_pay(rnv)= 1e31
         mag_pressure(rnv) = 1e31
      ENDIF

; Rotate b_pay into the GSM coordinate frame
      bpaysend = fltarr(4,n_elements(rv))
      bpaysend(0,*) = bx_pay(rv)
      bpaysend(1,*) = by_pay(rv)
      bpaysend(2,*) = bz_pay(rv)
      bpaysend(3,*) = bmag(rv)
      hydra_payload_to_gsm, date_str, t(rv), bpaysend, bgsmback, istat, $
       rate=0
      b_gsm = fltarr(4,n_elements(bx_pay))
      b_gsm(*,rv) = bgsmback(*,*)
      if rnv(0) ne -1 then b_gsm(*,rnv) = 1e31

      data_values2= { hydra_bfield_data2, $
                      time:float(0), $
                      bmag:float(0), $
                      bx:float(0), $
                      by:float(0), $
                      bz:float(0), $
                      bx_pay:float(0), $
                      by_pay:float(0), $
                      bz_pay:float(0), $
                      mag_pressure:float(0), $
                      bvalid:byte(0), $
                      bflags:byte(0) $
                    }
      
      data_values = replicate( data_values2, n_elements(t) )
      
      rr = lindgen(n_elements(t))
      data_values(rr).time = reform(t)  
      data_values(rr).bmag =  reform(bmag)
      data_values(rr).bx =  reform(b_gsm(0,*))
      data_values(rr).by =  reform(b_gsm(1,*))
      data_values(rr).bz =  reform(b_gsm(2,*))
      data_values(rr).bx_pay =  reform(bx_pay)
      data_values(rr).by_pay =  reform(by_pay)
      data_values(rr).bz_pay =  reform(bz_pay)
      data_values(rr).mag_pressure = reform(mag_pressure)
      data_values(rr).bvalid = reform(bvalid(*))
      data_values(rr).bflags = reform(bflags(*))      
   
  ENDELSE

   bfield_header(bfield_type).options=options
   
   return
end



