pro r_hydra_current
   
   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_current_data, $
    current_header, $
    current_data

   common hydra_moments_data, $
    moments_species, $
    moments_header, $
    moments_ele_data, $
    moments_ion_data
   
   my_name='r_hydra_current'
   module_name='HYDRA-current'

   IF n_elements( current_header ) EQ 0 THEN BEGIN 
      mh1={ hydra_current_dum_header, $
            start_time:long(0), $
            end_time:long(0), $
            data_version:float(0), $
            reload_flag:fix(0) $
          }
      current_header = mh1
   ENDIF
   current_header.start_time=xut1
   current_header.end_time=xut2
   current_header.reload_flag=1
   
; Get electron data
   moments_species = 0
   r_hydra_moments
   current_header.data_version = moments_header(0).data_version
   IF (get_err_no NE 0) THEN BEGIN 
      get_err_no = 2
      get_err_msg = my_name+': Problem reading the electron data'
      print, get_err_msg
      return
   ENDIF

; Get ion data
   moments_species = 1
   r_hydra_moments
   IF (get_err_no NE 0) THEN BEGIN 
      get_err_no = 2
      get_err_msg = my_name+': Problem reading the ion data'
      print, get_err_msg
      return
   ENDIF 


; Synchronize the electron and ion times^_^_^_^_^_^_^_^_^_^_^_^_^_^_^_^_^_^_
   print, my_name+': SYNCHRONIZING ION/ELE TIMES...'

   time_ele = moments_ele_data.time
   time_ion = moments_ion_data.time

   inde = lonarr(n_elements(time_ele))
   indi = lonarr(n_elements(time_ele))
   ii = -1
   FOR itime= 0, n_elements(time_ele)-1 DO BEGIN
      match = where(long(time_ion) EQ long(time_ele(itime)))
      IF (match(0) NE -1) THEN BEGIN
         ii = ii+1
         indi(ii) = match(0)
         inde(ii) = itime
      ENDIF
   ENDFOR
   indi = indi(0:ii)
   inde = inde(0:ii)

; Moment data needed in the current study (cs_hydra_current.pro)
   data_temp = { hydra_current_data_1, $
                 time:0.0, $
                 time_ssm:0.0, $
                 density_ele:0.0, $
                 density_ion:0.0, $
                 mean_energy_ele:0.0, $
                 mean_energy_ion:0.0, $
                 ktparl_ele:0.0, $
                 ktperp_ele:0.0, $
                 ktparl_ion:0.0, $
                 ktperp_ion:0.0, $
                 u_pay_ion:fltarr(4), $
                 u_pay_ele:fltarr(4), $
                 u_gsm_ion:fltarr(4), $
                 u_gsm_ele:fltarr(4), $
                 u_gse_ion:fltarr(4), $
                 u_gse_ele:fltarr(4), $
                 b_pay:fltarr(4), $
                 b_pay_sig:fltarr(4), $
                 b_angle_cone:0.0, $
                 b_gsm:fltarr(4), $
                 eflux_parl_ion:0.0, $
                 eflux_parl_ele:0.0 $
               }
   date = moments_ele_data(0).date
   data = replicate (data_temp, n_elements(inde))
   data.time = moments_ele_data(inde).time
   data.time_ssm = moments_ele_data(inde).time_ssm
   data.density_ele = moments_ele_data(inde).density
   data.density_ion = moments_ion_data(indi).density
   data.mean_energy_ele = moments_ele_data(inde).mean_energy
   data.mean_energy_ion = moments_ion_data(indi).mean_energy
   data.ktparl_ele = moments_ele_data(inde).ktparl
   data.ktperp_ele = moments_ele_data(inde).ktperp
   data.ktparl_ion = moments_ion_data(indi).ktparl
   data.ktperp_ion = moments_ion_data(indi).ktperp
   data.u_pay_ion = moments_ion_data(indi).u_pay
   data.u_pay_ele = moments_ele_data(inde).u_pay
   data.u_gsm_ion = moments_ion_data(indi).u_gsm
   data.u_gsm_ele = moments_ele_data(inde).u_gsm
   data.u_gse_ion = moments_ion_data(indi).u_gse
   data.u_gse_ele = moments_ele_data(inde).u_gse
   data.b_pay = moments_ele_data(inde).b_pay
   data.b_pay_sig = moments_ele_data(inde).b_pay_sig
   data.b_gsm = moments_ele_data(inde).b_gsm
   data.b_angle_cone = moments_ele_data(inde).b_pay_angle_cone
   data.eflux_parl_ion = moments_ion_data(indi).eflux_parl
   data.eflux_parl_ele = moments_ele_data(inde).eflux_parl

; 3/26/99 - Initialize the entire array with rfills
   rfill = -1.e+31

   data_values_temp = { hydra_current_data_2, $
                        date:'YYYYMMDD', $
                        time:0.0+rfill, $
                        time_ssm:0.0+rfill, $
                        total_pressure:0.0+rfill, $
                        total_particle_pressure:0.0+rfill, $
                        total_magnetic_pressure:0.0+rfill, $
                        total_parl_particle_pressure:0.0+rfill, $
                        total_perp_particle_pressure:0.0+rfill, $
                        total_anisotropy:0.0+rfill, $
                        cp_bmag_avg:0.0+rfill, $
                        cp_delb:0.0+rfill, $
                        cp_delta_b_over_b:0.0+rfill, $
                        cp_curl:0.0+rfill, $
                        du_perp_pay:fltarr(4)+rfill, $
                        du_perp_gsm:fltarr(4)+rfill, $
                        du_parl:0.0+rfill, $
                        j_parl:0.0+rfill, $
                        j_parl_filtered:0.0+rfill, $
                        j_perp_pay:fltarr(4)+rfill, $
                        j_perp_pay_filtered:fltarr(4)+rfill, $
                        j_perp_gsm:fltarr(4)+rfill, $
                        j_perp_gsm_filtered:fltarr(4)+rfill, $
                        cls:0.0+rfill,$
                        cls_rgyro_ion:0.0+rfill,$
                        cls_rgyro_ele:0.0+rfill,$
                        cls_inert_ion:0.0+rfill,$
                        cls_inert_ele:0.0+rfill,$
                        rgyro_ion:0.0+rfill,$
                        rgyro_ele:0.0+rfill,$
                        inert_ion:0.0+rfill,$
                        inert_ele:0.0+rfill,$
                        j_gse:fltarr(4)+rfill, $
                        j_gsm:fltarr(4)+rfill, $
                        b_gsm:fltarr(4)+rfill, $
                        b_angle_cone:0.0+rfill, $
                        cls_parl:0.0+rfill, $
                        cls_parl_rgyro_ion:0.0+rfill, $
                        cls_parl_rgyro_ele:0.0+rfill, $
                        cls_parl_inert_ion:0.0+rfill, $
                        cls_parl_inert_ele:0.0+rfill, $
                        total_eflux_parl:0.0+rfill, $
                        total_eflux_parl_over_b:0.0+rfill $
                      }
   data_values = replicate( data_values_temp, n_elements(inde) )
   
   data_values.date = moments_ele_data(inde).date
   data_values.time = data.time
   data_values.time_ssm = data.time_ssm
   data_values.b_gsm = data.b_gsm
   data_values.b_angle_cone = data.b_angle_cone
   

   
; Find the current-related quantities
   cs_hydra_current, date, data, data_values

   current_data = data_values

   return
END




