pro test_r_hydra_walen, b_mom

common walen_data, datestr, starttime, stoptime, $
  diff_method, zoom, wdata, inds, ref_index, wfit


!p.multi = [0,1,1]
window, 0, xsize=900, ysize=800
hydra_setcolors, cs

plot, wdata.time, wdata.density_ion, psym=2,symsize=.5, xtickformat='tick_hms_pam', title='density_ion', charsize=2.0
errplot, wdata.time, wdata.density_ion-wdata.density_sigma_ion, wdata.density_ion+wdata.density_sigma_ion
res=get_kbrd(1)

plot, wdata.time, wdata.density_ele, psym=2,symsize=.5, xtickformat='tick_hms_pam', title='density_ele', charsize=2.0
errplot, wdata.time, wdata.density_ele-wdata.density_sigma_ele, wdata.density_ele+wdata.density_sigma_ele
res=get_kbrd(1)

!p.multi = [0,1,3]
for ic=0,2 do begin
    plot, wdata.time, wdata.u_ion(ic), psym=2,symsize=.5, xtickformat='tick_hms_pam', title='U_ion', charsize=2.0
    errplot, wdata.time, wdata.u_ion(ic)-wdata.u_sigma_ion(ic), wdata.u_ion(ic)+wdata.u_sigma_ion(ic)
endfor
res=get_kbrd(1)

for ic=0,2 do begin
    plot, wdata.time, wdata.u_ele(ic), psym=2,symsize=.5, xtickformat='tick_hms_pam', title='U_ele', charsize=2.0
    errplot, wdata.time, wdata.u_ele(ic)-wdata.u_sigma_ele(ic), wdata.u_ele(ic)+wdata.u_sigma_ele(ic)
endfor
res=get_kbrd(1)

for ic=0,2 do begin
    plot, wdata.time, wdata.b_pay(ic), psym=2,symsize=.5, xtickformat='tick_hms_pam', title='mfe_b', charsize=2.0
    oplot,wdata.time, b_mom(ic,*), psym=1, color=cs.red
    errplot, wdata.time, wdata.b_pay(ic)-wdata.b_pay_sigma(ic), wdata.b_pay(ic)+wdata.b_pay_sigma(ic)
endfor
res=get_kbrd(1)

!p.multi=[0,1,2]

plot, wdata.time, wdata.pres_parl, psym=2,symsize=.5, xtickformat='tick_hms_pam', title='pres_parl', charsize=2.0
plot, wdata.time, wdata.pres_perp, psym=2,symsize=.5, xtickformat='tick_hms_pam', title='pres_perp', charsize=2.0


return
end

