function array_concatenate, A1_in, A2_in, dimension
;+
; NAME: array_concatenate
;
; PURPOSE: concatenate two n-dimensional arrays on any dimension.
;
; CATEGORY: utility
;
; CALLING SEQUENCE: result= array_concatenate( Array1, Array2, dimension )
; 
; INPUTS: 
;    dimension       the dimension on which to concatenate the arrays. 
;                      1 is the first dimension.
;    Array1, Array2  The two arrays.  The dimensions of the two arrays
;                      must have the same number of elements, except
;                      for the dimension that is to be concatenated.
;            
; OPTIONAL INPUTS:
;    if dimension is not specified, then concatenation is on the first
;      dimension.
;	
; KEYWORD PARAMETERS: none.
;
; OUTPUTS:
;    returns concatenated arrays.
;
; PROCEDURE:
;
; EXAMPLE:
;    A= fltarr(10,3,7)
;    B= fltarr(10,5,7)
;    C= array_concatenate(A,B,2)
;    help, C
;    <Expression>    FLOAT     = Array[10, 8, 7] 
;
; MODIFICATION HISTORY:
;   Written, October 19, 1999 by Jeremy Faden.
;-
  on_error, 2
  if n_elements( dimension ) eq 0 then dimension=1
  index= dimension-1
  A1= A1_in
  A2= A2_in
  s1= size(A1)
  s2= size(A2)
  indeces= indgen(s1(0))
  r= where( indeces ne index )
  remaining_indeces= indeces(r)  
  transpose_p= [ index, remaining_indeces ]
  inverse_transpose_p= intarr(s1(0))
  inverse_transpose_p(transpose_p)= indgen(s1(0))
    
  A1= transpose( A1, transpose_p )
  A2= transpose( A2, transpose_p )
  result= [ A1, A2 ]

  result= transpose( result, inverse_transpose_p )
  return, result
end
