function cdf_varexist, id, variable, _extra=e
;+
; cdf_varexist
; 
; tests a cdf file for the existance of a variable.  
;
; usage: r= cdf_varexist( <id>, <variable> )
; I/O:
;     id        the cdf ID, returned from cdf_open or cdf_create.
;     variable  a string containing the name of the variable or the
;                  variable number being inquired.
;     _extra=e  extra keywords are passed on to cdf_varinq
;
; Procedure:
;     Set catch condition to trap errors.  Attempt call to cdf_varinq,
; passing on I/O received by cdf_varexist.  If no error is caught,
; then return 1 for "true", if -473 is caught, which is the IDL error
; "Cannot find variable name: VARIABLE" then return 0 for "false."
; Unrecognized errors cause the routine to halt.
;
; Example:
;     if cdf_varexist( CDF, 'sea_surface_temp' ) then $
;         cdf_varget, CDF, 'sea_surface_temp', sst
;
; Written, January 27, 1998  Jeremy Faden
;
; Known Bugs: 
;   1. different versions of IDL produce different error codes.  In the
;      past, this has caused the program to fail as new versions of
;      IDL were encountered.  This problem should be fixed now, since
;      !error_state.name is used to detect the error.
;   2. The error, "% CDF_VARINQ: Cannot find variable: <var>" is printed,
;      which is undesirable though harmless.
;-     
   if float( !version.release ) ge 5.1 then begin
       return, cdf_varexist_51( id, variable )
   endif

   exist=1
   catch, error
   if error eq 0 then begin
       r= cdf_varinq( id, variable, _extra=e )
   endif else begin
       catch, /cancel
       if (error eq -473) or (error eq -542) or $
         (error eq -7 ) or (error eq -805) then begin
           exist=0
       endif else begin
           message, !err_string, /cont
           message, string(!error), /cont
           stop
       endelse 
   endelse                      ; error
   catch, /cancel
   return, exist
end




;       if 0 then begin
;       if float(!version.release) ge 5.1 then begin
;           if !error_state.name eq 'IDL_M_CDF_ERROR' then begin
;               exist=0
;           endif else begin
;               r= cdf_varinq( id, variable, _extra=e )
;           endelse
;       endif else begin    
