function cdf_varexist_51, id, variable, _extra=e
;+
; cdf_varexist
; 
; tests a cdf file for the existance of a variable.  
;
; usage: r= cdf_varexist( <id>, <variable> )
; I/O:
;     id        the cdf ID, returned from cdf_open or cdf_create.
;     variable  a string containing the name of the variable or the
;                  variable number being inquired.
;     _extra=e  extra keywords are passed on to cdf_varinq
;
; Procedure:
;     Set catch condition to trap errors.  Attempt call to cdf_varinq,
; passing on I/O received by cdf_varexist.  If no error is caught,
; then return 1 for "true", if "variable not found"-sort of error
; detected, then return 0.  Otherwise halt and display error.
;
; Example:
;     if cdf_varexist( CDF, 'sea_surface_temp' ) then $
;         cdf_varget, CDF, 'sea_surface_temp', sst
;
; Written, February 25, 1999 Jeremy Faden -- Thanks to Eric Dors for
;             pointing out !error_state.  Hopefully this is the end of
;             a lot of headaches!
;
; Known Bugs: 
;   1. The error, "% CDF_VARINQ: Cannot find variable: <var>" is printed,
;      which is undesirable though harmless.
;-     

  quiet0= !quiet
  !quiet=1
  exist=1
  catch, error
  if error eq 0 then begin
      r= cdf_varinq( id, variable, _extra=e )
  endif else begin
      catch, /cancel
      if !error_state.name eq 'IDL_M_CDF_ERROR' then begin
          exist=0
      endif else begin
          r= cdf_varinq( id, variable, _extra=e )
      endelse
  endelse                       ; error
  catch, /cancel
  !quiet= quiet0

  return, exist
end

