function efi_to_payload, date
;  returns matrix for rotating efi to payload.  This matrix is
;  only flips signs or rotates by 90 degrees.
;  date is in YYYYMMDD
;
; THIS IS APPROXIMATE, AND ROTATIONS FOR DATES NEAR TIME INTERVAL 
;  BOUNDS ARE PROBABLY WRONG !!!!!

;From fmozer@ssl.berkeley.edu Wed Jan 27 16:47:55 1999
;Date: Wed, 27 Jan 1999 14:47:47 -0800
;From: fmozer@ssl.berkeley.edu (Forrest Mozer)
;To: jds@space-theory.physics.uiowa.edu
;Subject: Re: Coordinate Systems
;Cc: fmozer@ssl.berkeley.edu, winston@ssl.berkeley.edu
;X-Sun-Charset: US-ASCII
;Content-Length: 569
;
;Our understanding of coordinates is different from yours.  We think
;
;X(hydra) = -XY(EFI)
;Y(Hydra) = -Z(EFI) for mid-January to mid-April and mid-July to mid-October
;Y(Hydra) = +Z(EFI) for mid-April to Mid-July and Mid-October to Mid-January
;Z(Hydra) = +56(EFI) for mid-January to mid-April and mid-July to mid-October
;Z(Hydra) = -56(EFI) for mid-April to Mid-July and Mid-October to Mid-January

;  efi=[XY,Z,56]

mmdd= strmid( date, 4,4 )

q= ( mmdd gt 0115 and mmdd le 0415 ) * 1 + $
  ( mmdd gt 0415 and mmdd le 0715 ) * 2 + $ ; sun_theta increasing
  ( mmdd gt 0715 and mmdd le 1015 ) * 3
if q eq 0 then q=4

M= fltarr(3,3)

; X payload
M(0,*)= [ -1,0,0 ]

; flip y and z if sun_phase is decreasing
f= hydra_findfile( date, /ddcal )
if f ne '' then begin 
    cdf= cdf_open(f)
    cdf_varget, cdf, 'SUN_THETA', st1
    cdf_control, cdf, var='SUN_THETA', /zvar, get_var_info=r
    cdf_varget, cdf, 'SUN_THETA', st2, rec_start=r.maxrec-1
    flip= (st2(0)-st1(0)) le 0.
    cdf_close, cdf
endif else begin
    message, 'flipping efi Y and Z by date.', /cont
    flip= ( q eq 1 or q eq 3 )
endelse

; flip means "flip y"

; Y and Z payload
if flip then begin
    M(1,*)= [0,-1,0]
    M(2,*)= [ 0,0,1 ]
endif else begin
    M(1,*)= [0,1,0]
    M(2,*)= [ 0,0,-1 ]
endelse

return, M
end
