function fft_freq, x
;+
; NAME: fft_freq
;
; PURPOSE: return the frequencies for the fft bins
;
; CATEGORY: 
;
; CALLING SEQUENCE: freq= fft_freq(time)
; 
; INPUTS: time, the abscissae for the data in the time-domain.
;
; KEYWORD PARAMETERS:
;
; OUTPUTS: returns abscissae for data in the frequency-domain.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS: time needs to be monotonic, of course. 
;
; PROCEDURE:  The difference between the first two elements is
;   used to define the nyquist frequency/.
;
; EXAMPLE:
;   time=findgen(1000)*0.01 
;   f= 0.5 ; Hz 
;   w= f * 2 * !pi 
;   wav= sin( time * w ) 
   
;   f= 4.5
;   w= f * 2 * !pi
;   wav2= sin( time * w ) 

;   plot, time, wav+wav2
;   plot, fft_freq(time), abs( fft( wav+wav2 )), xrange=[0,5] 
;
; MODIFICATION HISTORY:
;    written, jbf

;-
;   time=findgen(1000)*0.01 
;   f= 0.5 ; Hz 
;   w= f * 2 * !pi 
;   wav= sin( time * w ) 
   
;   f= 4.5
;   w= f * 2 * !pi
;   wav2= sin( time * w ) 

;   plot, time, wav+wav2
;   plot, fft_freq(time), abs( fft( wav+wav2 )), xrange=[0,5] 

   n= n_elements( x )
   t= x(1)-x(0)
   n21= n/2 + 1
   
   f= lindgen(n)
   f(n21)= n21 - n + findgen(n21-2)

   f= f/(n*t)

   return, f

end
