function gen_time_to, time, $
                      t90=t90, $
                      string=string, $
                      decimal_year=decimal_year

  if keyword_set( t90 ) then begin
      return, time*86400 + 189216000
  endif else if keyword_set( string ) then begin
      if (size(time))(0) ne 0 then begin
          result= string(time)
          for i=0,n_elements(time)-1 do $
            result(i)= gen_time_string(time(i))
      endif else result= gen_time_string(time)     
      return, result
  endif else if keyword_set( decimal_year ) then begin
      y= [ 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 ]
      x= [    1,  367,  732, 1097, 1462, 1828, 2193, 2558, 2923, 3289 ] 
      r= where( time lt 1 or time gt 3289, count )
      if count gt 0 then message, 'Only dates between 1996 and 2005.'
      result= interpol( double(y), double(x), time )
      if (size(time))(0) ne 0 then return, result else $
        return, result(0)
  endif
end
  
