;pro testit
;  spawn, 'rm /tmp/test.cdf'
;  cdf= cdf_create('/tmp/test.cdf', /single ) 
;  x= cdf_varcreate( cdf, 'myvar', /cdf_float, /zvariable ) 
;   x= cdf_varcreate( cdf, 'imyvar', /cdf_int4, /zvariable )
;   x= cdf_attcreate( cdf, 'float_attribute' )
;   hyd_cdf_attput, cdf, 'float_attribute', 0, 1.23
;   cdf_close, cdf
;end

pro hyd_cdf_attput, id, attribute, entrynum, value, _extra=e, zvariable=zvariable

;+
; NAME: hyd_cdf_attput
;
; PURPOSE: wrap cdf_attput, handing endian problems of sunos x86 platform.
;
; CATEGORY:
;
; CALLING SEQUENCE: see cdf_attput.
; 
; INPUTS: I/O the same as for cdf_attput.
;
; RESTRICTIONS:
;   assumes that variable is a zvariable.
;
; PROCEDURE:
;   call swap_endian() if platform is sunos x86.
;
; EXAMPLE:
;   cdf= cdf_create('/tmp/test.cdf', /single ) 
;   x= cdf_varcreate( cdf, 'myvar', /cdf_float, /zvariable ) 
;   x= cdf_varcreate( cdf, 'imyvar', /cdf_int4, /zvariable )
;   x= cdf_attcreate( cdf, 'float_attribute' )
;   cdf_attput, cdf, 'float_attribute', 0, 1.23
;   cdf_close, cdf
;
; MODIFICATION HISTORY:
;  written, jbf, University of Iowa, June 18, 2001.
;-


  if (!version.arch eq 'x86') and $
    (!version.os eq 'sunos') then begin
      if cdf_attexists(id,attribute,entrynum) then begin
          cdf_attget, id, attribute, entrynum, v1, zvariable=zvariable
          if size(v1,/type) ne size(value,/type) then begin
              message, 'type not correct.  Need cast before hyd_cdf_varput.',/cont
              stop
          endif
      endif 
      v1= value
      v1= swap_endian(v1)
      cdf_attput, id, attribute, entrynum, v1, _extra=e, zvariable=zvariable
  endif else begin
      v1= value
      cdf_attput, id, attribute, entrynum, v1, _extra=e, zvariable=zvariable
  endelse
end

