pro hyd_cdf_varput, id, variable, value, _extra=e, zvariable=zvariable

;+
; NAME: hyd_cdf_varput
;
; PURPOSE: wrap cdf_varput, handing endian problems of sunos x86 platform.
;
; CATEGORY:
;
; CALLING SEQUENCE: hyd_cdf_varput, id, variable, value
; 
; INPUTS: I/O the same as for cdf_varput.
;
; RESTRICTIONS:
;   assumes that variable is a zvariable.
;
; PROCEDURE:
;   call swap_endian() if platform is sunos x86.
;
; EXAMPLE:
;   cdf= cdf_create('/tmp/test.cdf', /single ) 
;   x= cdf_varcreate( cdf, 'myvar', /cdf_float, /zvariable ) 
;   x= cdf_varcreate( cdf, 'imyvar', /cdf_int4, /zvariable )
;   cdf_close, cdf 
;   cdf= cdf_open( '/tmp/test.cdf') 
;   hyd_cdf_varput, cdf, 'myvar', indgen(50)   ; catch on a sunos x86
;   hyd_cdf_varput, cdf, 'myvar', float(indgen(50)) ; okay on all machines
;   hyd_cdf_varput, cdf, 'imyvar', indgen(50)   ; catch on a sunos x86
;   hyd_cdf_varput, cdf, 'imyvar', long(indgen(50)) ; okay on all machines
;   cdf_close, cdf 
;
; MODIFICATION HISTORY:
;  written, jbf, University of Iowa, June 18, 2001.
;-


  if (!version.arch eq 'x86') and $
    (!version.os eq 'sunos') then begin
      cdf_control, id, var=variable, zvariable=zvariable, get_var_info=x
      v1= x.padvalue
;      cdf_varget1, id, variable, v1
       if size(v1,/type) ne size(value,/type) then begin
           message, 'type not correct.  Need cast before hyd_cdf_varput.',/cont
           stop
       endif
      v1= value
      v1= swap_endian(v1)
      cdf_varput, id, variable, v1, _extra=e, zvariable=zvariable
  endif else begin
      cdf_varput, id, variable, value, _extra=e, zvariable=zvariable
  endelse
end
