function hyd_colorbar_map, Z, $
                           skew=skew, $ ; use skew transform
                           zlog=zlog, $ 
                           zrange=zrange_in, $
                           abs_z_max=zmax, $
                           abs_z_min=zmin, $
                           fill=fill, $
                           nodata=nodata, $
                           ctable=ctable

;  For /skew:
;  Transform value to color space using "skew" transform.  Skew
;  Skew transform is defined for zlog=1 as:
;    linearized= sign(Z)*alog10(abs(Z)/zmin)   if abs(Z) ge zmin and
;    linearized= black                         if abs(Z) lt zmin.
;
;    r_color is a warm color if sign(Z) is positive and cool is
;      sign(Z) is negative.
;
;  For zlog=0 the transform is:
;    linearized= sign(Z)*(abs(Z)-zmin)         if abs(Z) ge zmin and
;    linearized= black                         if abs(Z) lt zmin
;
;  z= randomn(s,118,118) 
;  z= smooth(z,9,9)
;  z= z(10:109,10:109)
;  xy= findgen(100)
;  hydra_plotcolor, Z, xy, xy, xrange=[-1,101], yrange=[-1,101], $
;     xstyle=1, ystyle=1
;  contour, Z, xy, xy, /overplot, levels=[0.], color=get_color_index('black')
;  Zcolor= hyd_colorbar_map( Z, /skew, ctable=cs.colortable2 )
;  hydra_plotcolor, Zcolor, xy, xy, zrange=[0,255], ctable=[0,255]

  if n_elements( zlog ) eq 0 then zlog=0

  if n_elements( zmax ) eq 0 then zmax=max(abs(Z))

  if n_elements( zmin ) eq 0 then begin
      if zlog then $
        message, 'abs_z_min must be specified for /skew and /zlog'
      zmin=0.
  endif
  if zlog and zmin le 0. then $
    message, 'abs_z_min must be greater than zero.'

  if n_elements( zrange ) eq 0 then zrange=[0.,0.]
  if n_elements( ctable ) eq 0 then begin
      common hydra_setcolors1_common, cs_common
      ctable= cs_common.colortable
  endif

  linear= make_array( size=size(Z) )
  sign_Z= make_array( size=size(Z) ) +1
  r= where( Z lt 0. )
  if r(0) ne -1 then sign_Z(r)=-1

  if skew then begin
      if zlog then begin
          r= where( abs(Z) ge zmin )
          if r(0) ne -1 then begin
              linear(r)= sign_Z(r)*alog10(abs(Z(r))/zmin)
          endif
          zrange= [ -1,1 ] * alog10( zmax/zmin )
      endif else begin
          r= where( abs(Z) ge zmin )
          if r(0) ne -1 then begin
              linear(r)= sign_Z(r)*(abs(Z(r))-zmin)
          endif
          zrange= [ -1,1 ] * ( zmax-zmin )
      endelse
      rblack= where( abs(Z) lt zmin )
  endif else begin
      if zlog then begin
          linear= alog10(Z)
          zrange= alog10( zrange_in )
      endif else begin
          linear= Z
          zrange= zrange_in
      endelse
      rblack= -1
  endelse

  color= bytscl( linear, min=zrange(0), max=zrange(1), $
                 top= ctable(1)-ctable(0)+1 ) + ctable(0)
                
  if rblack(0) ne -1 then begin
      color(rblack)= get_color_index('black')
  endif

  if n_elements( fill ) ne 0. then begin
      rfill= where( Z eq fill )
      if rfill(0) ne -1 then begin
          color(rfill)= get_color_index('grey')
      endif
  endif

  return, color

end


