pro hyd_file_status, file, $
                     write= canwrite, read=canread, $
                     exist=exist, $
                     date=date
;+
; NAME: hyd_file_status
;
; PURPOSE: check a file for write or read access, or existence.
;
; CATEGORY: utility
;
; CALLING SEQUENCE: hyd_file_status, file, write=write, read=read, exist=exist
; 
; INPUTS: 
;    file     the name of the file to check (string).
;	
; KEYWORD PARAMETERS:
;    write=write   returns 1 if can write, 0 if can't write
;    read=read     returns 1 is can read, 0 if can't read
;    exist=exist   returns 1 if file exists, 0 otherwise
;    date=date     return file date in doy96.  On non-unix systems,
;                     this is fill.
;
; COMMON BLOCKS: none
;
; SIDE EFFECTS: none
;
; RESTRICTIONS:
;    handles demo mode.  Date function does not work on non-unix systems.
;
; PROCEDURE: set exist by using findfile(file), check demo mode, 
;    set read and write by attempting to open, trapping errors.
;
; EXAMPLE: 
;    hyd_file_status, 'test_file', exist=exist, read=read, write=write
;    help, exist, read, write
;
; MODIFICATION HISTORY:
;    written, summer 1999, jbf.
;-


  canread=0
  canwrite=0
  exist=0
  date= -1d31
  
  if file eq '' then return

  f= findfile( file, count=count )
  exist= fix( count eq 1 )
  
  on_ioerror, g1
  openr, lun, file, /get_lun
  canread=1
  close, lun
  free_lun, lun
  
g1:
  if not demo_mode() then begin ; one can't write files in demo_mode       
      on_ioerror, g2
      if exist then begin
          openw, lun, file, /append, /get_lun
          canwrite=1
          close, lun
          free_lun, lun
      endif else begin
          openw, lun, file, /delete, /get_lun
          canwrite=1
          close, lun
          free_lun, lun
      endelse
  endif
g2:

; FOLLOWING CODE WORKS FINE BUT SPAWN IS SLOW.  
;  unix= !version.os_family eq 'unix'
;  if not demo_mode() then begin
;      if exist then begin
;          if unix then begin
;              date= get_file_date( file )
;              spawn, 'ls -l '+file, result
;              date_str= strmid( result[0], 41, 12 )
;              x=parse_unix_date( date_str )
;              date=x
;          endif 
;      endif
;  endif

end

