; Hydra portibility.  
;   A set of routines that makes writing platform-independent codes
; simple.
 
pro hyd_set_plot, device_in, _extra=e
   device= strlowcase(device_in)
   case strlowcase(!version.os_family) of
       'windows': begin
           win_device='win'
       end
       'unix': begin
           win_device='x'
       end
       else: begin
           message, 'os_family not recognized.  Using X device.', /cont
           win_device='x'
       end
   endcase
   if device eq 'x' or device eq 'win' then begin
       device= win_device
   endif
   set_plot, device, _extra=e
   return
end

pro hyd_spawn, command, result, _extra=e
   if !version.os_family eq 'windows' then begin
       message, 'spawn disabled in windows environment.', /cont
   endif else begin
       spawn, command, result, _extra=e
   endelse
   return
end

pro hyd_os, os
   os= { path_sep:'', $
         dir_sep:'' }
   if !version.os_family eq 'windows' then begin
       os.path_sep=';'
       os.dir_sep='/'
   endif else begin
       os.path_sep=':'
       os.dir_sep='/'
   endelse
end
   
pro hyd_portability
;  call me to cause this routine to compile
end

