FUNCTION hyd_prod_qual_v01, product_type=name_in, date=date_in, $
                            product_version=version_in
;
;
;  Return data quality code:

;      3 = Up-to-date
;      2 = Not Up-to-date, but nothing better is currently available
;      1 = Not Up-to-date: something better is currently available
;     -1 = Information unavailable
;     Other Negative - Error occured
;
;  Input Keywords:
;  
;
;     product_type       STRING (dstatdb variable)
;     date               STRING/LONG (yyyymmdd)
;     product_version    FLOAT (version number)
;
;
;
; Check Inputs
;
   if strlowcase( !version.os_family ) eq 'windows' then begin
       message, 'Windows operating system: assuming no wget resource.', /cont
       return, -1
   endif
    
   IF NOT keyword_set(name_in) THEN BEGIN
      message, 'Must specify product_type=name', /continue
      return, -10
   ENDIF ELSE BEGIN
      type = 'product_type='+strtrim(name_in,2)
   ENDELSE 
   IF NOT keyword_set(date_in) THEN BEGIN
      message, 'Must specify date=yyyymmyy', /continue
      return, -11
   ENDIF ELSE BEGIN
      date = 'date='+strtrim(date_in,2)
   ENDELSE 
   
;   IF NOT keyword_set(version_in) THEN BEGIN
   IF (n_elements(version_in) EQ 0) THEN BEGIN
      message, 'Must specify product_version=version', /continue
      return, -12
   ENDIF ELSE BEGIN
      version = 'product_version='+strtrim(string(version_in),2)
   ENDELSE 
   
;
;
; If web_get exists then connect to server and read result back.
;
   wget = getenv('wget_exe')
   error = 1
   IF ((wget ne "") and (wget ne '0')) THEN BEGIN 
      address = "http://supras.physics.uiowa.edu/cgi-bin/"+$
       "hydra_versions/hydra_product_quality"
      command =  wget+' -T 20 -O - "'+address+'?'+type+'&'+date+'&'+version+'"'
      spawn, command, unit=lun
   
      ON_IOERROR, web_error
      code = long(0)
      readf, lun, code
      free_lun, lun
      error = 0

web_error:
      IF (error EQ 1) THEN BEGIN   ; Web access failed OR was unavailable
          free_lun, lun
          code = -1
      ENDIF 
      
  ENDIF else begin
      message, 'wget turned off.', /cont
      version= -1.0
  endelse
  

   return, code
END
