FUNCTION hyd_prod_vers_v01, product_type=name, $
                            dependency_names=names, $
                            dependency_vers=vers
;
;
;  Return:
;
;    Product Version        FLOAT
;    (Negative results indicate an error.)
;
;
;  Input Keywords:
;
;    product_type           STRING (dstatsb variable)
;    dependency_names       STRARR (dstatsb variables)
;    dependency_vers        FLTARR (version numbers)
;
;
;
; Check Input
;
   if strlowcase(!version.os_family) eq 'windows' then begin
       message, 'wget assumed unavailable on Windows platform.', /cont
       return, -1
   endif
   IF NOT keyword_set(name) THEN BEGIN
      message, 'Must specify product_type=name', /continue
      return, -10.0
   ENDIF ELSE BEGIN
      type = 'product_type='+strtrim(name,2)
   ENDELSE 
   IF NOT keyword_set(names) THEN BEGIN
      message, 'Must specify dependency_names.', /continue
      return, -12.0
   ENDIF 
   IF NOT keyword_set(vers) THEN BEGIN
      message, 'Must specify dependency_vers.', /continue
      return, -13.0
   ENDIF 
   IF (n_elements(names) NE n_elements(vers)) THEN BEGIN
      message, 'dependency_names and dependency_vers '+$
       "don't match.", /continue
      return, -14.0
   ENDIF 
   dep_string = string("")
   FOR i=0,n_elements(names)-1 DO BEGIN
      dep_string =  dep_string+strtrim(names(i),2)+'='+strtrim(vers(i),2)
      IF (i NE n_elements(names)-1) THEN dep_string = dep_string+', '
   ENDFOR
;
;
; Get Info from the web
;
   wget = getenv('wget_exe')
   error = 1
   IF (wget ne "") and (wget ne '0') THEN BEGIN 
      address = "http://supras.physics.uiowa.edu/cgi-bin/"+$
       "hydra_versions/hydra_product_version"
      command =  wget+' -T 20 -O - "'+address+'?'+type+'&'+$
       dep_string+'"'
      spawn, command, unit=lun
   
      ON_IOERROR, web_error
      v = string("")
      readf, lun, v
      free_lun, lun
      error = 0
      version =  float(v)
      
web_error:
      IF (error EQ 1) THEN BEGIN   ; Web access failed OR was unavailable
          free_lun, lun
          message, 'Web Access not available.', /continue
          version = -1.0
      ENDIF 
      
  ENDIF else begin
      message, 'wget turned off.', /cont
      version= -1.0
  endelse
  
  return, version
END
