pro hydra_box_data, xin, yin0, xbin_left, dx, $
                    xout, yout_min, yout_max, $
                    max_value=max_value, min_value=min_value
;
;
;    "Box" the data, ie. make a set showing the minimum data values
;    for each bin, and a corresponding maximum set.
;
;
;  Inputs:
;         xin, yin, xbin_left, dx
;
;  Outputs:
;         xout, yout_min, yout_max
;
;
if not keyword_set(max_value) then max_value=1e31
if not keyword_set(min_value) then min_value=-1e31

yin=yin0
nbins=n_elements(xbin_left)
ymin=replicate(-1e31, nbins)
ymax=replicate(-1e31, nbins)
yavg=replicate(-1e31, nbins)

xindex=long(hyd_findex(xbin_left, xin))
r=where(yin gt max_value or yin lt min_value)
if r[0] ne -1 then yin[r]=!values.f_NaN

uindex_end=hyd_uniq(xindex, n=nindex)
uindex_start=[0,uindex_end[0:nindex-2]+1]
if xindex[uindex_start[0]] lt 0 then begin
    uindex_start=uindex_start[1:nindex-1]
    uindex_end=uindex_end[1:nindex-1]
    nindex=nindex-1
endif
if xindex[uindex_start[nindex-1]] lt 0 then begin
    uindex_start=uindex_start[0:nindex-2]
    uindex_end=uindex_end[0:nindex-2]
    nindex=nindex-1
endif

for i=0L,nindex-1 do begin
    ii=xindex[uindex_start[i]]
    yins=[ yin[uindex_start[i]:uindex_end[i]] ]
    ymin[ii]=min(yins, max=ymax0, /NaN)
    ymax[ii]=ymax0
    r=where(finite(yins ) eq 1, nr)
    if nr gt 0 then $
      yavg[ii]=total(yins[r])/float(nr)      
endfor
;
;  Recoded using hyd_uniq above
;
;for i=0,n_elements(xbin_left)-1 do begin
;    r=where(xindex eq i, nr)
;    if r[0] gt 0 then begin
;        ymin[i]=min(yin[r], max=ymax0)
;        ymax[i]=ymax0
;        yavg[i]=total(yin[r])/float(nr)
;    endif
;endfor

r=where(yavg gt -1e30, nbins)

xbin_right=xbin_left+dx
xout=reform(transpose([[xbin_left[r]], [xbin_left[r]], $
                       [xbin_right[r]], [xbin_right[r]]]), 4*nbins)

yout_min=reform(transpose([[yavg[r]], [ymin[r]], [ymin[r]], [yavg[r]]]), 4*nbins)
yout_max=reform(transpose([[yavg[r]], [ymax[r]], [ymax[r]], [yavg[r]]]),4*nbins)

end

