forward_function file_search

function findfile6, filespec, _ref_extra=e_
;
;  Wrapper for findfile - buggy in IDL6.0
;
if !version.release gt '5.4' then begin
    ff=file_search(filespec,_extra=e_)
;    ff=findfile(filespec,_extra=e_)
endif else begin
    ff=findfile(filespec,_extra=e_)
endelse
return, ff
end


function hyd_cdrom_findfile, date_str_in, $
                             survey=survey, $
                             level1=level1, $
                             ddcal=ddcal, $
                             moments_all=moments, $
                             ppal1=ppal1, $
                             version=version, count=count, $
                             no_report_index=no_report_index

;   a special findfile designed to use the hydra l1 cds.

;   /no_report_index means do not report where the file can be found.


    indir= getenv('CDROM')
    index_dir= getenv('HYDRA_CDROM_INDEX')

    if indir eq '' then begin
        message, 'CDROM location not specified.'
        return, ''
    endif

    date_str=strtrim( date_str_in, 2 )
    if strlen(date_str) eq 8 then date_str=strmid(date_str,2,6)

    if !version.os_family eq 'Windows' then begin
        dir_sep='\'             ; '
    endif else begin
        dir_sep='/'
    endelse

    if strmid( indir, strlen(indir)-1, 1 ) ne dir_sep then $
      indir=indir+dir_sep

    if strmid( index_dir, strlen(index_dir)-1, 1 ) ne dir_sep then $
      index_dir=index_dir+dir_sep

    if index_dir eq '' then $
      index_dir= indir+'index' + dir_sep

    case (1) of
        keyword_set(level1): begin
            index='l1.ind'
            file='dd'+date_str+'.cdf'
        end
        keyword_set(survey): begin
            index='sv.ind'
            file='sv'+date_str+'.cdf'
        end
        keyword_set(ddcal): begin
            index='l1cal.ind'
            file='dc'+date_str+'.cdf'
        end
        keyword_set(moments): begin
            index='mom.ind'
            file='me'+date_str+'.cdf'
        end
        keyword_set(ppal1): begin
            index='ppa.ind'
            file='pp'+date_str+'.cdf'
        end
    endcase

    count=0

    tryagain:
    volume=''
    on_ioerror, ioerror
    openr, lun, indir+'label', /get_lun
    volume=''
    readf, lun, volume
    close, lun
    goto, cont1

    ioerror:
;    message, 'CDROM not loaded or read error.', /continue

    cont1:
    on_ioerror, no_index
    openr, lun, index_dir + index, /get_lun
    goto, cont2

    no_index:
    message, 'CDROM index not found.', /continue
    return, ''

    cont2:
    found=0
    s=''
    loc=['dummy']
    ver=[0.00]
    while not eof(lun) do begin
        readf, lun, s
        s= str_sep(s,';') ; remove comments
        s= strtrim(s(0),2)
        if strmid(s,0,12) eq file then begin
            s= (str_sep(s,' '))(1)
            loc= [loc,s]
            n= strpos(s,'sv_v')
            v= float(strmid(s,n+4,5))
            ver= [ver,v]
            found=1
        endif
    endwhile
    close, lun

    if not found then begin
        message, 'date not found in CDROM index.', /cont
        return, ''
    endif

    loc=loc(1:*)
    ver=ver(1:*)
    vollist=['']

    loaded=0
    for i=0,n_elements(loc)-1 do begin
        loc1= str_sep( loc(i),'/' )
        vollist= [vollist,'   '+loc1(0)+'  '+string(ver(i),format='(f5.2)')]
        if volume eq loc1(0) then begin
            loaded=1
            loaded_ver=ver(i)
            loaded_loc=loc1
        endif
    endfor
    vollist=vollist(1:*)

    if n_elements(no_report_index) gt 0 and no_report_index ge max(ver) then $
      return, ''

    if loaded then begin
        if loaded_ver lt max(ver) then begin
            message=[ 'Loaded cdrom does not contain the ', $
                      'best file version avaiable on CDROM.', $
                      'The following cdroms contain versions ', $
                      'more recent than '+$
                      strtrim(string(loaded_ver,form='(f5.2)'),2)+':', '']
            r= where( ver gt loaded_ver )
            message=[message,vollist(r),'']
            message=[message, 'Do you want to load a different volume?', $
                     'Yes, try new volume  ',$
                     'No, continue using this volume' ]
            r= widget_message( message, /question,title='Inferior Volume' )
            if r eq 'Yes' then goto, tryagain
        endif
    endif

    if not loaded then begin
        if volume eq '' then message= 'Hydra cdrom not loaded.' else $
          message= 'File is not on volume '+volume+'.'
        message=[ message, $
                  'Insert one of the following: ', '', $
                  vollist, '', $
                  'Yes, try new volume  ',$
                  'No, abort cdrom search.' ]
        r= widget_message( message, /question, title='Wrong Volume' )
        if r eq 'No' then return, '' $
        else goto, tryagain
    endif

    loc= loaded_loc(1)          ; omit the label part.
    for i=2,n_elements(loaded_loc)-1 do $
      loc= loc + dir_sep + loaded_loc(i)

    ff= indir + loc + dir_sep + file
    r= findfile6( ff, count=count )
    if count eq 0 then begin
        version=0.00
        return,''
    endif else begin
        n= strlen(loc)
        version= float(strmid(loc,n-4,4))
        count=1
        return, indir + loc + dir_sep + file
    endelse
end

pro hydra_findfile_gunzip, zip_source, unzipfile
   if float(!version.release) lt 5.4 then begin
      	cmdline = 'gzip -dc '+zip_source+' > '+unzipfile
      	spawn, cmdline
   endif else begin
        ;; this is untested on a vax, and documentation of compress
        ;; indicates there might be problems with this

        openr, in, /compress, zip_source, /get_lun

        openw, out, unzipfile, /get_lun
        buffsize= 1024
        buffer = bytarr(buffsize)

        on_ioerror, almostDone  ;; causes seg fault on linux if invalid gz
        bytesRead=0L
        while ( 1 ) do begin
            readu, in, buffer
            writeu, out, buffer
        endwhile

        almostDone:
        ;  transfer_count doesn't set the bytes read on ioerror, but
        ;  does read the bytes.  Kludge to get bytesRead by looking
        ;  for last non-zero byte

        r= where( buffer ne 0 )
        if r[0] eq -1 then lastbyte= buffsize-1
        lastByte= r[n_elements(r)-1]

        buff= bytarr( lastByte+1 )
        buff[*]= buffer[0:lastByte]
        writeu, out, buff

        close, in
        free_lun, in
        close, out

        free_lun, out
    endelse
end

function hydra_findfile_decompress, fz
;  decompress the fully-qualified file "fz" and return
;     the new filename.
   message, 'decompressing '+fz, /cont

   n= strlen( fz )
   funz= strmid( fz, 0, n-3 )
   hydra_findfile_gunzip, fz, funz

   f= findfile6( strmid( fz, 0, n-3 ) ) ; look for the file w/o .gz
   return, f(0)
end

function hydra_findfile_gen, file_in, path, $
                             bestdir=bestdir, version=version, $
                             getversion=getversion

;  Look for best file on specified path.
;  Manage autodownloading and cache management.

case !version.os_family of
    'unix': begin
        dir_sep='/'
        path_sep=':'
    end
    'Windows': begin
        dir_sep="\"
        path_sep=";"
    end
    'vms': begin
        dir_sep='/'
        path_sep=':'
    end
    else: begin
        message, 'OS not recognized/supported', /cont
        version= -1.
        return, ''
    end
endcase

bestver=-1. & bestfile='' & bestdir=''
for ifile=0,n_elements(file_in)-1 do begin

    file= file_in[ifile]
;      convert # to ?, and this is where the version number is stored.
    b= byte( file )
    r= where( b eq 35, version_strlen ) ; ascii for #, assume contiguous
    if n_elements(r) gt 1 then if max( r(1:*)-r ) gt 1 then begin
        message, 'file format error.  Pounds (#) not contiguous', /cont
        stop
    endif
    version_strpos= strlen(file) - r(0)
    if r(0) ne -1 then b(r)= 63
    file= string( b )

    paths= str_sep( path, path_sep )

    for i=0,n_elements(paths)-1 do begin
        indir=strtrim(paths(i),2)
        IF strmid(indir,strlen(indir)-1,1) NE dir_sep THEN $
          indir=indir+dir_sep

        ff=findfile6( indir+file, count=count )
        for j=0, count-1 do begin
            n= strlen( ff(j) )
            if version_strlen eq 0 then begin
                vers1=1.0
            endif else begin
                vers1= $
                  float( strmid( ff(j), n - version_strpos, version_strlen ) )
            endelse
            getversion_logical=0
            if n_elements(getversion) eq 1 then begin
                if ( (keyword_set(getversion)) or $
                     (size(getversion, /type) ne 2) ) then begin
                    getversion_logical=1
                endif
            endif

            if getversion_logical eq 1 then begin
                if vers1 eq getversion then begin
                    bestver= vers1
                    bestfile= ff(j)
                    bestdir= indir
                endif
            endif else begin
                if vers1 gt bestver[0] then begin
                    bestver= vers1
                    bestfile= ff(j)
                    bestdir= indir
                endif else if vers1 eq bestver[0] then begin
                    r=where(hyd_basename(bestfile) eq hyd_basename(ff[j]))
                    if r[0] eq -1 then begin
                        message, 'WARNING: found equal-version files.  '+$
                          'Using 1st.', /cont
                        message, '    '+bestfile, /cont
                        message, '    '+ff[j], /cont
                        ;;bestver= [bestver,vers1]
                        ;;bestfile=[bestfile,ff(j)]
                        ;;bestdir= [bestdir,indir]
                    endif
                endif
            endelse
        endfor                  ; unglobbed directories
        ff=findfile6( indir+file+'.gz', count=count )
        for j=0, count-1 do begin
            n= strlen( ff(j) )
            if version_strlen eq 0 then vers1=1.0 else $
              vers1= float( strmid( ff(j), n - ( version_strpos + 3 ), version_strlen ) )
            if vers1 gt bestver[0] then begin
                bestver= vers1
                bestfile= ff(j)
                bestdir= indir
            endif else if vers1 eq bestver[0] then begin
                r=where(bestfile eq ff[j])
                if r[0] eq -1 then begin
                    message, 'WARNING: found equal-version files.  '+$
                      'Using 1st.', /cont
                    message, '    '+bestfile, /cont
                    message, '    '+ff[j], /cont
                    ;;bestver= [bestver,vers1]
                    ;;bestfile=[bestfile,ff(j)]
                    ;;bestdir= [bestdir,indir]
                endif
            endif
        endfor                  ; unglobbed directories
    endfor                      ; path
endfor
; State of things at this point:
;   bestfile, bestdir  contains the name of the best file.
;   bestver            contains the version number of this file, or
;                         -1. if none was found.


;  handle decompression, if necessary.
for ibest=0,n_elements(bestfile)-1 do begin
    n= strlen( bestfile[ibest] )
    if strmid( bestfile[ibest], n-3, 3 ) eq '.gz' then begin
        f= hydra_findfile_decompress( bestfile[ibest] )
        if f eq '' then begin
            message, 'File '+f+' fails decompression.', /cont
            bestver[ibest]= -1.
        endif else begin
            r=where(bestfile eq f)
            if r[0] eq -1 then begin
                bestfile[ibest]= f
            endif else begin
                bestver[ibest]= -1.
            endelse
        endelse
    endif
endfor
rbest=where(bestver gt -1,nrbest)
if nrbest gt 1 then begin
    bestver=bestver[rbest]
    bestfile=bestfile[rbest]
    bestdir=bestdir[rbest]
endif else if nrbest eq 1 then begin
    bestver=bestver[rbest[0]]
    bestfile=bestfile[rbest[0]]
    bestdir=bestdir[rbest[0]]
endif
if bestver[0] gt -1 then version= bestver $
else version=0.

dir= bestdir
return, bestfile

end

function hydra_findfile_genX, date, id, path, $
                             version=version, bestdir=bestdir

;  Look for best file on specified path.
;  Manage autodownloading and cache management.

   case !version.os_family of
       'unix': begin
           dir_sep='/'
           path_sep=':'
       end
       'Windows': begin
           dir_sep="\"
           path_sep=";"
       end
       'vms': begin
           dir_sep='/'
           path_sep=':'
       end
       else: begin
           message, 'OS not recognized/supported', /cont
           version= -1.
           return, ''
       end
   endcase

   datestr= strtrim( date, 2 )
   if strlen( datestr eq 6 ) then datestr= '19'+datestr

   paths= str_sep( path, path_sep )

   bestver=-1. & bestfile='' & bestdir=''
   for i=0,n_elements(paths)-1 do begin
       indir=strtrim(paths(i),2)
       IF strmid(indir,strlen(indir)-1,1) NE dir_sep THEN $
         indir=indir+dir_sep

       ff=findfile6( indir+datestr+'_hyd_'+id+'_v?.??.cdf', count=count )
       if count eq 0 then begin
           ff= findfile6( indir+datestr+'_hyd_'+id+'_v?.??.cdf.gz', $
                         count=count )
       endif

       for j=0, count-1 do begin
           n= strlen( ff(i) )
           if strmid( ff(i), n-3, 3 ) eq '.gz' then begin
               verstr= strmid( ff(i), n-11, 4 )
           endif else begin
               verstr= strmid( ff(i), n-8, 4 )
           endelse

           s= str_sep( verstr, '_' )
           if n_elements(s) gt 1 then begin
               fp= float(s(1)) / 10^(strlen(s(1)))
               vers1= float(s(0)) + fp
           endif else begin
               vers1= float(s(0))
           endelse

           if vers1 gt bestver then begin
               bestver= vers1
               bestfile= ff(j)
               bestdir= indir
           endif
       endfor                   ; unglobbed directories
   endfor                       ; path

; State of things at this point:
;   bestfile, bestdir  contains the name of the best file.
;   bestver            contains the version number of this file, or
;                         -1. if none was found.


;  handle decompression, if necessary.
   n= strlen( bestfile )
   if strmid( bestfile, n-3, 3 ) eq '.gz' then begin
       f= hydra_findfile_decompress( bestfile )
       if f eq '' then begin
           message, 'File '+f+' fails decompression.', /cont
           bestver= -1.
       endif else begin
           bestfile= f
       endelse
   endif

   version= bestver
   dir= bestdir
   return, bestfile

end

function hydra_findfile, date, $
                         CDHF=CDHF, $
                         ppal1=ppal1, $
                         footprint=footprint, $
                         moments_all=moments, $
                         moments_ion=moments_ion, $
                         moments_rc_ele=moments_rc_ele, $
                         moments_rc_ion=moments_rc_ion, $
                         lrkp=lrkp, $
                         hrkp=hrkp, $
                         spp_ions=spp_ions, $
                         kp_extra=kp_extra, kptest=kptest, $
                         tpp_ions=tpp_ions, $
                         hrkptemp=hrkptemp, attitude=attitude, orbit=orbit,$
                         level1=level1, survey=survey, $
                         summary=summary, $
                         ddcal=ddcal, $
                         bf_cache=bf_cache, $
                         hd_cdf=hd_cdf, hd_idlsav=hd_idlsav, $
                         version=version, silent=silent, $
                         path=path_in, directory=dir, $
                         getversion=getversion, $
                         walen=walen, $
                         tpphr_1=tpphr_1, tpphr_2=tpphr_2, $
                         tpphr_3=tpphr_3, tpphr_6=tpphr_6, $
                         tpf_1=tpf_1, tpf_2=tpf_2, $
                         tpf_3=tpf_3, tpf_6=tpf_6, $
                         spf_1=spf_1, spf_2=spf_2, $
                         spf_3=spf_3, spf_6=spf_6, $
                         count=count, $
                         exception=exception
;+
; NAME: hydra_findfile
;
; PURPOSE: find the most appropriate file for given day and product.
;
; CATEGORY: utility
;
; CALLING SEQUENCE: file= hydra_findfile( <date>, <product_keyword> )
;
; INPUTS:
;    <date>   date of product in YYYYMMDD (long or string)
;    <product_keyword>   is one of:
;                         /CDHF, /ppal1, /footprint,
;                         /moments_all, /moments_ion,
;                         /moments_rc_ele, /moments_rc_ion,
;                         /lrkp, /hrkp,
;                         /attitude, /orbit,
;                         /level1, /survey, /ddcal, /bf_cache,
;                         hd_cdf=hyd_acces_id, hd_idlsav=var_name,
;                         /walen,
;                         /tpphr_1, /tpphr_2, /tpphr_3, /tpphr_6
;                         /spf_1, /spf_2, /spf_3, /spf_6
;                         /tpf_1, /tpf_2, /tpf_3, /tpf_6
;
; KEYWORD PARAMETERS:
;    version=v       return the version of the found file.
;    path=p_in       specify search path to use (may not work for all products)
;    getversion=getversion   only return this version.
;    directory=d     return the directory where file was found.
;    /silent         don't print messages
;
; OUTPUTS:
;    returns the name of the best file in a string, or '' if none was found.
;
; OPTIONAL OUTPUTS:
;    returns zero for the version if no file is found.
;    Count Keyword contains number of files found.
;
; EXCEPTIONS:
;    level1_file_not_found, survey_file_not_found
;
; COMMON BLOCKS: none.
;
; RESTRICTIONS: hydra_findfile uses environment variables to define default
;    search paths.  Please look in code for their names.
;
; PROCEDURE: map keyword into filename template and path.  Call general
;    procudure that checks each directory in path for files matching template.
;    Keep track of one with the highest version number, and return
;    this one.
;
; EXAMPLE:
;    f= hydra_findfile( 19960320, /survey, version=v )
;    help, f, v
;
; MODIFICATION HISTORY:
;    written, Jeremy Faden
;-

count=0
date_str= strtrim( date,2 )
if strlen( date_str ) eq 6 then begin
    message, 'six-digit year assumed to be 19xxxxxx', /cont
    date_str= '19'+date_str
endif

exception= hyd_get_exception()

common get_error, get_err_no, get_err_msg ; papco
msghead = '% HYDRA_FINDFILE: '
case 1 of
    keyword_set(cdhf): begin
        if n_elements(getversion) ne 0 then $
          vv=string(getversion,format='(i2.2)') else vv='##'
        file= 'po_k0_hyd_'+date_str+'_v'+vv+'.cdf'
        path= getenv('HYDRA_CDHFKP_DATA_PATH')
    end
    keyword_set(footprint): begin
        file= date_str+'_footprint.cdf'
        path= getenv('HYDRA_FOOTPRINT_DATA_PATH')
    end
    keyword_set(attitude): begin
        file= 'po_at_def_'+date_str+'_v##.cdf'
        path= '/opt/hydra/lz?/'
    end
    keyword_set(orbit): begin
        file= 'po_or_def_'+date_str+'_v##.cdf'
        path= '/opt/hydra/lz?/'
    end
    keyword_set(moments): begin
        path= getenv('HYDRA_MOMENTS_DATA_PATH')
        id='mom'
    end
    keyword_set(walen): begin
        path= getenv('HYDRA_WALEN_DATA_PATH')
        id='walen'
    end
    keyword_set(moments_ion): begin
        path= getenv('HYDRA_MOMENTS_DATA_PATH')
        id='momi'
    end
    keyword_set(moments_rc_ele): begin
        path= getenv('HYDRA_MOMENTS_RC_DATA_PATH')
        id='momrc'
    end
    keyword_set(moments_rc_ion): begin
        path= getenv('HYDRA_MOMENTS_RC_DATA_PATH')
        id='momirc'
    end
    keyword_set(kptest): begin
        path= getenv('HYDRA_KPTEST_DATA_PATH')
        id='kpall'
    end
    keyword_set(tpp_ions) or keyword_set(kp_extra): begin
        get_err_msg = msghead+'tpp_ions and kp_extra keywords obsolete...Use tpphr_1, _2, _3 or _6'
        if not keyword_set(silent) then print, get_err_msg
        return, ''
;          path= getenv('HYDRA_TPPION_DATA_PATH')
;          id= 'extra'
    end
    keyword_set(hrkptemp): begin
        path= '/home/ppq/bigdisk/key_parameters/hr/DDCAL/'
        id= 'hrkp'
    end
    keyword_set(spp_ions): begin
        get_err_msg = msghead+'spp_ions keyword obsolete...New data under construction'
        if not keyword_set(silent) then print, get_err_msg
        return, ''
;          path= getenv('HYDRA_SPPION_DATA_PATH')
;          id= 'sppions'
    end
    keyword_set(ppal1): begin
        path= getenv('HYDRA_PPAL1_DATA_PATH')
        id='ppa'
    end
    keyword_set(level1): begin
        path= getenv('HYDRA_LEVEL1_DATA_PATH')
        id='dd'
    end
    keyword_set(survey) or keyword_set(lrkp): begin
        path= getenv('HYDRA_SURVEY_DATA_PATH')
        id='sv'
    end
    keyword_set(summary): begin
        path='/opt/hydra/summary_data/'
        id='sum'
    end
    keyword_set(ddcal) or keyword_set(hrkp): begin
        path= getenv('HYDRA_DDCAL_DATA_PATH')
        if path eq '' then begin
            message, 'HYDRA_DDCAL_DATA_PATH not set, '+$
              'using HYDRA_LEVEL1_DATA_PATH', /cont
            path= getenv('HYDRA_LEVEL1_DATA_PATH')
        endif
        id='ddcal'
    end
    keyword_set(bf_cache): begin
        path=getenv('HYDRA_BFIELD_CACHE_DATA_PATH')
        id='bf'
        file= [date_str+'_hyd_'+id+'_v##.cdf', $
               date_str+'_hyd_'+id+'_v####.cdf',$
               date_str+'_hyd_'+id+'_v#####.cdf']
    end
    keyword_set(hd_cdf): begin
        path=getenv('HD_DATA_SETS')
        id=hd_cdf
        file= [date_str+'_*'+id+'_v####.cdf', $
               date_str+'_*'+id+'_v#.cdf']
    end
    keyword_set(hd_idlsav): begin
        path=getenv('HD_DATA_SETS')
        id=hd_idlsav
        file= date_str+'_'+id+'.idlsav'
    end
    keyword_set(tpphr_1): begin
        path= getenv('HYDRA_TPPHR_DATA_PATH')
        id='tpphr_1'
    end
    keyword_set(tpphr_2): begin
        path= getenv('HYDRA_TPPHR_DATA_PATH')
        id='tpphr_2'
    end
    keyword_set(tpphr_3): begin
        path= getenv('HYDRA_TPPHR_DATA_PATH')
        id='tpphr_3'
    end
    keyword_set(tpphr_6): begin
        path= getenv('HYDRA_TPPHR_DATA_PATH')
        id='tpphr_6'
    end
    keyword_set(tpf_1): begin
        path= getenv('HYDRA_TPF_DATA_PATH')
        id='tpf_1'
    end
    keyword_set(tpf_2): begin
        path= getenv('HYDRA_TPF_DATA_PATH')
        id='tpf_2'
    end
    keyword_set(tpf_3): begin
        path= getenv('HYDRA_TPF_DATA_PATH')
        id='tpf_3'
    end
    keyword_set(tpf_6): begin
        path= getenv('HYDRA_TPF_DATA_PATH')
        id='tpf_6'
    end
    keyword_set(spf_1): begin
        path= getenv('HYDRA_SPF_DATA_PATH')
        id='spf_1'
    end
    keyword_set(spf_2): begin
        path= getenv('HYDRA_SPF_DATA_PATH')
        id='spf_2'
    end
    keyword_set(spf_3): begin
        path= getenv('HYDRA_SPF_DATA_PATH')
        id='spf_3'
    end
    keyword_set(spf_6): begin
        path= getenv('HYDRA_SPF_DATA_PATH')
        id='spf_6'
    end

endcase

if n_elements( path_in ) ne 0 then path= path_in

if n_elements( file ) eq 0 then begin
    file= [date_str+'_hyd_'+id+'_v#####.cdf', $
           date_str+'_hyd_'+id+'_v####.cdf']
endif

found= hydra_findfile_gen( file, path, $
                           version=version, $
                           bestdir=dir, $
                           getversion=getversion )
;
;  level1 files contain the calibration as well as the
;
if keyword_set( ddcal ) then begin
    file= [date_str+'_hyd_dd_v#####.cdf', $
           date_str+'_hyd_dd_v####.cdf']
    found_dd= hydra_findfile_gen( file, path, $
                                  version=version_dd, $
                                  bestdir=dir_dd, $
                                  getversion=getversion )
    if version_dd gt version then begin
        found= found_dd
        version= version_dd
        dir= dir_dd
    endif
endif
if (keyword_set( orbit ) and found[0] eq '') then begin
    file= 'po_or_pre_'+date_str+'_v##.cdf'

    found= hydra_findfile_gen( file, path, $
                               version=version, $
                               bestdir=dir, $
                               getversion=getversion )
endif
if (keyword_set( attitude ) and found[0] eq '') then begin
    file= 'po_at_pre_'+date_str+'_v##.cdf'

    found= hydra_findfile_gen( file, path, $
                               version=version, $
                               bestdir=dir, $
                               getversion=getversion )
endif

;  if strpos( path, 'CDROM' ) and $
;    keyword_set(level1) or keyword_set(survey) or $
;    keyword_set(ddcal) or keyword_set(moments_all) $
;    then begin
;      ff= hyd_cdrom_findfile( date_str, $
;                              level1= keyword_set(level1), $
;                              ddcal= keyword_set(ddcal), $
;                              survey= keyword_set(survey), $
;                              moments_all= keyword_set(moments_all), $
;                              ppal1= keyword_set(ppal1), $
;                              version=cdrom_version, count=count, $
;                              no_report_index=version )
;      if n_elements( cdrom_version ) eq 0 then cdrom_version=-1
;      if cdrom_version gt version then begin
;          found=ff(0)           ; ff(0) just in case it's an array -- it's not supposed to be.
;          version= cdrom_version
;          best_dir='CDROM'
;      endif
;  endif

;  Let hydra_retreive take a shot at it.  It may be sitting on remote
;  site and we can download it.
if version[0] eq 0.0 then begin
    if keyword_set(level1) or $
      keyword_set(ddcal) or $
      keyword_set(survey) then begin
        x= hydra_retrieve( date_str, $
                           level1= keyword_set(level1), $
                           ddcal= keyword_set(ddcal), $
                           survey= keyword_set(survey) )
        found= hydra_findfile_gen( file, path, $
                                   version=version, $
                                   bestdir=dir, $
                                   getversion=getversion )
    endif
endif

if not keyword_set( silent ) and (!quiet eq 0)then begin
    for i=0,n_elements(found)-1 do begin
        if found[i] ne '' then $
          message, 'Found '+found[i], /cont
    endfor
endif


if found[0] ne '' then begin
    get_err_no=0
    exception= hyd_get_exception(!hyd_exception.all_okay)
endif else begin

    if keyword_set( getversion ) then begin
        replace_position=strpos(file,'.')
        replace_position=replace_position-4
        getversion_polite=string(getversion,format='(F4.2)')
        strput, file, getversion_polite, replace_position
    endif

    if not keyword_set(silent) then begin
        for i=0,n_elements(file)-1 do begin
            for j=0,n_elements(path)-1 do begin
                message, 'No files matching '+file[i]+' found on path: ' + $
                  path[j], /cont
            endfor
        endfor
    endif

    get_err_msg= 'No files matching '+file[0]+' found on path: ' + path[0]


    if keyword_set(survey) then begin
        exception= $
          hyd_throw_exception( (hyd_get_exception()).survey_file_not_found )
    endif else if keyword_set(level1) then begin
        exception= $
          hyd_throw_exception( (hyd_get_exception()).level1_file_not_found )
    endif else if keyword_set(ddcal) then begin
        exception= $
          hyd_throw_exception( (hyd_get_exception()).level1_file_not_found )
    endif
endelse
if found[0] ne '' then count=n_elements(found)

return, found

end
