pro hydra_get_device_space, xll, yll, xsize, ysize
; returns the device coordinate frame based on !p.position.
; xll is the lower-left coordinate of !p.position(0) (or x) in pixels,
; yll is the ll of y in pixels
; xsize is the number of pixels across the plot space
; ysize is the number of pixels up and down the plot space.
; 
; an example call:
;   !p.position=[0.1,0.1,0.9,0.9]     ; PAPCO sets !p.position for you
;                                     ; this is just for illustration
;   hydra_get_device_space, xll, yll, xsize, ysize
;   tv, congrid( dist(300), xsize, ysize ), xll, yll
;   plot, [0,1], [0,1], /nodata, /noerase


; calculate the average number of measurements per pixel
  if total(!p.position) eq 0. then begin
      NormalXY0=[0,0]
      NormalXY1=[1,1]
  endif else begin
      NormalXY0 = [!p.position(0), !p.position(1)]  
      NormalXY1 = [!p.position(2), !p.position(3)]  
  endelse
  DeviceXY0 = round(convert_coord(NormalXY0, /NORMAL, /TO_DEVICE))
  DeviceXY1 = round(convert_coord(NormalXY1, /NORMAL, /TO_DEVICE))
  xsize = DeviceXY1(0)-DeviceXY0(0) ; width of the plot-rectangle
  ysize = DeviceXY1(1)-DeviceXY0(1) ; its height
  xll= DeviceXY0(0) 
  yll= DeviceXY0(1)
  
  return
end
