pro hydra_message_event, event
   widget_control, event.top, get_uvalue=widgetData
   t= tag_names( event, /structure_name )
   if t eq 'WIDGET_TIMER' then begin
       if widgetData.xmanager eq 1 then begin
           widget_control, event.top, /destroy
           return
       endif else begin
           widgetData.xmanager=1
           if widgetData.timeout gt 0. then $
             widget_control, event.top, timer= widgetData.timeout
           widget_control, widgetData.button_base, sensitive=1
       endelse
   endif   
   if t eq 'WIDGET_BUTTON' then begin
       widget_control, event.id, get_uvalue=uval
       case strlowcase(uval) of
           'dismiss': begin
               widget_control, event.top, /destroy
               return
           end
           else: message, 'internal error: not recognized.', /cont
       endcase
   endif
   widget_control, event.top, set_uvalue=widgetData
end
   
function hydra_message, message, _extra=e, $
                        timeout=timeout, $
                        info=info, warning=warn, alert=alert, $
                        all_clear=all_clear, dialog_parent=parent, $
                        xoffset=xoffset, yoffset=yoffset


   interactive= (!d.name eq 'X' or !d.name eq 'WIN' )
   if not interactive then begin
       for i=0,n_elements(message)-1 do $
         message, /cont, message(i)
       return, 'non-interactive'
   endif

   wold= !d.window

   if n_elements( title ) eq 0 then title='Message'
   if n_elements( timeout ) eq 0 then timeout=0.
   if n_elements( parent ) ne 0 then begin
       w= widget_info( parent, /geo )
       if n_elements( xoffset ) eq 0 then xoffset= w.xoffset
       if n_elements( yoffset ) eq 0 then yoffset= w.yoffset
   endif
   if n_elements( xoffset ) eq 0 then xoffset=300
   if n_elements( yoffset ) eq 0 then yoffset=300   

   color='grey'
   if keyword_set(info) then color='blue'
   if keyword_set(all_clear) then color='green'
   if keyword_set(warn) then color='yellow'
   if keyword_set(alert) then color='red'
   icolor= get_color_index( color, close=close )
   if close gt 0.7 then icolor=-1 ; dstat gets 0.64 or so with its colors.
   
   b= widget_base( /row, xoffset=xoffset, yoffset=yoffset, _extra=e )
   
   if icolor ne -1 then draw= widget_draw( b, xsize=40, ysize=40 )

   b1= widget_base( b, /column )

   mb= widget_base( b1, /column )
   for i=0,n_elements( message )-1>5 do begin
       if i lt n_elements(message) then $
         l= widget_label( mb, value=message(i) ) else $
         l= widget_label( mb, value='' )
   endfor

   bb= widget_base( b1, /row )
   bye= widget_button( bb, value='Dismiss', uvalue='Dismiss' )
   widget_control, bb, sensitive=0

   widget_control, b, /real

   if icolor ne -1 then begin
       widget_control, draw, get_value=winidx   
       wset, winidx
       erase, icolor
       if wold ge 0 then wset, wold
   endif else begin
       winidx=0L
   end

   widget_control, b, timer=0.01 ; we want to know when xmanager is responsive

   widgetData= { timeout:timeout, $
                 winidx:winidx, $
                 xmanager:0, $
                 button_base:bb $
               }
   
   widget_control, b, set_uvalue= widgetData

   xmanager, 'hydra_message', b, /just_reg
   return, 'Nowait'            
end
   
