function hydra_net_findfile, date_str_in, version=version, $
                             survey=survey, $
                             level1=level1, $
                             ddcal=ddcal
                             
;  reads network index file and returns the name of the 
;  best product available.

   prod_code= keyword_set(survey)*1+keyword_set(level1)*2+$
     keyword_set(ddcal)*3
   survey= 1
   level1= 2
   ddcal=  3

   date_str= strtrim( date_str_in, 2 )
   if strlen( date_str ) eq 6 then date_str='19'+date_str

   wget_exe= getenv('wget_exe')
   if wget_exe eq '' then begin
       message, 'wget_exe environment variable not set', /cont
       version=0.
       return, ''
   endif
   if wget_exe eq '0' then begin
       message, 'wget turned off via wget_exe=0', /cont
       version=0.
       return, ''
   endif
   ftp_site= getenv( 'HYDRA_FTP_ARCHIVE' )
   if ftp_site eq '' then begin
       message, 'HYDRA_FTP_ARCHIVE environment variable not set', /cont
       version=0
       return, ''
   endif   
   
   n= strlen( ftp_site )
   if strmid( ftp_site, n-1, 1 ) ne '/' then ftp_site=ftp_site+'/'

   index_remote= ftp_site+'net_index_00'

   exe_str= wget_exe+' -T20 -q -O - '+index_remote
   message, 'reading index file...', /cont
   spawn, exe_str, lun
   
   case prod_code of 
       survey: prod_str= 'sv'
       level1: prod_str= 'dd'
       ddcal:  prod_str= 'ddcal'
       else: begin
           message, 'unrecognized file type.'
           return, ''
       end
   end

   bestfile=''
   bestver=0.0
   s=''
   for i=0, n_elements( lun )-1 do begin
       s=lun(i)
       parse= str_sep( s, ' ' )
       if parse(0) eq date_str then begin
           if parse(1) eq prod_str then begin
               ver= parse(2)
               if ver gt bestver then begin
                   bestver=ver
                   bestfile= parse(3)
               endif
           endif
       endif
   endfor
   
   if bestver gt 0.0 then begin
       version= bestver
       return, ftp_site+bestfile
   endif else begin
       message, 'file not found in index.', /cont
       version=0.0
       return, ''
   endelse

end

