pro testit, print=print
  if keyword_set(print) then begin
      set_plot, 'ps'
  endif
  x= randomn(s,1000000)
  y= randomn(s,1000000)
  hydra_pointdensityplot, x, y
  hydra_pointdensityplot, x, y, /independent_columns
  if keyword_set(print) then begin
      device, /close
      set_plot, 'x'
  endif
end
  
pro hydra_pointdensityplot, x_in, y_in, _extra=e, hit_min=hit_min, $
  independent_columns=independent_columns

  check_plotparms, _extra=e

  loadct, 0

  print= !d.name eq 'PS'

  if n_elements( y_in ) eq 0 then begin
      y= x_in
      x= findgen(n_elements(y))
  endif else begin
      x= x_in
      y= y_in
  endelse

  if n_elements( hit_min ) gt 0 then begin
      if hit_min gt 1.0 then $
        message, 'hit_min must be between 0. and 1.'
  endif else begin
      hit_min= 0.2
  endelse

  plot, x, y, _extra=e, /nodata
  !p.multi=!p.multi+[1,0,0,0,0]

  xdata=!x.crange & ydata=!y.crange ; ranges in data space
  xcrange= !x.crange
  ycrange= !y.crange
  xlog=!x.type & ylog=!y.type
  if (xlog) then begin
      xcrange=10^xdata
      x= alog10(x)
  endif
  if (ylog) then begin
      ycrange=10^ydata
      y= alog10(y)
  endif
  ll=fix(convert_coord(xcrange(0),ycrange(0),/data,/to_device))
  ur=fix(convert_coord(xcrange(1),ycrange(1),/data,/to_device))

  if !d.name eq 'PS' then begin
      sizedev=((ur-ll)(0:1))/35 ; 72 dpi
      dfactor=1./35               ; device factor
  endif else begin
      sizedev=((ur-ll)(0:1))
      dfactor=1.
  endelse      
  
  nx= sizedev[0]
  ny= sizedev[1]
  hmat= make_array( nx, ny, value=0, /float )
  
  ix= ( x-xdata[0] ) / ( xdata[1]-xdata[0] ) * nx 
  iy= ( y-ydata[0] ) / ( ydata[1]-ydata[0] ) * ny
  onh= ( ix ge 0 and ix < nx $
         and iy ge 0 and iy < ny )
  ix= ix > 0 < ( nx-1 )
  iy= iy > 0 < ( ny-1 )

  for i=0L,n_elements(x)-1 do begin            
      hmat[ix[i],iy[i]]= hmat[ix[i],iy[i]]+1
  endfor

  if keyword_set( independent_columns ) then begin
      s= size(hmat)
      hmax= make_array( size=size(hmat) )
      for icol=0,s[1]-1 do begin
          col= hmat[icol,*]
          r= where( col gt 0 )
          if r[0] eq -1 then begin
              hmax[icol,*]= 1.0
          endif else begin
              s= sort(col[r])
              hmax[icol,*]= col(r[s[n_elements(s)*0.95]])
          endelse
      endfor
      
  endif else begin
      r= where( hmat gt 0 )
      s= sort(hmat[r])
      hmax= hmat(r[s[n_elements(s)*0.95]])

  endelse      
  
  narr= hmat / hmax

  if n_elements( hit_min ) gt 0 then begin
      r= where( narr gt 0. )
      if r[0] ne -1 then begin
          narr(r)= narr(r) > hit_min 
      endif
  endif

; apply corrections for printing
  if print then begin 
      narr= narr ^ ( 1/4.)
  endif
  
  if print then begin
      narr= ( 1 - narr )
  endif   
 
  arr= bytscl( narr, top=!d.table_size-1,max=1.)

  if print then begin
      ll=convert_coord(xcrange[0],ycrange(0),$
                       /data, /to_normal)
      ur=convert_coord(xcrange[1],ycrange(1),$
                       /data, /to_normal)      
      tv, arr, ll(0), ll(1), /normal, $
        xsize= ur(0)-ll(0), ysize=ur(1)-ll(1)
  endif else begin
      tv, congrid(arr, $
                  ur(0)-ll(0)-1, ur(1)-ll(1)-1), $
        ll(0), ll(1), /device
  endelse

  plot, x, y, /nodata, _extra=e, /noerase
  !p.multi=!p.multi-[1,0,0,0,0]

  hydra_setcolors

end

