function parse_unix_date, date
;  returns the date/time in array [ year, month, day, hour, minute, sec ]
;   dates are in date format unix uses with ls -l:
;     mmm dd yyyy   or  mmm dd hh:mm
;   if second format is input, then year is based relative to today.

  s= str_sep( strcompress(date), ' ' )

  second= 0
  
  month_str= s(0)
  monthnames=['jan','feb','mar','apr','may','jun',$
              'jul','aug','sep','oct','nov','dec']
  r= where( strlowcase(month_str) eq monthnames,count )
  if count eq 0 then begin
      message, 'error in month name'
  endif else begin
      month=r(0)+1
  endelse
  day=fix(s(1))
  if strpos( s(2), ':' ) eq -1 then begin
      year=fix(s(2))
      hour=0
      minute=0
  endif else begin
      now= bin_date( ( systime(0) ) )
      year_now= now(0)
      month_now= now(1)
      day_now= now(2)
      if month gt month_now then year= year_now-1 else year=year_now
      s2= str_sep( s(2), ':' )
      hour= fix(s2(0))
      minute=fix(s2(1))
  endelse

  monthnames=[ 'jan','feb','mar','apr','may','jun',$
               'jul','aug','sep','oct','nov','dec' ]
  r= where( strlowcase(month)  eq monthnames )


  std_string= string( year,month,day,hour,minute,second, $
                      format="(i4.4,i2.2,i2.2,' ',i2.2,':',i2.2,':',i2.2)" )

  return, gen_time( std_string )

end
