function quick_interpol, V, X, U

; Performs vectorized interpolation on regularly gridded data.
; written 2-3-97 Jeremy Faden

; make certain that X is regular.
n= n_elements(X)
M= (X(n-1)-X(0)) / ( n-1 )
B= X(0)

X1= M * lindgen(n) + B
res= max( ( ( X1 - X )^2 ) / n )

if res gt (X(1)-X(0))/100 then begin    
    message, 'X is not regular.', /cont
    help, /traceback
    return, interpol( V, X, U )
endif

; okay, so we have a function that gives time from index.  We
; need to invert this function.

B= - B/M
M= 1/M

; Here are the new indeces.
i1= floor( U * M + B )
i2= i1+1

; Any "off the page"?  allow extrapolation.
r= where( i1 lt 0 )
if r(0) ne -1 then begin
    i1(r)=0 
    i2(r)=1
endif
r= where( i2 ge n )
if r(0) ne -1 then begin
    i1(r)= n-2
    i2(r)= n-1
endif

; Now do the interpolation
return, V(i1) + ( U - X(i1) ) * ( V(i2) - V(i1) ) / ( X(i2) - X(i1) )

end

