pro read_ddeis_background, date, time, delta, background, time_out

   f= hydra_findfile( date, /survey )

   if f eq '' then begin
       print, 'survey file not found.'       
       return
   endif

   cdf= cdf_open( f )
   
   cdf_varget, cdf, 'TIME', rec_start=0, rec_count=6272, rectim
   rectim= reform( rectim )

   rrec= where( rectim/3600. ge time and $
                rectim/3600. le time+delta )
   
   rec_start= rrec(0)
   rec_count= rrec(n_elements(rrec)-1) - rrec(0) + 1


   cdf_varget, cdf, 'BACK_ELE', rec_start=rec_start, rec_count=rec_count, $
     iback
   iback= reform( iback )
   cdf_close, cdf

   background= 10^ (iback/1000.)
   
   time_out= rectim(rec_start:(rec_start+rec_count-1))

   return
end    
