pro spectra_l1_1x2x_energy_align, counts1, datamask, $ ; input
                                  initialize=init, $
                                  energy_index=energy_index, $
                                  energy_seq=energy_seq
  
  init= keyword_set(init)

  common spectra_l1_1x2x_energy_align_common, $
    intdata

  if init then begin
      
      intdata= { energy_interp:fltarr(32), $
                 energy_orig:fltarr(32), $
                 ff:fltarr(32), $
                 idx384:intarr(32) } ; findex indeces used for interpolation
            
      intdata= replicate( intdata, 2, 2 ) ; 2sweeps (1x,2x), 2boxes
      
      for ibox=0,1 do begin
          for isw= 0,1 do begin
              for idir=0,1 do begin
                  r384= indgen(16) + idir*16 + isw*192
                  r32= indgen(16) + idir*16
                  intdata(ibox,isw).energy_interp(r32)= $
                    alog10(-energy_seq(r384+64,ibox)) ; get energies from 
                                                      ; 2nd sweep
                  intdata(ibox,isw).energy_orig(r32)= $
                    alog10(-energy_seq(r384,ibox))
                  intdata(ibox,isw).ff(r32)= $
                    hyd_findex( intdata(ibox,isw).energy_orig(r32), $
                                intdata(ibox,isw).energy_interp(r32) ) + $
                    idir*16 + isw*192
                  intdata(ibox,isw).idx384(r32)= r384
                  energy_seq(r384,ibox)= energy_seq(r384+64,ibox)
                  
              endfor
          endfor
      endfor
      spectra_l1_recalc_energy_index, energy_index, energy_seq

  endif else begin
      
      for idet=0,11 do begin
          for isw=0,1 do begin
              
              ibox= idet mod 2
              
              counts1( intdata(ibox,isw).idx384, idet )= $
                interpolate( counts1( *, idet ), intdata(ibox,isw).ff )

              datamask(  intdata(ibox,isw).idx384, idet )= $
                datamask( floor(intdata(ibox,isw).ff), idet ) * $
                datamask( ceil(intdata(ibox,isw).ff), idet )
              
          endfor
      endfor

  endelse

end
  


