pro spectra_l1_average, counts1, datamask, subblocks, $ ; input
                        sigma_counts= d_counts1_in, $ ; input
                        initialize=init, $ ; initialize mode
                        energy_index=energy_index, energy_seq=energy_seq, $
                        split=split_in, $ ; in 
                        time_offset=time_offset, $ ; in
                        intdata= intdata_out, $ ; out from init mode
                        spec_out, sigma_spec_out=sigma_out ; output

time_offset= findgen(384)
    common spectra_l1_average_common, $
      idx24odd, idx24even, $
      idx384odd, idx384even, $
      S24odd, N24odd, dS24odd, $ ; I put these in common blocks so they are 
      S24even, N24even, dS24even, $ ; not allocated each invokation
      S1, N1, dS1, $
      Sint, Nint, dSint, $
      intdata, nsum, $
      split, nen
    
    rfill= 1e-20

    if keyword_set(init) then begin
        
        nen= max( abs( energy_index(*,0 ) ) ) * 2 + 1
        nspec= nen/2
        rele= indgen(nspec)
        rion= indgen(nspec)+nspec+1
        
        intdata= { $
                   energy_interp:fltarr(nen), $
                   energy_box:fltarr(nen,2), $
                   rele:rele, $
                   rion:rion, $
                   i1:intarr(nen,2), $ ; indeces used for interpolation
                   i2:intarr(nen,2), $
                   ii1:intarr(nen,2), $ ; fall-back indeces (further away)
                   ii2:intarr(nen,2), $
                   iii1:intarr(nen,2), $
                   iii2:intarr(nen,2), $
                   time_offset:fltarr(nen,2) $ 
                 }
        
        rval= where( energy_index(*,0) ne 0 )
        min0=min( abs( energy_seq(rval,0) ), max=max0 )
        min1=min( abs( energy_seq(rval,1) ), max=max1 )
        mine= alog10(max([min0,min1]))
        maxe= alog10(min([max0,max1]))
        
        intdata.energy_interp( rele ) = $
          mine + ( 1. - findgen(nspec)/(nspec-1) ) * ( maxe-mine )
        intdata.energy_interp( rion ) = $
          mine + findgen(nspec)/(nspec-1) * ( maxe-mine )

        split= keyword_set( split_in )

        if not split then begin
            for ibox=0,1 do begin

                r= where( energy_index(*,0) ne 0 )
                intdata.energy_box( energy_index(r,0)+nspec, ibox ) = $
                  alog10(abs(energy_seq(r,ibox)))
                
                re= interpol( rele, intdata.energy_box(rele,ibox), $
                              intdata.energy_interp(rele) )
                ri= interpol( rion, intdata.energy_box(rion,ibox), $
                              intdata.energy_interp(rion) )
           
                r= [ re, 0, ri ]

                rd= r-1 > 0
                ru= r+1 < (nen-1)

                intdata.i1(*,ibox)= floor( r )
                intdata.i2(*,ibox)= intdata.i1(*,ibox) + 1
                intdata.ii1(rele,ibox)= ( intdata.i1(rele,ibox) - 1 ) > 0
                intdata.ii1(rion,ibox)= ( intdata.i1(rele,ibox) - 1 ) > nspec+1
                intdata.ii2(rele,ibox)= ( intdata.i2(rion,ibox) + 1 ) < ( nspec-1 )
                intdata.ii2(rion,ibox)= ( intdata.i2(rion,ibox) + 1 ) < ( nen-1 )
                intdata.iii1(rele,ibox)= ( intdata.ii1(rele,ibox) - 1 ) > 0
                intdata.iii1(rion,ibox)= ( intdata.ii1(rele,ibox) - 1 ) > nspec+1
                intdata.iii2(rele,ibox)= ( intdata.ii2(rion,ibox) + 1 ) < ( nspec-1 )
                intdata.iii2(rion,ibox)= ( intdata.ii2(rion,ibox) + 1 ) < ( nen-1 )

                rsub= indgen(64)
                time_offset_energy= fltarr(nen,2)
                time_offset_energy( energy_index(rsub,0)+nspec,0 ) = $
                  time_offset(rsub)
                time_offset_energy( energy_index(rsub,1)+nspec,1 ) = $
                  time_offset(rsub)        
            endfor 
            intdata= [ intdata, intdata ]

        endif else begin
            intdata= [ intdata, intdata ] ; for 1x2x mode, two intdata 
            intdata(*).energy_box(*)= 0.0
            
            for ihalf=0,1 do begin
                rsub= indgen( 384/2 ) + ihalf*(384/2)
                for ibox=0,1 do begin
                    intdata(ihalf). $
                      energy_box( energy_index(rsub,ibox)+nspec,ibox ) = $
                      alog10(abs(energy_seq(rsub,ibox)))
                    
                    rv= where( intdata(ihalf).energy_box( rele, ibox ) ne 0.0, c)
                    r= interpol( indgen(c), $
                                 intdata(ihalf).energy_box(rele(rv), ibox),$
                                 intdata(ihalf).energy_interp(rele) )
                    
                    intdata(ihalf).i1(rele,ibox)= rele( rv( floor( r ) ) )
                    intdata(ihalf).i2(rele,ibox)= rele( rv( floor( r )+1 ) )
                    intdata(ihalf).ii1(rele,ibox)= rele( rv( floor( (r-1)>0 ) ) )
                    intdata(ihalf).ii2(rele,ibox)= rele( rv( floor( (r+1)<(c-1) )+1 ) )
                    intdata(ihalf).iii1(rele,ibox)= rele( rv( floor( (r-2)>0 ) ) )
                    intdata(ihalf).iii2(rele,ibox)= rele( rv( floor( (r+2)<(c-1) )+1 ) )

                    rv= where( intdata(ihalf).energy_box( rion,ibox ) ne 0.0, c)
                    
                    r= interpol( indgen(c), $
                                 intdata(ihalf).energy_box(rion(rv),ibox), $
                                 intdata(ihalf).energy_interp(rion) )
                    
                    intdata(ihalf).i1(rion,ibox)= rion( rv( floor( r ) ) )
                    intdata(ihalf).i2(rion,ibox)= rion( rv( floor( r )+1 ) )
                    intdata(ihalf).ii1(rion,ibox)= rion( rv( floor( (r-1)>0 ) ) )
                    intdata(ihalf).ii2(rion,ibox)= rion( rv( floor( (r+1)<(c-1) )+1 ))
                    intdata(ihalf).iii1(rion,ibox)= rion( rv( floor( (r-2)>0 ) ) )
                    intdata(ihalf).iii2(rion,ibox)= rion( rv( floor( (r+2)<(c-1) )+1 ))
                    intdata(ihalf).i1(nspec,ibox)= nspec
                    intdata(ihalf).i2(nspec,ibox)= nspec
                    intdata(ihalf).ii1(nspec,ibox)= nspec
                    intdata(ihalf).ii2(nspec,ibox)= nspec
                    intdata(ihalf).iii1(nspec,ibox)= nspec
                    intdata(ihalf).iii2(nspec,ibox)= nspec
                    
;                    rsub= indgen(64)
;                    time_offset_energy= fltarr(nen,2)
;                    time_offset_energy( energy_index(rsub,0)+nspec,0 ) = $
;                      time_offset(rsub)
;                    time_offset_energy( energy_index(rsub,1)+nspec,1 ) = $
;                      time_offset(rsub) 
                endfor          ; ibox
            endfor              ; ihalf

        endelse
                  
        intdata_out= intdata

;      calculate counts(12,384) array to sub24(nen,12*24) array
;       Sept 16, 97 indeces changed to average boxes separately
;       Sept 17, 97 spectra_average made into routine from inline code.
        
        isub= rebin( indgen(24), 384 )
        ist= indgen(384)
        
        idet= rebin( indgen(12), 4608 )
        isub= [ isub, isub, isub, isub, isub, isub, $
                isub, isub, isub, isub, isub, isub ]
        ist= [ ist, ist, ist, ist, ist, ist, $
               ist, ist, ist, ist, ist, ist ]
        
        ien0= energy_index(*,0)+nspec
        ien1= energy_index(*,1)+nspec
        ien= [ ien0, ien1, ien0, ien1, ien0, ien1, $
               ien0, ien1, ien0, ien1, ien0, ien1 ]
        
        idx24= ien+ idet*nen + isub*12*nen ; indexes ( subblock, det, energy ) 
        idx384= ist + idet*384  ; indexes counts(384,12)
        
        evendet= where( idet mod 2 )
        odddet= where( (idet+1) mod 2 )
        
        idx24odd= idx24( odddet ) ; indexes ( subblock, det, energy ) array
        idx384odd= idx384( odddet ) ; indexes count array
        
        idx24even= idx24( evendet )
        idx384even= idx384( evendet )
        
;      define blank sub24 arrays
        
        S24odd= fltarr( nen, 288 ) ; 288 = 12 det * 24 subblocks
        N24odd= intarr( nen, 288 )
        S24even= fltarr( nen, 288 )
        N24even= intarr( nen, 288 )

        dS24odd= fltarr( nen, 288 ) ; for sigmas
        dS24even= fltarr( nen, 288 )
        
        S1= fltarr( nen, 2 )
        N1= intarr( nen, 2 )
        dS1= fltarr( nen, 2 )

        Sint= fltarr( nen,2 )
        Nint= fltarr( nen,2 )
        dSint= fltarr( nen,2 )

;        plot_state, /reset
;        plot, [0,10], [0,100], /nodata
        return
    endif

    nsum= 24/subblocks * 12     ; 12 detectors per subblock

    sigmas= n_elements( d_counts1_in ) gt 0
    if sigmas then begin
        d_counts2= d_counts1_in ^ 2.0
        sigma_out= fltarr( nen, subblocks )
    endif

;  sort to energy-ordered array (
    m= datamask( idx384odd )
    S24odd(idx24odd)= counts1( idx384odd ) * m
    N24odd(idx24odd)= m
    if sigmas then dS24odd(idx24odd)= d_counts2( idx384odd ) * m

    m= datamask( idx384even )
    S24even(idx24even)= counts1( idx384even ) * m
    N24even(idx24even)= m
    if sigmas then dS24even(idx24even)= d_counts2( idx384even ) * m
    
    spec_out= fltarr( nen, subblocks )
    
    for iisub= 0, subblocks-1 do begin
        rnsum= indgen(nsum) + iisub*(nsum)
        S1(*,0)= total( S24odd(*,rnsum), 2 )
        N1(*,0)= total( N24odd(*,rnsum), 2 )
        S1(*,1)= total( S24even(*,rnsum), 2 )
        N1(*,1)= total( N24even(*,rnsum), 2 )               
        if sigmas then begin
            dS1(*,0)= total( dS24odd(*,rnsum), 2 )
            dS1(*,1)= total( dS24even(*,rnsum), 2 )
        endif
        
        r= where( N1 gt 0 )
        if r(0) ne -1 then begin
            S1(r)= S1(r)/N1(r)
            if sigmas then dS1(r)= dS1(r) / N1(r)^2.
        endif

;      bring the boxes together
;      interpolate each box to common grid.           
        ihalf= fix( (iisub+0.5) / subblocks + 0.5 ) ; which half of the block

        for ibox=0,1 do begin

            i1= intdata(ihalf).i1(*,ibox)
            i2= intdata(ihalf).i2(*,ibox)

            rnv= where( N1(i1,ibox) eq 0 ) ; check for no data points
            if rnv(0) ne -1 then begin
;                print, n_elements(rnv), ihalf
;                oplot, [randomu(s)+ihalf*4+1], [n_elements(rnv)+randomu(s)], psym=3
                i1(rnv)= intdata(ihalf).ii1(rnv,ibox)
                rnv= where( N1(i1,ibox) eq 0 )
;                oplot, [randomu(s)+ihalf*4+2.1], [n_elements(rnv)+randomu(s)], psym=3
                if rnv(0) ne -1 then i1(rnv)= intdata(ihalf).iii1(rnv,ibox)
            endif
            rnv= where( N1(i2,ibox) eq 0 )
            if rnv(0) ne -1 then begin
;                print, n_elements(rnv), ihalf
;                oplot, [randomu(s)+ihalf*4+1], [n_elements(rnv)], psym=3
                i2(rnv)= intdata(ihalf).ii2(rnv,ibox)
                rnv= where( N1(i2,ibox) eq 0 )
;                oplot, [randomu(s)+ihalf*4+2.1], [n_elements(rnv)], psym=3
                if rnv(0) ne -1 then i2(rnv)= intdata(ihalf).iii2(rnv,ibox)
            endif

;            rele= intdata(ihalf).rele
;            rion= intdata(ihalf).rion
            
;            i1= intarr(n_elements(intdata(ihalf).energy_box(*,ibox)))
;            i2= intarr(n_elements(intdata(ihalf).energy_box(*,ibox)))

;            rv= where( intdata(ihalf).energy_box(rele,ibox) ne 0.0 $
;                       and N1(rele,ibox) gt 0., c )
;            if c eq 0 then begin
;                i1(rion)=rion(0)
;                i2(rion)=rion(0)
;            endif else begin
;                r= interpol( indgen(c), $
;                             intdata(ihalf).energy_box(rele(rv), ibox), $
;                             intdata(ihalf).energy_interp(rele) )
;                i1(rele)= rele( rv( floor( r ) ) )
;                i2(rele)= rele( rv( floor( r ) + 1 ) )   
;            endelse

;            rv= where( intdata(ihalf).energy_box( rion,ibox ) ne 0.0 $
;                       and N1(rion,ibox) gt 0., c)

;            if c eq 0 then begin
;                i1(rion)=rion(0)
;                i2(rion)=rion(0)
;            endif else begin
;                r= interpol( indgen(c), $
;                             intdata(ihalf).energy_box(rion(rv),ibox), $
;                             intdata(ihalf).energy_interp(rion) ) 
;                i1(rion)= rion( rv( floor( r ) ) )
;                i2(rion)= rion( rv( floor( r ) ) )
;            endelse

;            r= where( abs(i2-indgen(111)) gt 6 )
;            if r(0) ne -1 then begin
;                help, r
;                i1(r)=55
;                i2(r)=55
;            endif

            den= intdata(ihalf).energy_box(i2,ibox) - $
              intdata(ihalf).energy_box(i1,ibox)

            r1= where( den ne 0 )
            r0= where( den eq 0 )

            a1= make_array( size= size( den ))
            a2= make_array( size= size( den ))
            
            if r1(0) ne -1 then begin
                a2(r1)= ( intdata(ihalf).energy_interp(r1) - $
                          intdata(ihalf).energy_box(i1(r1),ibox) ) / den(r1)
                a1(r1)= ( intdata(ihalf).energy_box(i2(r1),ibox) - $
                          intdata(ihalf).energy_interp(r1) ) / den(r1)
            endif

            if r0(0) ne -1 then begin ; same point....
                a1(r0)= 1.0
                a2(r0)= 0.0
;  better to rename one of the indeces I think...
            endif

;            r= check_math(1)
;            if r ne 0 then print, 'check_math()='+strtrim(r,2)

            Sint(*,ibox)= S1( i1,ibox ) * a1 + S1( i2,ibox ) * a2
            Nint(*,ibox)= N1( i1,ibox ) * a1 + N1( i2,ibox ) * a2

            if sigmas then dSint(*,ibox)= $
              dS1( i1,ibox ) * a1^2 +  dS1( i2,ibox ) * a2^2
        endfor

        rn= where( Nint(*) lt 1.0 )
        if rn(0) ne -1 then Nint(rn)= 0.0 ; <1.0 indicates one bracket was nv
        
        r= where( Nint(*,0) ge 1.0 or Nint(*,1) ge 1.0 ) 
        rn= where( Nint(*,0) eq 0.0 and Nint(*,1) eq 0.0 )
        if r(0) ne -1 then begin
            if sigmas then begin
                alph1= Nint(r,0) / (Nint(r,0)+Nint(r,1))
                alph2= Nint(r,1) / (Nint(r,0)+Nint(r,1))
                spec_out(r,iisub)= $
                  Sint(r,0)*alph1 + Sint(r,1)*alph2
                sigma_out(r,iisub)= $
                  dSint(r,0)*alph1^2 + dSint(r,1)*alph2^2
            endif else begin
                spec_out(r,iisub)= $
                  ( (Sint(r,0)*Nint(r,0)) + (Sint(r,1)*Nint(r,1)) ) / $
                  (Nint(r,0)+Nint(r,1))
            endelse
        endif
        if rn(0) ne -1 then begin
            spec_out(rn,iisub)= rfill
            if sigmas then sigma_out(rn,iisub)= rfill        
        endif
    endfor                      ; iisub           
    
    return
end
