function spectra_l1_correct, raw, recstart, sigma_cc=sigma_cc, $
                             init=init, rawid=CDF, calid=CAL, $
                             mode=mode, ele_bias=ele_bias, ion_bias=ion_bias
                             

;  Correct raw counts for dead-time, background and gains

  rgains_quality=0

  common spectra_l1_correct_common, calibration, rele, rion, correct
  
  if keyword_set(init) then begin
      
      calibration= { calibration_str, $
                     CDF:long(-1), $
                     CAL:long(-1), $
                     mode:-1, $
                     energy_index:intarr(384,2), $
                     ele_bias:[-1,-1], $
                     ion_bias:[-1,-1], $
                     gain_factor:fltarr(384,12), $
                     back_ele:fltarr(12,6272), $
                     back_ion:fltarr(12,6272), $
                     dead_time:fltarr(12), $
                     delta_time:0., $
                     calc_sigma_cc:0 $
                   }
      
      calibration.mode=mode 
      calibration.ele_bias=ele_bias
      calibration.ion_bias=ion_bias
      
      hyd_cdf_varget, CAL, 'CAL_ENERGY_INDEX', energy_index, rec_start= mode-1
      calibration.energy_index= energy_index

      hyd_cdf_varget, CDF, 'DELTA_TIME', delta_time, rec_start= mode-1
      calibration.delta_time= delta_time

;     find electron and ion indeces
      rele= where( energy_index(*,0) lt 0 )      
      rion= where( energy_index(*,0) gt 0 )

      biasname= string( mode, ele_bias(0), ele_bias(1), $
                        ion_bias(0), ion_bias(1), $
                        format= $
                        "(i3.3, '_e_', i2.2, '_', i2.2, "+ $
                        "'_i_', i2.2, '_', i2.2, ' ')" ) 

      hyd_cdf_varget, CAL, 'RGAINS_'+biasname, rgains
      hyd_cdf_varget, CAL, 'IGAINS_'+biasname, igains
      hyd_cdf_varget, CAL, 'QEFF_'+biasname, q_eff
      hyd_cdf_varget, CAL, 'IB_TRIM', ibtrim_ele
      if cdf_varexist(cal, 'IB_TRIM_ION') then begin
          hyd_cdf_varget, CAL, 'IB_TRIM_ION', ibtrim_ion
      endif else begin
          ibtrim_ion=replicate(1.0,2)
      endelse

      ibtrim=igains*1.0
      r1=where(calibration.energy_index[*,0] lt 0, nr)
      r2=where(calibration.energy_index[*,1] lt 0, nr)
      if nr gt 0 then begin
          ibtrim[r1,0]=ibtrim_ele[0]
          ibtrim[r2,1]=ibtrim_ele[1]
      endif
      r1=where(calibration.energy_index[*,0] gt 0, nr)
      r2=where(calibration.energy_index[*,1] gt 0, nr)
      if nr gt 0 then begin
          ibtrim[r1,0]=ibtrim_ion[0]
          ibtrim[r2,1]=ibtrim_ion[1]
      endif


      hyd_cdf_varget, CDF, 'BOX_NUMBER', box
      box=box-1
      
      for idet=0,11 do begin          
          calibration.gain_factor(*,idet)= $
            rgains(*,idet) * igains(*,box(idet)) *ibtrim(*,box(idet)) / $
            q_eff(*,box(idet))
      endfor

      if ( calibration.CDF ne CDF or calibration.CAL ne CAL ) then begin
          cdf_control, CDF, var='BACK_ELE', get_var_info=r
          maxrec= r.maxrec

          hyd_cdf_varget, CDF, 'BACK_ELE', back_ele, rec_count=maxrec+1
          calibration.back_ele(*,0:maxrec) = back_ele

          hyd_cdf_varget, CDF, 'BACK_ION', back_ion, rec_count=maxrec+1
          calibration.back_ion(*,0:maxrec) = back_ion

          hyd_cdf_varget, CDF, 'DEAD_TIME', dead_time

          calibration.dead_time= dead_time
          
          calibration.CDF=CDF
          calibration.CAL=CAL

          correct= fltarr( 384,12 )

          if keyword_set( sigma_cc ) then begin
              r= spectra_l1_sigma_cc( /init, cdf=CDF, cal=CAL, $
                         mode= mode, ele_bias=ele_bias, ion_bias=ion_bias )
              calibration.calc_sigma_cc=1
          endif else begin
              calibration.calc_sigma_cc=0
          endelse

      endif

      return, 'Hello!'
  endif

  correct(*)= float(raw)

; correct for dead time  

  dead_time0= calibration.dead_time / calibration.delta_time
  for idet=0,11 do begin
      dead_time_correction= 1.0/(1.0-raw(*,idet) * dead_time0(idet))
      correct(*,idet) = correct(*,idet) * dead_time_correction
  endfor

; subtract background
  back_ele= calibration.back_ele(*,recstart)
  back_ion= calibration.back_ion(*,recstart)
  for idet=0,11 do begin
      correct(rele,idet) = $
        ( correct(rele,idet) - back_ele(idet) ) > 0.0
      correct(rion,idet) = $
        ( correct(rion,idet) - back_ion(idet) ) > 0.0
  endfor

; gains correction
  correct= correct * calibration.gain_factor

  if calibration.calc_sigma_cc then $
    sigma_cc = spectra_l1_sigma_cc( raw, back_ele, back_ion )
  
  return, correct

end
