function spectra_l1_pitch, phase_start, thetab, phib, bvalid, $
                           mode=mode, rele=rele_in, rion=rion_in, $
                           cdfcal=CAL, init=init
;  returns the pitch angles for a given block

  common spectra_l1_pitch_common, theta_ele, phi_ele, $
    theta_ion, phi_ion, $
    phi_offset, rele, rion

  if keyword_set( init ) then begin
      hyd_cdf_varget, CAL, 'THETA_ELE_RP', theta_ele ; fltarr(12)
      hyd_cdf_varget, CAL, 'PHI_ELE_RP', phi_ele ; fltarr(12)
      hyd_cdf_varget, CAL, 'THETA_ION_RP', theta_ion ; fltarr(12)
      hyd_cdf_varget, CAL, 'PHI_ION_RP', phi_ion ; fltarr(12)
      hyd_cdf_varget, CAL, 'PHI_OFFSET', phi_offset, rec_start= mode-1 ;fltarr(384)
      rele= rele_in
      rion= rion_in

      return, -1
      
  endif else begin

      pitch= fltarr( 384, 12 )

      rv= where( bvalid ne 0 )
      rnv= where( bvalid eq 0 )
      if rv(0) ne -1 then begin
          sin_thetab= sin(thetab(rv))
          bhat=[[sin_thetab*cos(phib(rv))], $
                [sin_thetab*sin(phib(rv))], [cos(thetab(rv))] ]
          
          phidet= fltarr( 384 )
          dethat= fltarr( 384, 3 )
          theta= fltarr(384)
          for idet=0,11 do begin
              phidet(rele)= phi_ele(idet) 
              phidet(rion)= phi_ion(idet) 
              theta(rele)= theta_ele(idet)
              theta(rion)= theta_ion(idet)
              sin_theta= sin( theta )
              dethat(*,0)= sin_theta * cos( phidet )
              dethat(*,1)= sin_theta * sin( phidet )
              dethat(*,2)= cos( theta )
              
              pitch(rv,idet)= total((bhat(*,*)*dethat(rv,*)),2)     
          endfor   
          
          pitch=acos(pitch)
      endif 
      
      if rnv(0) ne -1 then begin
          pitch(rnv,*)=1e20
      endif

  endelse

  return, pitch
end
