function spectra_l1_sigma_cc, icounts, back_ele, back_ion, $
                              init=init, CDF=CDF_in, CAL=CAL_in, $
                              mode=mode_in, $
                              ele_bias=ele_bias, ion_bias=ion_bias

;     Author Pamela Puhl-Quinn, 8/5/97
;     modified for PAPCO use, 9/18/97 Jeremy B Faden
;

; DEFINITIONS:
; c_prime = decompression corrected raw counts
; c_prime2 = add dead-time correction
; c_prime3 = add background correction

;---------------------------------------------------------------------

   common spectra_l1_sigma_cc, $
     dvov, delta_t_d12, $
     box, len, energy_index_box, $
     rg12, ig2, eff2, sigma_rg12, sigma_ig2, sigma_eff2, $
     sigma_cc


   if keyword_set( init ) then begin
       CDF= CDF_in
       CAL= CAL_in
       mode= mode_in - 1

       box=[ 0,1,0,1,0,1,0,1,0,1,0,1 ]

       hyd_cdf_varget, CAL, 'CAL_ENERGY_SEQ_BOX_SIGMA', rec_start=mode, $
         energy_sigma
    
       hyd_cdf_varget, CAL, 'CAL_ENERGY_SEQ_BOX', rec_start= mode, $
         energy

       hyd_cdf_varget, CAL, 'CAL_ENERGY_INDEX', rec_start=mode, $
         energy_index_box

       rnv= where( energy_index_box(*,box) eq 0 )
       if rnv(0) ne -1 then begin
           energy( rnv, 0 ) = 0.01
           energy( rnv, 1 ) = 0.01 ; these are masked anyway.
       endif

;      dvov = .5 deoe where deoe is the fractional uncertainty in the 
;        calibrated energies
       dvov = .5 * energy_sigma(*,box) / abs(energy(*,box))

       hyd_cdf_varget, CAL, 'DELTA_TIME', rec_start=mode, delta_time
       hyd_cdf_varget, CDF, 'DEAD_TIME', deadtime
       delta_t_d12= deadtime / delta_time

       hyd_cdf_varget, CAL, 'LENGTH', rec_start=mode, len
       len= len-1
       
       biasname= string( mode+1, ele_bias(0), ele_bias(1), $
                        ion_bias(0), ion_bias(1), $
                        format= $
                        "(i3.3,'_e_',i2.2,'_',i2.2,'_i_',i2.2,'_',i2.2,' ')" ) 
       
      hyd_cdf_varget, CAL, 'RGAINS_'+biasname, rg12
      hyd_cdf_varget, CAL, 'IGAINS_'+biasname, ig2
      hyd_cdf_varget, CAL, 'QEFF_'+biasname, eff2
      
      hyd_cdf_varget, CAL, 'RGAINS_SIGMA_'+biasname, sigma_rg12
      hyd_cdf_varget, CAL, 'IGAINS_SIGMA_'+biasname, sigma_ig2
      hyd_cdf_varget, CAL, 'QEFF_SIGMA_'+biasname, sigma_eff2

      sigma_cc= fltarr(384,12)

      return, 'Hello!'

  endif     

   FOR idet = 0,11 DO BEGIN 
      
       ibox = box(idet)
      
; Define the raw counts and uncertainty (compression already in c_raw!)
       c_prime = icounts(*,idet)
; Note that c_prime could have bad data in it, but it is filtered
; below by rion and rele
      
       rv= where( c_prime ge 0 )

       dN = (c_prime(rv) GE 8256L)*128 + $
         (c_prime(rv) GE 2080L AND c_prime(rv) LE 8223L)*64 + $
         (c_prime(rv) GE 528L AND c_prime(rv) LE 2063L)*32 + $
         (c_prime(rv) LE 511L)*1
   
       sigma_c_prime = sqrt(float(long(c_prime(rv)-fix(.5*dN))) $
                            + (dN^2)/12.)

; Correct for dead time and propagate the error
      delta_t_d = delta_t_d12(idet)
               
      c_prime2 = fltarr( len+1 )
      sigma_c_prime2 = fltarr( len+1 )

      c_prime2(rv) = c_prime(rv)/(1. - c_prime(rv)*delta_t_d)
      
      sigma_c_prime2(rv) = sigma_c_prime/(1. - c_prime(rv)*delta_t_d)^2
               
; Correct for background and propagate the error relative gains, 
; and interbox gains and propagate the error

      rele = where(energy_index_box(0:len,ibox) LT 0 AND c_prime(0:len) GE 0)
      rion = where(energy_index_box(0:len,ibox) GT 0 AND c_prime(0:len) GE 0)

; Ions only have background correction, no gains

      bg = back_ion(idet)
      sigma_bg = sqrt(bg)/6.
      
      sigma_cc(rion,idet) = sqrt(sigma_c_prime2(rion)^2+sigma_bg^2)
                  
; Electrons have two different gain corrections, depending on which
; level1 file is used

      bg = back_ele(idet)
      sigma_bg = sqrt(bg)/6.
      c_prime3 = (c_prime2(rele) - bg) >  0.0
      sigma_c_prime3 = sqrt(sigma_c_prime2(rele)^2+sigma_bg^2)


      rg = rg12(rele,idet)
      ig = ig2(rele,ibox)
      eff =  eff2(rele,ibox)

      sigma_rg = sigma_rg12(rele,idet)
      sigma_ig = sigma_ig2(rele,ibox)
      sigma_eff = sigma_eff2(rele,ibox)
      
      good =  where(eff NE 0)
      
      IF (good(0) NE -1) THEN BEGIN
          
          cc = ig(good)/eff(good)*rg(good)*c_prime3(good)
          der_c_prime3 = ig(good)/eff(good)*rg(good)
          der_ig = 1./eff(good)*rg(good)*c_prime3(good)
          der_eff = -ig(good)/(eff(good)^2)*rg(good)*c_prime3(good)
          der_rg = ig(good)/eff(good)*c_prime3(good)
          
          sigma_cc(rele(good),idet) = $
            sqrt( $
                  (sigma_c_prime3(good)*der_c_prime3)^2 + $
                  (sigma_ig(good)*der_ig)^2 + $
                  (sigma_rg(good)*der_rg)^2 + $
                  (sigma_eff(good)*der_eff)^2 )
          
      ENDIF ELSE BEGIN
          
          cc = ig/eff*rg*c_prime3
          der_c_prime3 = ig/eff*rg
          der_ig = 1./eff*rg*c_prime3
          der_eff = -ig/(eff^2)*rg*c_prime3
          der_rg = ig/eff*c_prime3
          
          sigma_cc(rele,idet) = $
            sqrt( $
                  (sigma_c_prime3*der_c_prime3)^2 + $
                  (sigma_ig*der_ig)^2 + $
                  (sigma_rg*der_rg)^2 + $
                  (sigma_eff*der_eff)^2 )
          
      ENDELSE 
         
   ENDFOR                       ; detector loop
   
   return, sigma_cc
   
END 
