pro stamp_info, label, color=color, routine=routine, charsize=charsize

  if n_elements( color ) eq 0 then color= !p.color
  if n_elements( routine ) eq 0 then routine=1
  if not keyword_set(charsize) then charsize=!p.charsize
  if charsize eq 0. then charsize=1.0
  if n_elements(label) eq 0 then label=''

  timestamp= systime()

  if (getenv('TERM') eq 'vt300-80') then begin
      chsize = 1.0*charsize
      xpos = 0.975
  endif else BEGIN
      chsize = 0.5*charsize
      xpos = 1.0
  ENDELSE 
  
  help, calls=a
  a1= a(1)
  if strtrim(a1,2) eq '$MAIN$' then begin
      dotprofile= ''
  endif else begin
      a= str_sep(a1,'<')
      dotprofile= (str_sep(a(1),'('))(0)      
  endelse
  
  if routine then begin
      stamp= dotprofile + ' ' + timestamp + ' ' + label
  endif else begin
      stamp= timestamp + ' ' + label
  endelse
  
  xyouts, xpos,0.5,/norm,/noclip,orient=90.0,align=0.5,size=chsize,stamp
  return
end
