function unwrap_phi, phi0, degrees=degrees, digital_degrees=digital_degrees
;
;   Unwrap Phi angle.
;
;
pi2=2*!pi
if keyword_set(degrees) then pi2=360.0d0
if keyword_set(digital_degrees) then pi2=256
phi=phi0
if size(phi, /type) eq 1 then phi=long(phi)
;;;rnz=where(phi ne 0)
rnz=lindgen(n_elements(phi))
phi_nz=phi(rnz)
n=n_elements(phi_nz)
dphi=phi_nz(1:n-1)-phi_nz(0:n-2)
r=where(abs(dphi) gt 0.75*pi2, nr)
if nr gt 0 then begin
    nwrap=0
    for i=0L,nr-2 do begin
        if dphi(r(i)) gt 5 then nwrap=nwrap-1 else nwrap=nwrap+1
        phi_nz(r(i)+1:r(i+1))=phi_nz(r(i)+1:r(i+1))+nwrap*pi2
    endfor
    i=nr-1
    if dphi(r(i)) gt 5 then nwrap=nwrap-1 else nwrap=nwrap+1
    phi_nz(r(i)+1:n-1)=phi_nz(r(i)+1:n-1)+nwrap*pi2
endif

phi(rnz)=phi_nz

return, phi
end
