;$Id: hydra_fitf_v1_11.tar,v 1.1.1.1 2002/04/10 15:24:55 jbf Exp $
function confidence, level, nu_in
;+
; NAME:
;       confidence
;
; PURPOSE:
;       
;       This function returns the chi-square level for level%
;       confidence given nu_in degrees of freedom
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;
;       result = confidence(level,nu_in)
;
; INPUTS:
;       level:  The desired confidence level in percent.
;
;       nu_in:  The number of degrees of freedom in the chi-square
;               distribution. 
;
; OUTPUTS:
;       result: The value of the chi-square level surface
;               corresponding to a nu_in degree of freedom chi-square
;               distribution at level percent confidence
;
; PROCEDURE:
;       
;       Use bisection rootfinding to get the appropriate level from
;       the known partial integral of the chi-square distribution.
;       That is igamma(deg of freedom/2, level in percent/100/2) where
;       igamma is the imcomplete gamma function.
;
; EXAMPLE:
;
;        dchisq_lim = confidence(68.3, m)   ;one sigma error level on
;                                           ;m degrees of freedom
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;-

lacc = 0.00001d0
nuby2 = double(nu_in)/2.
pinput = double(level)/100.
limitl = .9d0
limith = 1000.d0

;bracket a root
;pl = pinput-(igamma(nuby2, limitl/2.)) 
;ph = pinput-(igamma(nuby2, limith/2.)) 
;factor = 1.6d0
;FOR i = 1, 50 DO BEGIN
;    IF (pl*ph LT 0.0) THEN GOTO, bracket
;    IF (abs(pl) LT abs(ph)) THEN BEGIN
;        limitl = limitl+factor*(limitl-limith)
;        pl = pinput-(igamma(nuby2, limitl/2.)) 
;    ENDIF ELSE BEGIN
;        limith = limith+factor*(limith-limitl)
;        ph = pinput-(igamma(nuby2, limith/2.)) 
;    ENDELSE
;ENDFOR
;print, 'bracketing loop limit reached in confidence.pro'
;stop    ;;could put return,-1 here to return a sentinal that this 
;        ;;function failed 

;bracket:                      ;continue with root find

;find the root
p =   pinput-(igamma(nuby2, limitl/2.)) 
pmid = pinput-(igamma(nuby2, limith/2.))
;IF (p*pmid GE 0.0d0) THEN BEGIN
;    print, 'root is not bracketed in confidence.pro'
;    stop
;ENDIF

IF p LT 0.0 THEN BEGIN
    dl = (limitl-limith)/2.
    rtb = limith
ENDIF ELSE BEGIN
    dl = (limith-limitl)/2.
    rtb = limitl
ENDELSE

FOR i = 0, 40 DO BEGIN
    dl = dl/2.
    lmid = rtb+dl
    pmid = (igamma(nuby2, lmid/2.)) - pinput
    IF (pmid LE 0.0) THEN rtb = lmid
    IF ((abs(dl) LT lacc) OR (pmid EQ 0.0)) THEN return, rtb
ENDFOR

print, 'error too many bisections in confidence.pro'
stop

return, -1.

END

;;IF ((nu LT 1) OR (nu GT 20)) THEN BEGIN
;;    print, 'Number of degrees of freedom out of table range.'
;;    return, -1
;;ENDIF
;;CASE confidence of
;;    80: BEGIN
;;        chi2nu = [1.642, 1.609, 1.547, 1.497, 1.458, 1.426, 1.400, 1.379, $
;;                  1.360, 1.344, 1.330, 1.318, 1.307, 1.296, 1.287, 1.279, $
;;                  1.271, 1.264, 1.258, 1.252]
;;    END
;;    70: BEGIN
;;        chi2nu = [1.074, 1.204, 1.222, 1.220, 1.213, 1.205, 1.198, 1.191, $
;;                  1.184, 1.178, 1.173, 1.168, 1.163, 1.159, 1.155, 1.151, $
;;                  1.148, 1.145, 1.142, 1.139]
;;    END
;;    60: BEGIN
;;        chi2nu = [0.708, 0.916, 0.982, 1.011, 1.026, 1.035, 1.040, 1.044, $
;;                  1.046, 1.047, 1.048, 1.049, 1.049, 1.049, 1.049, 1.049, $
;;                  1.048, 1.048, 1.048, 1.048]
;;    END
;;    50: BEGIN
;;        chi2nu = [0.455, 0.693, 0.789, 0.839, 0.870, 0.891, 0.907, 0.918, $
;;                  0.927, 0.934, 0.940, 0.945, 0.949, 0.953, 0.956, 0.959, $
;;                  0.961, 0.963, 0.965, 0.967]
;;    END
;;    ELSE: BEGIN
;;        print, 'Selected confidence level undefined.'
;;        return, -1
;;    END
    
;;e