pro draw_hydra_spp, panelVector, currPlotInfo, orbitNo, $
                     get_data_call, slice_type, IsRead

common extra, extra_PlotInfo
common time, xut1, xut2
common get_error, get_err_no, get_err_msg
common hydra_spp_data, spp_header, spp_data

if n_elements( spp_header ) eq 0 then begin
    spp_header={ $
                 start_time:long(-1), $
                 end_time:long(-1), $
                 data_species:fix(-1), $
                 data_res:fix(-1), $
                 data_var:fix(-1), $
                 data_frame:fix(-1), $
                 data_version:float(-1.00), $
                 reload_flag:fix(1) $
               }
endif

get_data_call="r_hydra_spp"

if hydra_new_papco() then begin
    n=(papco_slice_value('USER Hydra fV Slice')>0)
    slice_type= 1+16
endif else begin
    slice_type= 1
endelse

YesLoad= $
  spp_header.start_time gt xut1    or  $
  spp_header.end_time lt xut2      or  $
  spp_header.data_species ne currPlotInfo.ioptions(0) or $
  spp_header.data_res ne currPlotInfo.ioptions(1) or $
  spp_header.data_var ne currPlotInfo.ioptions(2) or $
  spp_header.data_frame ne currPlotInfo.ioptions(3) or $
  spp_header.reload_flag        ; set with panel

IF YesLoad THEN BEGIN
    spp_header.start_time=xut1
    spp_header.end_time=xut2
    spp_header.data_species = currPlotInfo.ioptions(0)
    spp_header.data_res = currPlotInfo.ioptions(1)
    spp_header.data_var = currPlotInfo.ioptions(2)
    spp_header.data_frame = currPlotInfo.ioptions(3)
    spp_header.reload_flag=1
    r_hydra_spp
    IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                              panelVector, orbitNr, $
                              currPlotInfo.typeVector, $
                              currPlotInfo.channel) $
      THEN BEGIN
        spp_header.reload_flag=0
        IsRead=1
        p_hydra_spp, panelVector, currPlotInfo.typeVector, $
          _EXTRA=extra_PlotInfo
    ENDIF
ENDIF ELSE BEGIN
    p_hydra_spp, panelVector, currPlotInfo.typeVector, $
      _EXTRA=extra_PlotInfo
ENDELSE

END

