pro fft_draw, print=print, exceptionString=exceptionString, debug=debug
  COMMON share
  widget_control, comprs_tlb, get_uvalue=state
  st_time = state.var.start_doy96 - fix(state.var.start_doy96)
  et_time = state.var.end_doy96   - fix(state.var.end_doy96)

  if keyword_set(print) then begin
      set_plot, 'ps'
      filename=gen_time_string(fix(state.var.start_doy96)) + $
               state.var.operation + gen_time_string(st_time) + '-' + $
                                     gen_time_string(et_time) + '.ps'
      device, filename=filename, xsize=7.5, ysize=7,/inches, /color, /landscape
  endif else if state.var.operation eq 'compress' then begin
      hyd_set_plot, 'x'  ; hyd_set_plot uses 'win' for windows and 'x' for unix
      wset, state.id.comprs_plot_area
      !p.multi = [0,1,1]

; desensitize polytrope Print button if new date/time data entered
      if widget_info( state.id.poly_tlb, /valid_id ) then begin 
          widget_control, state.id.poly_button_p, sensitive=0
      end

  endif else if state.var.operation eq 'poly' then begin
      hyd_set_plot, 'x'  ; hyd_set_plot uses 'win' for windows and 'x' for unix
      wset, state.id.poly_plot_area
      !p.multi = [0,1,2]

; desensitize polytrope Print button if new date/time data entered
      if widget_info( state.id.poly_tlb, /valid_id ) then begin
          widget_control, state.id.poly_button_p, sensitive=1
      end
  endif

  !p.position=0
  !p.noerase=0
  !p.background = get_color_index('white')
  !p.color      = get_color_index('black')
  erase

  sd_temp = gen_time_string( fix(state.var.start_doy96 ))
  st_temp = gen_time_string( st_time )
  ed_temp = gen_time_string( fix(state.var.end_doy96 ))
  et_temp = gen_time_string( et_time )
  widget_control, state.id.sd, set_value=sd_temp
  widget_control, state.id.st, set_value=st_temp
  widget_control, state.id.ed, set_value=ed_temp
  widget_control, state.id.et, set_value=et_temp

err_hdl=''

  if debug eq 0 then begin

      which, 'compress.pro'
      which, 'dd_findnorm_with_errors.pro'
      which, 'new_error_flags_jds.pro'
      which, 'new_gen_fit.pro'
      print, 'START =', gen_time_string(state.var.start_doy96)
      print, 'END   =', gen_time_string(state.var.end_doy96)
      print, ''

      case state.var.operation of
          'compress': begin
              compress, $
                 state.var.start_doy96, $
                 state.var.end_doy96, $
                 err_hdl=err_hdl

;              print,'ERR_HDL=',err_hdl
              if err_hdl ne 'No errors' then begin
                  xdisplayfile, $
                   '/opt/hydra/papco/polar_hydra/papco_interface/fft.err', $
                    text=err_hdl, $     
                    title='Application Exception',/modal
              end
          end

          'poly':     polytr,     state.var.start_doy96, state.var.end_doy96

          else: print, 'NO OPERATION PERFORMED'
      endcase
  endif else begin
      case state.var.operation of
          'compress': plot, indgen(100)
          'poly':     plot,-indgen(100)
          else: print, 'NO OPERATION PERFORMED'
      endcase
  endelse

  print, 'Operation performed = ',state.var.operation
  print, 'START =', gen_time_string(state.var.start_doy96)
  print, 'END   =', gen_time_string(state.var.end_doy96)
  print, ''

  if keyword_set(print) then begin
      device, /close
      r= widget_message(['Send this file to the printer of your choice:',$
         filename], /info )
      set_plot, 'x'
  endif

  state.var.operation='compress'
  widget_control, state.id.comprs_tlb, set_uvalue=state
end
