pro fft_event, event
  COMMON share
  widget_control, comprs_tlb, get_uvalue=state
;  widget_control, event.top, get_uvalue=state
  widget_control, event.id,  get_uvalue=uval


  print,'EVENTS=',event.top,event.id

  case uval of 

      'compressible': begin
          state.var.operation='compress'
          redraw=1
      end

      'polytropic': begin

          if not widget_info( state.id.poly_tlb, /valid_id) $
          then begin

; Top level base
              state.id.poly_tlb= widget_base( xoffset=300, yoffset=530, $
                                  title='Polytrope', /col )

; Plot area
              poly_plot_area = $
                           widget_draw(state.id.poly_tlb, xsize=400, ysize=400)
              widget_control, poly_plot_area, /realize
              widget_control, poly_plot_area, get_value=poly_plot_area
              state.id.poly_plot_area = poly_plot_area

; Button area
              poly_but_area1= widget_base( state.id.poly_tlb, /row )
              state.id.poly_but_area1=poly_but_area1
              bu= widget_button( poly_but_area1, value='Print', $
                                 uvalue='print_poly')
              state.id.poly_button_p=bu

              bu= widget_button( poly_but_area1, value='Close', $
                                 uvalue='close_poly')
              state.id.poly_button_c=bu
              xmanager, 'fft', state.id.poly_tlb
          endif

          print,''
          print,'state.id.poly_tlb      =', strtrim(state.id.poly_tlb,2)
          print,'state.id.poly_plot_area= ',strtrim(state.id.poly_plot_area,2)

          state.var.operation='poly'
          redraw=1
      end

      'operation_X': begin
          state.var.operation='noop'
          redraw=1
      end



      'Print': begin
          state.var.operation = 'compress'
          fft, /print
      end

      'Close': begin
          if widget_info( state.id.poly_tlb, /valid_id ) then begin
             widget_control, state.id.poly_tlb, /destroy
          end
          widget_control, event.top, /destroy
          return
      end

      'Help': begin
          xdisplayfile, $
               '/opt/hydra/papco/polar_hydra/papco_interface/fft.help', $
               title='papco Online-Help', group=event.top         
      end

     'Draw': begin
          state.var.operation = 'compress'
          redraw=1
      end


; desensitize polytrope Print button if new date/time data entered.
      'start_date_uval': begin
          if widget_info(state.id.poly_tlb, /valid_id) then begin
              widget_control, state.id.poly_button_p, sensitive=0
          end

          st_time = state.var.start_doy96 - fix(state.var.start_doy96)
          state.var.start_doy96 = gen_time(date=event.value) + st_time
          state.var.operation = 'compress'
          redraw=1
      end

; desensitize polytrope Print button if new date/time data entered.
      'start_time_uval': begin
          if widget_info(state.id.poly_tlb, /valid_id) then begin
              widget_control, state.id.poly_button_p, sensitive=0
          end

          state.var.start_doy96 = fix(state.var.start_doy96) + $
                                  gen_time(time=event.value)
          state.var.operation = 'compress'
          redraw=1
      end


; desensitize polytrope Print button if new date/time data entered.
      'end_date_uval': begin
          if widget_info(state.id.poly_tlb, /valid_id) then begin
              widget_control, state.id.poly_button_p, sensitive=0
          end

          et_time = state.var.end_doy96 - fix(state.var.end_doy96)
          state.var.end_doy96 = gen_time(date=event.value) + et_time
          state.var.operation = 'compress'
          redraw=1
      end

; desensitize polytrope Print button if new date/time data entered.
      'end_time_uval': begin
          if widget_info(state.id.poly_tlb, /valid_id) then begin
              widget_control, state.id.poly_button_p, sensitive=0
          end

          state.var.end_doy96 = fix(state.var.end_doy96) + $
                              gen_time(time=event.value)
          state.var.operation = 'compress'
          redraw=1
      end



; Polytrope Buttons
      'print_poly': begin
          state.var.operation='poly'
          widget_control, state.id.comprs_tlb , set_uvalue=state
          fft_draw, /print, debug=state.var.debug
          return
      end

      'close_poly': begin
          widget_control, event.top, /destroy
          return
      end

      else: begin
          message, 'uval not recognized: '+uval, /cont
      end
  end      

  widget_control, state.id.comprs_tlb, set_uvalue=state
;  widget_control, event.top, set_uvalue=state

  if keyword_set( redraw ) then fft

  return
end
