function hyd_dc, tres_in, type
; "hydra data context" -- given tres and type, return the
; of the data space to use.

common time, xut1_in, xut2_in

if n_elements(xut1_in) eq 0 then begin
    xut1= 0
    xut2= 86400
endif else begin
    xut1= xut1_in
    xut2= xut2_in
endelse

if tres_in eq 0 then begin      ; autoselect feature
    autoselect_threshold= getenv('hydra_autoselect_threshold')
    if autoselect_threshold ne '' then $
      autoselect_threshold= float( autoselect_threshold ) $
    else $
      autoselect_threshold= 10  ; minutes
    if (xut2-xut1) gt autoselect_threshold*60 then $
      tres=0 else $             ; survey
      tres=1                    ; level1
endif else tres= tres_in-1

return, tres*5+type
end
